#!/usr/bin/python

'''
 File:        MME_Batch_Multi_File.py
 Description: This script encode all videos files in a directory using a
              queue file as input.
			  
 These coded instructions, statements, and computer programs contain proprietary
 information of Nintendo and/or its licensed developers and are protected by
 national and international copyright laws. They may not be disclosed to third
 parties or copied or duplicated in any form, in whole or in part, without the
 prior written consent of Nintendo.

 The content herein is highly confidential and should be handled accordingly. 

 Copyright (C) 2013 Nintendo, All rights reserved.
 '''
 
import string
import os
import subprocess
import argparse
import time
import re
from subprocess import call

#Use this program to encode all videos files in a directory with the Mobiclip Multicore Encoder

parser = argparse.ArgumentParser(description='Encode videos using the Mobiclip Multicore Encoder.')
parser.add_argument("-c", "--clean", help="clean output directory", action="store_true")
parser.add_argument('queue', metavar='<queue>', type=str, nargs=1,
                help='queue file to encode video')
parser.add_argument('input', metavar='<input>', type=str, nargs=1,
                help='input directory')
parser.add_argument('output', metavar='<output>', type=str, nargs=1,
                help='output directory')
				
args = parser.parse_args()

videoFullDirName = args.input[0]
videoOutFullDirName = args.output[0]

#Check if MultiCoreEncoder is installed
if not os.environ.get('MOBICLIP_MULTICORE_ENCODER_PATH'):
	print "MultiCoreEncoder is not installed"
	bCheck = False

#Check if input directory exist
if os.path.isdir(videoFullDirName):
	bCheck = True
else:
	print "input directory is missing"
	bCheck = False

#Create output directory if not exist
if not os.path.isdir(videoOutFullDirName):
	os.makedirs(videoOutFullDirName)

#Check if queue file exist
if not os.path.isfile(args.queue[0]):
	print "queue file is missing"
	bCheck = False
	
if bCheck:   
	bEncode = True
	#delete all output directory's files
	if args.clean:
		for f in os.listdir(videoOutFullDirName):
			if os.path.isfile(videoOutFullDirName + "\\" + os.path.basename(f)):
				os.remove(videoOutFullDirName + "\\" + os.path.basename(f))
		
	for files in os.listdir(videoFullDirName):
		if files.endswith(".mp4") or files.endswith(".avi") or files.endswith(".mkv") or files.endswith(".mov") :
			
			bEncode = True
			inputFile = open(args.queue[0], 'r')
			queueFile = inputFile.read()
			inputFile.close()
	
			videoFullDirName = os.path.abspath(args.input[0])
			videoOutFullDirName = os.path.abspath(args.output[0])
			videoFullFilename = videoFullDirName + "\\" + os.path.basename(files)
			videoFilename = os.path.basename(videoFullFilename)
            
			#Check if input file has already been encoded
			timesource = os.path.getmtime(videoFullFilename)
			if os.path.exists(videoOutFullDirName + "\\" + files[0:-4] + ".moflex"):
				timetarget = os.path.getmtime(videoOutFullDirName + "\\" + files[0:-4] + ".moflex")
				if timesource < timetarget:
					bEncode = False
					print "Already encoded : " + videoFilename
				else:
					bEncode = True
			else:
				if os.path.exists(videoOutFullDirName + "\\" + files[0:-4] + ".avi"):
					timetarget = os.path.getmtime(videoOutFullDirName + "\\" + files[0:-4] + ".avi")
					if timesource < timetarget:
						bEncode = False
						print "Already encoded : " + videoFilename
					else:
						bEncode = True
				
            
			if bEncode:
				videoFullDirName = videoFullDirName.replace('\\' , '\\\\');
				videoOutFullDirName = videoOutFullDirName.replace('\\' , '\\\\');
				videoFullFilename = videoFullFilename.replace('\\' , '\\\\');
        
				queueFile = re.sub(r"InputFilename(.*),",r"InputFilename" + '"' + " : " + '"' + videoFullFilename.replace('\\' , '\\\\') + '"' + ",",queueFile)
				queueFile = re.sub(r"Filenames(.*),",r"Filenames" + '"' + " : [ " + '"' + videoFilename + '"' + "],",queueFile)
				
				queueFile = re.sub(r"Duration(.*),",r"Duration" + '"' + " : " + '""' + ",",queueFile)
				queueFile = re.sub(r"Status(.*),",r"Status" + '"' + " : " + '0' + ",",queueFile)
				queueFile = re.sub(r"TimeEnded(.*),",r"TimeEnded" + '"' + " : " + '""' + ",",queueFile)
				queueFile = re.sub(r"TimeStarted(.*)",r"TimeStarted" + '"' + " : " + '""',queueFile)
				
				
				#If output file is a moflex
				if queueFile.find('"MobiclipEncoder"') > 0:
					queueFile = re.sub(r"Directory(.*),",r"Directory" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
					queueFile = re.sub(r"OutputDirectory(.*),",r"OutputDirectory" + '"' + " : " + '"' + videoOutFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
					queueFile = queueFile.replace('"FilenameBitrate" : true,', '"FilenameBitrate" : false,') 
					queueFile = queueFile.replace('"FilenameDraft" : true,', '"FilenameDraft" : false,') 
					queueFile = queueFile.replace('"FilenameFps" : true,', '"FilenameFps" : false,') 
					queueFile = queueFile.replace('"FilenamePass" : true,', '"FilenamePass" : false,')
					queueFile = queueFile.replace('"FilenameResolution" : true,', '"FilenameResolution" : false,')
				
				#If output file is an avi
				if queueFile.find('"AviOutput"') > 0:
					queueFile = re.sub(r"Directory(.*),",r"OutputDir_Temp" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile,1)
					queueFile = re.sub(r"Directory(.*),",r"Directory" + '"' + " : " + '"' + videoOutFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
					queueFile = re.sub(r"OutputDir_Temp(.*),",r"Directory" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
					queueFile = re.sub(r"Suffix(.*),",r"Suffix" + '"' + " : " + '""' + ",",queueFile)
                
				
				outputFile = open('Temp.queue', 'w')
				outputFile.write(queueFile)
				outputFile.close()
        
				#Launch the encoding
				MMEPath = os.environ['MOBICLIP_MULTICORE_ENCODER_PATH']
				print "Encoding : " + videoFilename
				retcode = call ([MMEPath + "\MobiclipMulticoreEncoder.exe", "-q", "Temp.queue"])
				if not retcode == 0:
					print "Error encoding video : " + videoFilename
				os.remove('Temp.queue')
