#!/usr/bin/python

'''
 File:        MME_Encode.py
 Description: This basic script demonstrates how to encode a video using a
              queue file as input.
			  
 These coded instructions, statements, and computer programs contain proprietary
 information of Nintendo and/or its licensed developers and are protected by
 national and international copyright laws. They may not be disclosed to third
 parties or copied or duplicated in any form, in whole or in part, without the
 prior written consent of Nintendo.

 The content herein is highly confidential and should be handled accordingly. 

 Copyright (C) 2013 Nintendo, All rights reserved.
 '''
 
import string
import os
import subprocess
import argparse
import re

#Use this program to encode a video with the Mobiclip Multicore Encoder

parser = argparse.ArgumentParser(description='Encode a video using the Mobiclip Multicore Encoder.')
parser.add_argument('queue', metavar='<queue>', type=str, nargs=1,
                   help='queue file to encode video')
parser.add_argument('video', metavar='<video>', type=str, nargs=1,
                   help='a source video to encode')
parser.add_argument('output', metavar='<output>', type=str, nargs=1,
                help='output directory')

args = parser.parse_args()
videoOutFullDirName = args.output[0]
bCheck = True

#Check if MultiCoreEncoder is installed
if not os.environ.get('MOBICLIP_MULTICORE_ENCODER_PATH'):
	print "MultiCoreEncoder is not installed"
	bCheck = False

#Create output directory if not exist
if not os.path.isdir(videoOutFullDirName):
	os.makedirs(videoOutFullDirName)

#Check if queue file exist
if not os.path.isfile(args.queue[0]):
	print "queue file is missing"
	bCheck = False
	
if bCheck:
	if len(args.video) > 0:
		inputFile = open(args.queue[0], 'r')
		queueFile = inputFile.read()
		inputFile.close()
		
		videoFullFilename = os.path.abspath(args.video[0]) 
		videoFullDirName = os.path.dirname(videoFullFilename)
		videoOutFullDirName = os.path.abspath(args.output[0])
		videoFilename = os.path.basename(videoFullFilename)
		
		videoFullDirName = videoFullDirName.replace('\\' , '\\\\');
		videoOutFullDirName = videoOutFullDirName.replace('\\' , '\\\\');
		videoFullFilename = videoFullFilename.replace('\\' , '\\\\');
		
		queueFile = re.sub(r"InputFilename(.*),",r"InputFilename" + '"' + " : " + '"' + videoFullFilename.replace('\\' , '\\\\') + '"' + ",",queueFile)
		queueFile = re.sub(r"Filenames(.*),",r"Filenames" + '"' + " : [ " + '"' + videoFilename + '"' + "],",queueFile)
		
		queueFile = re.sub(r"Duration(.*),",r"Duration" + '"' + " : " + '""' + ",",queueFile)
		queueFile = re.sub(r"Status(.*),",r"Status" + '"' + " : " + '0' + ",",queueFile)
		queueFile = re.sub(r"TimeEnded(.*),",r"TimeEnded" + '"' + " : " + '""' + ",",queueFile)
		queueFile = re.sub(r"TimeStarted(.*)",r"TimeStarted" + '"' + " : " + '""',queueFile)
				
		#If output file is a moflex
		if queueFile.find('"MobiclipEncoder"') > 0:
			queueFile = re.sub(r"Directory(.*),",r"Directory" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
			queueFile = re.sub(r"OutputDirectory(.*),",r"OutputDirectory" + '"' + " : " + '"' + videoOutFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
			queueFile = queueFile.replace('"FilenameBitrate" : true,', '"FilenameBitrate" : false,') 
			queueFile = queueFile.replace('"FilenameDraft" : true,', '"FilenameDraft" : false,') 
			queueFile = queueFile.replace('"FilenameFps" : true,', '"FilenameFps" : false,') 
			queueFile = queueFile.replace('"FilenamePass" : true,', '"FilenamePass" : false,')
			queueFile = queueFile.replace('"FilenameResolution" : true,', '"FilenameResolution" : false,')
				
		#If output file is an avi
		if queueFile.find('"AviOutput"') > 0:
			queueFile = re.sub(r"Directory(.*),",r"OutputDir_Temp" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile,1)
			queueFile = re.sub(r"Directory(.*),",r"Directory" + '"' + " : " + '"' + videoOutFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
			queueFile = re.sub(r"OutputDir_Temp(.*),",r"Directory" + '"' + " : " + '"' + videoFullDirName.replace('\\' , '\\\\') + '"' + ",",queueFile)
			queueFile = re.sub(r"Suffix(.*),",r"Suffix" + '"' + " : " + '""' + ",",queueFile)


		outputFile = open('Temp.queue', 'w')
		outputFile.write(queueFile)
		outputFile.close()
		
		MMEPath = os.environ['MOBICLIP_MULTICORE_ENCODER_PATH']
		print "Encoding : " + videoFilename
		MMEProcess = subprocess.Popen([MMEPath + '\MobiclipMulticoreEncoder.exe', '-q', 'Temp.queue'], stdout=subprocess.PIPE,stderr=subprocess.PIPE)
		subprocess.Popen.wait(MMEProcess)
		os.remove('Temp.queue')
	
