/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pools;
import java.util.Comparator;
import net.dermetfan.gdx.physics.box2d.Box2DUtils;
import net.dermetfan.utils.Function;

public class Box2DSprite
extends Sprite {
    private float zIndex;
    private boolean adjustWidth = true;
    private boolean adjustHeight = true;
    private boolean useOriginX;
    private boolean useOriginY;
    private static final Vector2 vec2 = new Vector2();
    public static final Function<Box2DSprite, Object> defaultUserDataAccessor = new Function<Box2DSprite, Object>(){

        public Box2DSprite apply(Object userData) {
            return userData instanceof Box2DSprite ? (Box2DSprite)((Object)userData) : null;
        }
    };
    private static Function<Box2DSprite, Object> userDataAccessor = defaultUserDataAccessor;
    private static Comparator<Box2DSprite> zComparator = new Comparator<Box2DSprite>(){

        @Override
        public int compare(Box2DSprite s1, Box2DSprite s2) {
            return s1.zIndex - s2.zIndex > 0.0f ? 1 : (s1.zIndex - s2.zIndex < 0.0f ? -1 : 0);
        }
    };

    public Box2DSprite() {
    }

    public Box2DSprite(Texture texture, int srcWidth, int srcHeight) {
        super(texture, srcWidth, srcHeight);
    }

    public Box2DSprite(Texture texture, int srcX, int srcY, int srcWidth, int srcHeight) {
        super(texture, srcX, srcY, srcWidth, srcHeight);
    }

    public Box2DSprite(TextureRegion region, int srcX, int srcY, int srcWidth, int srcHeight) {
        super(region, srcX, srcY, srcWidth, srcHeight);
    }

    public Box2DSprite(Texture texture) {
        super(texture);
    }

    public Box2DSprite(TextureRegion region) {
        super(region);
    }

    public Box2DSprite(Sprite sprite) {
        super(sprite);
    }

    public static void draw(Batch batch, World world) {
        Box2DSprite.draw(batch, world, false);
    }

    public static void draw(Batch batch, World world, boolean sortByZ) {
        Array tmpBodies = (Array)Pools.obtain(Array.class);
        world.getBodies(tmpBodies);
        if (sortByZ) {
            ObjectMap tmpZMap = (ObjectMap)Pools.obtain(ObjectMap.class);
            tmpZMap.clear();
            for (Body body : tmpBodies) {
                Box2DSprite tmpBox2DSprite = (Box2DSprite)((Object)userDataAccessor.apply(body.getUserData()));
                if (tmpBox2DSprite != null) {
                    tmpZMap.put((Object)tmpBox2DSprite, (Object)body);
                }
                for (Fixture fixture : body.getFixtureList()) {
                    tmpBox2DSprite = (Box2DSprite)((Object)userDataAccessor.apply(fixture.getUserData()));
                    if (tmpBox2DSprite == null) continue;
                    tmpZMap.put((Object)tmpBox2DSprite, (Object)fixture);
                }
            }
            Array tmpKeys = (Array)Pools.obtain(Array.class);
            ObjectMap.Keys keys = tmpZMap.keys();
            while (keys.hasNext()) {
                tmpKeys.add(keys.next());
            }
            tmpKeys.sort(zComparator);
            for (Box2DSprite key : tmpKeys) {
                Object value = tmpZMap.get((Object)key);
                if (value instanceof Body) {
                    key.draw(batch, (Body)value);
                    continue;
                }
                key.draw(batch, (Fixture)value);
            }
            tmpKeys.clear();
            tmpZMap.clear();
            Pools.free((Object)tmpKeys);
            Pools.free((Object)tmpZMap);
        } else {
            for (Body body : tmpBodies) {
                Box2DSprite tmpBox2DSprite = (Box2DSprite)((Object)userDataAccessor.apply(body.getUserData()));
                if (tmpBox2DSprite != null) {
                    tmpBox2DSprite.draw(batch, body);
                }
                for (Fixture fixture : body.getFixtureList()) {
                    tmpBox2DSprite = (Box2DSprite)((Object)userDataAccessor.apply(fixture.getUserData()));
                    if (tmpBox2DSprite == null) continue;
                    tmpBox2DSprite.draw(batch, fixture);
                }
            }
        }
        tmpBodies.clear();
        Pools.free((Object)tmpBodies);
    }

    public void draw(Batch batch, Fixture fixture) {
        vec2.set(Box2DUtils.position(fixture));
        this.draw(batch, Box2DSprite.vec2.x, Box2DSprite.vec2.y, Box2DUtils.width(fixture), Box2DUtils.height(fixture), fixture.getBody().getAngle());
    }

    public void draw(Batch batch, Body body) {
        float width = Box2DUtils.width(body);
        float height = Box2DUtils.height(body);
        vec2.set(Box2DUtils.minX(body) + width / 2.0f, Box2DUtils.minY(body) + height / 2.0f);
        vec2.set(body.getWorldPoint(vec2));
        this.draw(batch, Box2DSprite.vec2.x, Box2DSprite.vec2.y, width, height, body.getAngle());
    }

    public void draw(Batch batch, float box2dX, float box2dY, float box2dWidth, float box2dHeight, float box2dRotation) {
        batch.setColor(this.getColor());
        batch.draw((TextureRegion)this, box2dX - box2dWidth / 2.0f + this.getX(), box2dY - box2dHeight / 2.0f + this.getY(), this.useOriginX ? this.getOriginX() : box2dWidth / 2.0f, this.useOriginY ? this.getOriginY() : box2dHeight / 2.0f, this.adjustWidth ? box2dWidth : this.getWidth(), this.adjustHeight ? box2dHeight : this.getHeight(), this.getScaleX(), this.getScaleY(), box2dRotation * 57.295776f + this.getRotation());
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
    }

    public boolean isAdjustWidth() {
        return this.adjustWidth;
    }

    public void setAdjustWidth(boolean adjustWidth) {
        this.adjustWidth = adjustWidth;
    }

    public boolean isAdjustHeight() {
        return this.adjustHeight;
    }

    public void setAdjustHeight(boolean adjustHeight) {
        this.adjustHeight = adjustHeight;
    }

    public void setAdjustSize(boolean adjustSize) {
        this.adjustWidth = this.adjustHeight = adjustSize;
    }

    public boolean isUseOriginX() {
        return this.useOriginX;
    }

    public void setUseOriginX(boolean useOriginX) {
        this.useOriginX = useOriginX;
    }

    public boolean isUseOriginY() {
        return this.useOriginY;
    }

    public void setUseOriginY(boolean useOriginY) {
        this.useOriginY = useOriginY;
    }

    public void setUseOrigin(boolean useOrigin) {
        this.useOriginX = this.useOriginY = useOrigin;
    }

    public void setWidth(float width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(float height) {
        this.setSize(this.getWidth(), height);
    }

    public static Comparator<Box2DSprite> getZComparator() {
        return zComparator;
    }

    public static void setZComparator(Comparator<Box2DSprite> zComparator) {
        if (zComparator == null) {
            throw new IllegalArgumentException("zComparator must not be null");
        }
        Box2DSprite.zComparator = zComparator;
    }

    public static Function<Box2DSprite, ?> getUserDataAccessor() {
        return userDataAccessor;
    }

    public static void setUserDataAccessor(Function<Box2DSprite, Object> userDataAccessor) {
        Box2DSprite.userDataAccessor = userDataAccessor != null ? userDataAccessor : defaultUserDataAccessor;
    }
}

