/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.maps.Map;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.CircleMapObject;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.objects.TextureMapObject;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.DistanceJointDef;
import com.badlogic.gdx.physics.box2d.joints.FrictionJointDef;
import com.badlogic.gdx.physics.box2d.joints.GearJointDef;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJointDef;
import com.badlogic.gdx.physics.box2d.joints.PulleyJointDef;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.physics.box2d.joints.RopeJointDef;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.physics.box2d.joints.WheelJointDef;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import net.dermetfan.gdx.maps.MapUtils;
import net.dermetfan.gdx.math.GeometryUtils;
import net.dermetfan.gdx.physics.box2d.Box2DUtils;

public class Box2DMapObjectParser {
    private Aliases aliases = new Aliases();
    public static final Listener.Adapter defaultListener = new Listener.Adapter();
    private Listener listener = defaultListener;
    private float unitScale = 1.0f;
    private boolean ignoreMapUnitScale;
    private boolean ignoreLayerUnitScale;
    private float tileWidth = 1.0f;
    private float tileHeight = 1.0f;
    private boolean triangulate;
    private MapProperties heritage;
    private ObjectMap<String, Body> bodies = new ObjectMap();
    private ObjectMap<String, Fixture> fixtures = new ObjectMap();
    private ObjectMap<String, Joint> joints = new ObjectMap();
    private MapProperties mapProperties;
    private MapProperties layerProperties;
    private final Vector2 vec2 = new Vector2();
    private final Vector3 vec3 = new Vector3();
    private final Matrix4 mat4 = new Matrix4();

    public Box2DMapObjectParser() {
    }

    public Box2DMapObjectParser(Aliases aliases) {
        this.aliases = aliases;
    }

    public Box2DMapObjectParser(Listener listener) {
        this.listener = listener;
    }

    public Box2DMapObjectParser(Aliases aliases, Listener listener) {
        this.aliases = aliases;
        this.listener = listener;
    }

    public Box2DMapObjectParser(Aliases aliases, float tileWidth, float tileHeight) {
        this.aliases = aliases;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(Listener listener, float tileWidth, float tileHeight) {
        this.listener = listener;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(Aliases aliases, Listener listener, float tileWidth, float tileHeight) {
        this.aliases = aliases;
        this.listener = listener;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(float unitScale) {
        this.unitScale = unitScale;
    }

    public Box2DMapObjectParser(float unitScale, float tileWidth, float tileHeight) {
        this.unitScale = unitScale;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(Aliases aliases, float unitScale) {
        this.aliases = aliases;
        this.unitScale = unitScale;
    }

    public Box2DMapObjectParser(Listener listener, float unitScale) {
        this.listener = listener;
        this.unitScale = unitScale;
    }

    public Box2DMapObjectParser(Aliases aliases, Listener listener, float unitScale) {
        this.aliases = aliases;
        this.listener = listener;
        this.unitScale = unitScale;
    }

    public Box2DMapObjectParser(Aliases aliases, float unitScale, float tileWidth, float tileHeight) {
        this.aliases = aliases;
        this.unitScale = unitScale;
        this.ignoreMapUnitScale = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(Listener listener, float unitScale, float tileWidth, float tileHeight) {
        this.listener = listener;
        this.unitScale = unitScale;
        this.ignoreMapUnitScale = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public Box2DMapObjectParser(Listener listener, Aliases aliases, float unitScale, float tileWidth, float tileHeight) {
        this.aliases = aliases;
        this.listener = listener;
        this.unitScale = unitScale;
        this.ignoreMapUnitScale = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    public World load(World world, Map map) {
        MapProperties oldMapProperties = this.mapProperties;
        this.mapProperties = map.getProperties();
        world.setGravity(this.vec2.set(((Float)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.gravityX, (Object)Float.valueOf(world.getGravity().x))).floatValue(), ((Float)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.gravityY, (Object)Float.valueOf(world.getGravity().y))).floatValue()));
        world.setAutoClearForces(((Boolean)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.autoClearForces, (Object)world.getAutoClearForces())).booleanValue());
        if (!this.ignoreMapUnitScale) {
            this.unitScale = ((Float)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.unitScale, (Object)Float.valueOf(this.unitScale))).floatValue();
        }
        this.tileWidth = ((Float)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.tileWidth, (Object)Float.valueOf(this.tileWidth))).floatValue();
        this.tileHeight = ((Float)MapUtils.getProperty((MapProperties)this.mapProperties, (String)this.aliases.tileHeight, (Object)Float.valueOf(this.tileHeight))).floatValue();
        this.listener.init(this);
        Array layers = (Array)Pools.obtain(Array.class);
        layers.clear();
        this.listener.load(map, (Array<MapLayer>)layers);
        for (MapLayer mapLayer : layers) {
            this.load(world, mapLayer);
        }
        layers.clear();
        Pools.free((Object)layers);
        this.mapProperties = oldMapProperties;
        return world;
    }

    public World load(World world, MapLayer layer) {
        String type;
        MapProperties oldLayerProperties = this.layerProperties;
        this.layerProperties = layer.getProperties();
        float oldUnitScale = this.unitScale;
        if (!this.ignoreLayerUnitScale) {
            this.unitScale = ((Float)MapUtils.getProperty((MapProperties)layer.getProperties(), (String)this.aliases.unitScale, (Object)Float.valueOf(this.unitScale))).floatValue();
        }
        String typeFallback = (String)MapUtils.findProperty((String)this.aliases.type, (Object)"", (MapProperties[])new MapProperties[]{this.heritage, this.mapProperties, this.layerProperties});
        Array objects = (Array)Pools.obtain(Array.class);
        objects.clear();
        this.listener.load(layer, (Array<MapObject>)objects);
        for (MapObject object : objects) {
            type = (String)MapUtils.getProperty((MapProperties)object.getProperties(), (String)this.aliases.type, (Object)typeFallback);
            if (!type.equals(this.aliases.object)) continue;
            this.createObject(world, object);
        }
        for (MapObject object : objects) {
            type = (String)MapUtils.getProperty((MapProperties)object.getProperties(), (String)this.aliases.type, (Object)typeFallback);
            if (!type.equals(this.aliases.body)) continue;
            this.createBody(world, object);
        }
        for (MapObject object : objects) {
            type = (String)MapUtils.getProperty((MapProperties)object.getProperties(), (String)this.aliases.type, (Object)typeFallback);
            if (!type.equals(this.aliases.fixture)) continue;
            this.createFixtures(object);
        }
        for (MapObject object : objects) {
            type = (String)MapUtils.getProperty((MapProperties)object.getProperties(), (String)this.aliases.type, (Object)typeFallback);
            if (!type.equals(this.aliases.joint)) continue;
            this.createJoint(object);
        }
        objects.clear();
        Pools.free((Object)objects);
        this.layerProperties = oldLayerProperties;
        this.unitScale = oldUnitScale;
        return world;
    }

    public Body createObject(World world, MapObject object) {
        if ((object = this.listener.createObject(object)) == null) {
            return null;
        }
        Body body = this.createBody(world, object);
        this.createFixtures(object, body);
        return body;
    }

    public Body createBody(World world, MapObject mapObject) {
        if ((mapObject = this.listener.createBody(mapObject)) == null) {
            return null;
        }
        MapProperties properties = mapObject.getProperties();
        BodyDef bodyDef = new BodyDef();
        this.assignProperties(bodyDef, this.heritage);
        this.assignProperties(bodyDef, this.mapProperties);
        this.assignProperties(bodyDef, this.layerProperties);
        this.assignProperties(bodyDef, properties);
        Body body = world.createBody(bodyDef);
        body.setUserData(MapUtils.findProperty((String)this.aliases.userData, (Object)body.getUserData(), (MapProperties[])new MapProperties[]{this.heritage, this.mapProperties, this.layerProperties, properties}));
        this.bodies.put((Object)Box2DMapObjectParser.findAvailableName(mapObject.getName(), this.bodies), (Object)body);
        this.listener.created(body, mapObject);
        return body;
    }

    public Fixture createFixture(MapObject mapObject, Body body) {
        if ((mapObject = this.listener.createFixture(mapObject)) == null) {
            return null;
        }
        String orientation = (String)MapUtils.findProperty((String)this.aliases.orientation, (Object)this.aliases.orthogonal, (MapProperties[])new MapProperties[]{this.heritage, this.mapProperties, this.layerProperties, mapObject.getProperties()});
        this.transform(this.mat4, orientation);
        PolygonShape shape = null;
        if (mapObject instanceof RectangleMapObject) {
            float height;
            float width;
            Rectangle rectangle = ((RectangleMapObject)mapObject).getRectangle();
            this.vec3.set(rectangle.x, rectangle.y, 0.0f);
            this.vec3.mul(this.mat4);
            float x = this.vec3.x;
            float y = this.vec3.y;
            if (!orientation.equals(this.aliases.staggered)) {
                this.vec3.set(rectangle.width, rectangle.height, 0.0f).mul(this.mat4);
                width = this.vec3.x;
                height = this.vec3.y;
            } else {
                width = rectangle.width * this.unitScale;
                height = rectangle.height * this.unitScale;
            }
            shape = new PolygonShape();
            shape.setAsBox(width / 2.0f, height / 2.0f, this.vec2.set(x - body.getPosition().x + width / 2.0f, y - body.getPosition().y + height / 2.0f), body.getAngle());
        } else if (mapObject instanceof PolygonMapObject || mapObject instanceof PolylineMapObject) {
            FloatArray vertices = (FloatArray)Pools.obtain(FloatArray.class);
            vertices.clear();
            vertices.addAll(mapObject instanceof PolygonMapObject ? ((PolygonMapObject)mapObject).getPolygon().getTransformedVertices() : ((PolylineMapObject)mapObject).getPolyline().getTransformedVertices());
            int ix = 0;
            for (int iy = 1; iy < vertices.size; iy += 2) {
                this.vec3.set(vertices.get(ix), vertices.get(iy), 0.0f);
                this.vec3.mul(this.mat4);
                vertices.set(ix, this.vec3.x - body.getPosition().x);
                vertices.set(iy, this.vec3.y - body.getPosition().y);
                ix += 2;
            }
            if (mapObject instanceof PolygonMapObject) {
                shape = new PolygonShape();
                shape.set(vertices.items, 0, vertices.size);
            } else if (vertices.size == 4) {
                shape = new EdgeShape();
                shape.set(vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(3));
            } else {
                vertices.shrink();
                shape = new ChainShape();
                shape.createChain(vertices.items);
            }
            Pools.free((Object)vertices);
        } else if (mapObject instanceof CircleMapObject || mapObject instanceof EllipseMapObject) {
            if (mapObject instanceof CircleMapObject) {
                Circle circle = ((CircleMapObject)mapObject).getCircle();
                this.vec3.set(circle.x, circle.y, circle.radius);
            } else {
                Ellipse ellipse = ((EllipseMapObject)mapObject).getEllipse();
                if (ellipse.width != ellipse.height) {
                    throw new IllegalArgumentException("Cannot parse " + mapObject.getName() + " because " + ClassReflection.getSimpleName(mapObject.getClass()) + "s that are not circles are not supported");
                }
                this.vec3.set(ellipse.x + ellipse.width / 2.0f, ellipse.y + ellipse.height / 2.0f, ellipse.width / 2.0f);
            }
            this.vec3.mul(this.mat4);
            this.vec3.sub(body.getPosition().x, body.getPosition().y, 0.0f);
            shape = new CircleShape();
            CircleShape circleShape = shape;
            circleShape.setPosition(this.vec2.set(this.vec3.x, this.vec3.y));
            circleShape.setRadius(this.vec3.z);
        } else {
            if (mapObject instanceof TextureMapObject) {
                throw new IllegalArgumentException("Cannot parse " + mapObject.getName() + " because " + ClassReflection.getSimpleName(mapObject.getClass()) + "s are not supported");
            }
            assert (false) : mapObject + " is a not known subclass of " + MapObject.class.getName();
        }
        MapProperties properties = mapObject.getProperties();
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = shape;
        this.assignProperties(fixtureDef, this.heritage);
        this.assignProperties(fixtureDef, this.mapProperties);
        this.assignProperties(fixtureDef, this.layerProperties);
        this.assignProperties(fixtureDef, properties);
        Fixture fixture = body.createFixture(fixtureDef);
        fixture.setUserData(MapUtils.findProperty((String)this.aliases.userData, (Object)fixture.getUserData(), (MapProperties[])new MapProperties[]{this.heritage, this.mapProperties, this.layerProperties, properties}));
        shape.dispose();
        this.fixtures.put((Object)Box2DMapObjectParser.findAvailableName(mapObject.getName(), this.fixtures), (Object)fixture);
        this.listener.created(fixture, mapObject);
        return fixture;
    }

    public Fixture[] createFixtures(MapObject mapObject, Body body) {
        Polygon polygon;
        if ((mapObject = this.listener.createFixtures(mapObject)) == null) {
            return null;
        }
        if (!(mapObject instanceof PolygonMapObject) || GeometryUtils.isConvex((Polygon)(polygon = ((PolygonMapObject)mapObject).getPolygon())) && Box2DUtils.check.isValidPolygonShape(polygon.getVertices())) {
            return new Fixture[]{this.createFixture(mapObject, body)};
        }
        Polygon[] convexPolygons = GeometryUtils.toPolygonArray((float[][])(this.triangulate ? GeometryUtils.triangulate((float[])polygon.getTransformedVertices()) : GeometryUtils.decompose((float[])polygon.getTransformedVertices())));
        Fixture[] fixtures = new Fixture[convexPolygons.length];
        for (int i = 0; i < fixtures.length; ++i) {
            PolygonMapObject convexObject = new PolygonMapObject(convexPolygons[i]);
            convexObject.setColor(mapObject.getColor());
            convexObject.setName(mapObject.getName());
            convexObject.setOpacity(mapObject.getOpacity());
            convexObject.setVisible(mapObject.isVisible());
            convexObject.getProperties().putAll(mapObject.getProperties());
            fixtures[i] = this.createFixture((MapObject)convexObject, body);
        }
        return fixtures;
    }

    public Fixture createFixture(MapObject mapObject) {
        return this.createFixture(mapObject, this.findBody(mapObject, this.heritage, this.mapProperties, this.layerProperties));
    }

    public Fixture[] createFixtures(MapObject mapObject) {
        return this.createFixtures(mapObject, this.findBody(mapObject, this.heritage, this.mapProperties, this.layerProperties));
    }

    public void transform(Matrix4 mat, String orientation) {
        mat.idt();
        if (orientation.equals(this.aliases.isometric)) {
            mat.scale((float)(Math.sqrt(2.0) / 2.0), (float)(Math.sqrt(2.0) / 4.0), 1.0f);
            mat.rotate(0.0f, 0.0f, 1.0f, -45.0f);
            mat.translate(-1.0f, 1.0f, 0.0f);
            mat.scale(this.unitScale * 2.0f, this.unitScale * 2.0f, this.unitScale * 2.0f);
        } else if (orientation.equals(this.aliases.staggered)) {
            mat.scale(this.unitScale, this.unitScale, this.unitScale);
            int mapHeight = (Integer)MapUtils.findProperty((String)this.aliases.height, (Object)0, (MapProperties[])new MapProperties[]{this.mapProperties, this.layerProperties});
            mat.translate(-this.tileWidth / 2.0f, -this.tileHeight * (float)(mapHeight / 2) + this.tileHeight / 2.0f, 0.0f);
        } else {
            mat.scale(this.unitScale, this.unitScale, this.unitScale);
        }
    }

    private Body findBody(MapObject mapObject, MapProperties ... heritage) {
        String name = mapObject.getName();
        Body body = null;
        if (name != null) {
            body = (Body)this.bodies.get((Object)name);
        }
        if (body == null) {
            body = (Body)this.bodies.get(MapUtils.getProperty((MapProperties)mapObject.getProperties(), (String)this.aliases.body, (Object)""));
        }
        if (body == null) {
            MapProperties properties;
            MapProperties[] mapPropertiesArray = heritage;
            int n = mapPropertiesArray.length;
            for (int i = 0; i < n && (body = (Body)this.bodies.get(MapUtils.getProperty((MapProperties)(properties = mapPropertiesArray[i]), (String)this.aliases.body, (Object)""))) == null; ++i) {
            }
        }
        if (body == null) {
            throw new IllegalStateException("the body of " + (name == null ? "an unnamed " : "the ") + "fixture " + (name != null ? name : "") + "does not exist");
        }
        return body;
    }

    public Joint createJoint(MapObject mapObject) {
        DistanceJointDef jointDef;
        if ((mapObject = this.listener.createJoint(mapObject)) == null) {
            return null;
        }
        MapProperties properties = mapObject.getProperties();
        String jointType = (String)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.jointType, (Object)"");
        if (jointType.equals(this.aliases.distanceJoint)) {
            DistanceJointDef distanceJointDef = new DistanceJointDef();
            this.assignProperties(distanceJointDef, this.heritage);
            this.assignProperties(distanceJointDef, this.mapProperties);
            this.assignProperties(distanceJointDef, this.layerProperties);
            this.assignProperties(distanceJointDef, properties);
            jointDef = distanceJointDef;
        } else if (jointType.equals(this.aliases.frictionJoint)) {
            FrictionJointDef frictionJointDef = new FrictionJointDef();
            this.assignProperties(frictionJointDef, this.heritage);
            this.assignProperties(frictionJointDef, this.mapProperties);
            this.assignProperties(frictionJointDef, this.layerProperties);
            this.assignProperties(frictionJointDef, properties);
            jointDef = frictionJointDef;
        } else if (jointType.equals(this.aliases.gearJoint)) {
            GearJointDef gearJointDef = new GearJointDef();
            this.assignProperties(gearJointDef, this.heritage);
            this.assignProperties(gearJointDef, this.mapProperties);
            this.assignProperties(gearJointDef, this.layerProperties);
            this.assignProperties(gearJointDef, properties);
            jointDef = gearJointDef;
        } else if (jointType.equals(this.aliases.mouseJoint)) {
            MouseJointDef mouseJointDef = new MouseJointDef();
            this.assignProperties(mouseJointDef, this.heritage);
            this.assignProperties(mouseJointDef, this.mapProperties);
            this.assignProperties(mouseJointDef, this.layerProperties);
            this.assignProperties(mouseJointDef, properties);
            jointDef = mouseJointDef;
        } else if (jointType.equals(this.aliases.prismaticJoint)) {
            PrismaticJointDef prismaticJointDef = new PrismaticJointDef();
            this.assignProperties(prismaticJointDef, this.heritage);
            this.assignProperties(prismaticJointDef, this.mapProperties);
            this.assignProperties(prismaticJointDef, this.layerProperties);
            this.assignProperties(prismaticJointDef, properties);
            jointDef = prismaticJointDef;
        } else if (jointType.equals(this.aliases.pulleyJoint)) {
            PulleyJointDef pulleyJointDef = new PulleyJointDef();
            this.assignProperties(pulleyJointDef, this.heritage);
            this.assignProperties(pulleyJointDef, this.mapProperties);
            this.assignProperties(pulleyJointDef, this.layerProperties);
            this.assignProperties(pulleyJointDef, properties);
            jointDef = pulleyJointDef;
        } else if (jointType.equals(this.aliases.revoluteJoint)) {
            RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
            this.assignProperties(revoluteJointDef, this.heritage);
            this.assignProperties(revoluteJointDef, this.mapProperties);
            this.assignProperties(revoluteJointDef, this.layerProperties);
            this.assignProperties(revoluteJointDef, properties);
            jointDef = revoluteJointDef;
        } else if (jointType.equals(this.aliases.ropeJoint)) {
            RopeJointDef ropeJointDef = new RopeJointDef();
            this.assignProperties(ropeJointDef, this.heritage);
            this.assignProperties(ropeJointDef, this.mapProperties);
            this.assignProperties(ropeJointDef, this.layerProperties);
            this.assignProperties(ropeJointDef, properties);
            jointDef = ropeJointDef;
        } else if (jointType.equals(this.aliases.weldJoint)) {
            WeldJointDef weldJointDef = new WeldJointDef();
            this.assignProperties(weldJointDef, this.heritage);
            this.assignProperties(weldJointDef, this.mapProperties);
            this.assignProperties(weldJointDef, this.layerProperties);
            this.assignProperties(weldJointDef, properties);
            jointDef = weldJointDef;
        } else if (jointType.equals(this.aliases.wheelJoint)) {
            WheelJointDef wheelJointDef = new WheelJointDef();
            this.assignProperties(wheelJointDef, this.heritage);
            this.assignProperties(wheelJointDef, this.mapProperties);
            this.assignProperties(wheelJointDef, this.layerProperties);
            this.assignProperties(wheelJointDef, properties);
            jointDef = wheelJointDef;
        } else {
            throw new IllegalArgumentException(ClassReflection.getSimpleName(JointDef.JointType.class) + " " + jointType + " is unknown");
        }
        this.assignProperties((JointDef)jointDef, properties);
        Joint joint = jointDef.bodyA.getWorld().createJoint((JointDef)jointDef);
        joint.setUserData(MapUtils.getProperty((MapProperties)properties, (String)this.aliases.userData, (Object)joint.getUserData()));
        this.joints.put((Object)Box2DMapObjectParser.findAvailableName(mapObject.getName(), this.joints), (Object)joint);
        this.listener.created(joint, mapObject);
        return joint;
    }

    public void assignProperties(BodyDef bodyDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        bodyDef.type = ((String)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bodyType, (Object)"")).equals(this.aliases.staticBody) ? BodyDef.BodyType.StaticBody : (((String)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bodyType, (Object)"")).equals(this.aliases.dynamicBody) ? BodyDef.BodyType.DynamicBody : (((String)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bodyType, (Object)"")).equals(this.aliases.kinematicBody) ? BodyDef.BodyType.KinematicBody : bodyDef.type));
        bodyDef.active = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.active, (Object)bodyDef.active);
        bodyDef.allowSleep = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.allowSleep, (Object)bodyDef.allowSleep);
        bodyDef.angle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.angle, (Object)Float.valueOf(bodyDef.angle))).floatValue() * ((float)Math.PI / 180);
        bodyDef.angularDamping = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.angularDamping, (Object)Float.valueOf(bodyDef.angularDamping))).floatValue();
        bodyDef.angularVelocity = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.angularVelocity, (Object)Float.valueOf(bodyDef.angularVelocity))).floatValue();
        bodyDef.awake = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.awake, (Object)bodyDef.awake);
        bodyDef.bullet = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bullet, (Object)bodyDef.bullet);
        bodyDef.fixedRotation = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.fixedRotation, (Object)bodyDef.fixedRotation);
        bodyDef.gravityScale = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.gravityScale, (Object)Float.valueOf(bodyDef.gravityScale))).floatValue();
        bodyDef.linearDamping = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.linearDamping, (Object)Float.valueOf(bodyDef.linearDamping))).floatValue();
        bodyDef.linearVelocity.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.linearVelocityX, (Object)Float.valueOf(bodyDef.linearVelocity.x))).floatValue(), ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.linearVelocityY, (Object)Float.valueOf(bodyDef.linearVelocity.y))).floatValue());
        bodyDef.position.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.x, (Object)Float.valueOf(bodyDef.position.x))).floatValue() * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.y, (Object)Float.valueOf(bodyDef.position.y))).floatValue() * this.unitScale);
    }

    public void assignProperties(FixtureDef fixtureDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        fixtureDef.density = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.density, (Object)Float.valueOf(fixtureDef.density))).floatValue();
        fixtureDef.filter.categoryBits = (Short)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.categoryBits, (Object)fixtureDef.filter.categoryBits);
        fixtureDef.filter.groupIndex = (Short)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.groupIndex, (Object)fixtureDef.filter.groupIndex);
        fixtureDef.filter.maskBits = (Short)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maskBits, (Object)fixtureDef.filter.maskBits);
        fixtureDef.friction = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.friciton, (Object)Float.valueOf(fixtureDef.friction))).floatValue();
        fixtureDef.isSensor = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.isSensor, (Object)fixtureDef.isSensor);
        fixtureDef.restitution = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.restitution, (Object)Float.valueOf(fixtureDef.restitution))).floatValue();
    }

    public void assignProperties(JointDef jointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        jointDef.bodyA = (Body)this.bodies.get(MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bodyA, (Object)""));
        jointDef.bodyB = (Body)this.bodies.get(MapUtils.getProperty((MapProperties)properties, (String)this.aliases.bodyB, (Object)""));
        jointDef.collideConnected = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.collideConnected, (Object)jointDef.collideConnected);
    }

    public void assignProperties(DistanceJointDef distanceJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        distanceJointDef.dampingRatio = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.dampingRatio, (Object)Float.valueOf(distanceJointDef.dampingRatio))).floatValue();
        distanceJointDef.frequencyHz = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.frequencyHz, (Object)Float.valueOf(distanceJointDef.frequencyHz))).floatValue();
        distanceJointDef.length = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.length, (Object)Float.valueOf(distanceJointDef.length))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
        distanceJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(distanceJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(distanceJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        distanceJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(distanceJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(distanceJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
    }

    public void assignProperties(FrictionJointDef frictionJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        frictionJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(frictionJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(frictionJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        frictionJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(frictionJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(frictionJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        frictionJointDef.maxForce = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxForce, (Object)Float.valueOf(frictionJointDef.maxForce))).floatValue();
        frictionJointDef.maxTorque = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxTorque, (Object)Float.valueOf(frictionJointDef.maxTorque))).floatValue();
    }

    public void assignProperties(GearJointDef gearJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        gearJointDef.joint1 = (Joint)this.joints.get(MapUtils.getProperty((MapProperties)properties, (String)this.aliases.joint1, (Object)""));
        gearJointDef.joint2 = (Joint)this.joints.get(MapUtils.getProperty((MapProperties)properties, (String)this.aliases.joint2, (Object)""));
        gearJointDef.ratio = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.ratio, (Object)Float.valueOf(gearJointDef.ratio))).floatValue();
    }

    public void assignProperties(MouseJointDef mouseJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        mouseJointDef.dampingRatio = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.dampingRatio, (Object)Float.valueOf(mouseJointDef.dampingRatio))).floatValue();
        mouseJointDef.frequencyHz = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.frequencyHz, (Object)Float.valueOf(mouseJointDef.frequencyHz))).floatValue();
        mouseJointDef.maxForce = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxForce, (Object)Float.valueOf(mouseJointDef.maxForce))).floatValue();
        mouseJointDef.target.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.targetX, (Object)Float.valueOf(mouseJointDef.target.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.targetY, (Object)Float.valueOf(mouseJointDef.target.y))).floatValue() * this.tileHeight * this.unitScale);
    }

    public void assignProperties(PrismaticJointDef prismaticJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        prismaticJointDef.enableLimit = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.enableLimit, (Object)prismaticJointDef.enableLimit);
        prismaticJointDef.enableMotor = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.enableMotor, (Object)prismaticJointDef.enableMotor);
        prismaticJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(prismaticJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(prismaticJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        prismaticJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(prismaticJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(prismaticJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        prismaticJointDef.localAxisA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAxisAX, (Object)Float.valueOf(prismaticJointDef.localAxisA.x))).floatValue(), ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAxisAY, (Object)Float.valueOf(prismaticJointDef.localAxisA.y))).floatValue());
        prismaticJointDef.lowerTranslation = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.lowerTranslation, (Object)Float.valueOf(prismaticJointDef.lowerTranslation))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
        prismaticJointDef.maxMotorForce = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxMotorForce, (Object)Float.valueOf(prismaticJointDef.maxMotorForce))).floatValue();
        prismaticJointDef.motorSpeed = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.motorSpeed, (Object)Float.valueOf(prismaticJointDef.motorSpeed))).floatValue();
        prismaticJointDef.referenceAngle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.referenceAngle, (Object)Float.valueOf(prismaticJointDef.referenceAngle))).floatValue() * ((float)Math.PI / 180);
        prismaticJointDef.upperTranslation = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.upperTranslation, (Object)Float.valueOf(prismaticJointDef.upperTranslation))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
    }

    public void assignProperties(PulleyJointDef pulleyJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        pulleyJointDef.groundAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.groundAnchorAX, (Object)Float.valueOf(pulleyJointDef.groundAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.groundAnchorAY, (Object)Float.valueOf(pulleyJointDef.groundAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        pulleyJointDef.groundAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.groundAnchorBX, (Object)Float.valueOf(pulleyJointDef.groundAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.groundAnchorBY, (Object)Float.valueOf(pulleyJointDef.groundAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        pulleyJointDef.lengthA = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.lengthA, (Object)Float.valueOf(pulleyJointDef.lengthA))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
        pulleyJointDef.lengthB = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.lengthB, (Object)Float.valueOf(pulleyJointDef.lengthB))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
        pulleyJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(pulleyJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(pulleyJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        pulleyJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(pulleyJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(pulleyJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        pulleyJointDef.ratio = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.ratio, (Object)Float.valueOf(pulleyJointDef.ratio))).floatValue();
    }

    public void assignProperties(RevoluteJointDef revoluteJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        revoluteJointDef.enableLimit = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.enableLimit, (Object)revoluteJointDef.enableLimit);
        revoluteJointDef.enableMotor = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.enableMotor, (Object)revoluteJointDef.enableMotor);
        revoluteJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(revoluteJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(revoluteJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        revoluteJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(revoluteJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(revoluteJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        revoluteJointDef.lowerAngle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.lowerAngle, (Object)Float.valueOf(revoluteJointDef.lowerAngle))).floatValue() * ((float)Math.PI / 180);
        revoluteJointDef.maxMotorTorque = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxMotorTorque, (Object)Float.valueOf(revoluteJointDef.maxMotorTorque))).floatValue();
        revoluteJointDef.motorSpeed = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.motorSpeed, (Object)Float.valueOf(revoluteJointDef.motorSpeed))).floatValue();
        revoluteJointDef.referenceAngle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.referenceAngle, (Object)Float.valueOf(revoluteJointDef.referenceAngle))).floatValue() * ((float)Math.PI / 180);
        revoluteJointDef.upperAngle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.upperAngle, (Object)Float.valueOf(revoluteJointDef.upperAngle))).floatValue() * ((float)Math.PI / 180);
    }

    public void assignProperties(RopeJointDef ropeJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        ropeJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(ropeJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(ropeJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        ropeJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(ropeJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(ropeJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        ropeJointDef.maxLength = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxLength, (Object)Float.valueOf(ropeJointDef.maxLength))).floatValue() * (this.tileWidth + this.tileHeight) / 2.0f * this.unitScale;
    }

    public void assignProperties(WeldJointDef weldJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        weldJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(weldJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(weldJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        weldJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(weldJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(weldJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        weldJointDef.referenceAngle = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.referenceAngle, (Object)Float.valueOf(weldJointDef.referenceAngle))).floatValue() * ((float)Math.PI / 180);
    }

    public void assignProperties(WheelJointDef wheelJointDef, MapProperties properties) {
        if (properties == null) {
            return;
        }
        wheelJointDef.dampingRatio = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.dampingRatio, (Object)Float.valueOf(wheelJointDef.dampingRatio))).floatValue();
        wheelJointDef.enableMotor = (Boolean)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.enableMotor, (Object)wheelJointDef.enableMotor);
        wheelJointDef.frequencyHz = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.frequencyHz, (Object)Float.valueOf(wheelJointDef.frequencyHz))).floatValue();
        wheelJointDef.localAnchorA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAX, (Object)Float.valueOf(wheelJointDef.localAnchorA.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorAY, (Object)Float.valueOf(wheelJointDef.localAnchorA.y))).floatValue() * this.tileHeight * this.unitScale);
        wheelJointDef.localAnchorB.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBX, (Object)Float.valueOf(wheelJointDef.localAnchorB.x))).floatValue() * this.tileWidth * this.unitScale, ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAnchorBY, (Object)Float.valueOf(wheelJointDef.localAnchorB.y))).floatValue() * this.tileHeight * this.unitScale);
        wheelJointDef.localAxisA.set(((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAxisAX, (Object)Float.valueOf(wheelJointDef.localAxisA.x))).floatValue(), ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.localAxisAY, (Object)Float.valueOf(wheelJointDef.localAxisA.y))).floatValue());
        wheelJointDef.maxMotorTorque = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.maxMotorTorque, (Object)Float.valueOf(wheelJointDef.maxMotorTorque))).floatValue();
        wheelJointDef.motorSpeed = ((Float)MapUtils.getProperty((MapProperties)properties, (String)this.aliases.motorSpeed, (Object)Float.valueOf(wheelJointDef.motorSpeed))).floatValue();
    }

    public static String findAvailableName(String desiredName, ObjectMap<String, ?> map) {
        if (desiredName == null) {
            desiredName = String.valueOf(map.size);
        }
        if (map.containsKey((Object)desiredName)) {
            int duplicate = 1;
            while (map.containsKey((Object)(desiredName + duplicate))) {
                ++duplicate;
            }
            desiredName = desiredName + duplicate;
        }
        return desiredName;
    }

    public void reset() {
        this.aliases = new Aliases();
        this.listener = defaultListener;
        this.unitScale = 1.0f;
        this.tileWidth = 1.0f;
        this.tileHeight = 1.0f;
        this.triangulate = false;
        this.bodies.clear();
        this.fixtures.clear();
        this.joints.clear();
        this.heritage = null;
        this.mapProperties = null;
        this.layerProperties = null;
    }

    public float getUnitScale() {
        return this.unitScale;
    }

    public void setUnitScale(float unitScale) {
        this.unitScale = unitScale;
    }

    public boolean isIgnoreMapUnitScale() {
        return this.ignoreMapUnitScale;
    }

    public void setIgnoreMapUnitScale(boolean ignoreMapUnitScale) {
        this.ignoreMapUnitScale = ignoreMapUnitScale;
    }

    public boolean isIgnoreLayerUnitScale() {
        return this.ignoreLayerUnitScale;
    }

    public void setIgnoreLayerUnitScale(boolean ignoreLayerUnitScale) {
        this.ignoreLayerUnitScale = ignoreLayerUnitScale;
    }

    public float getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(float tileWidth) {
        this.tileWidth = tileWidth;
    }

    public float getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(float tileHeight) {
        this.tileHeight = tileHeight;
    }

    public boolean isTriangulate() {
        return this.triangulate;
    }

    public void setTriangulate(boolean triangulate) {
        this.triangulate = triangulate;
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public void setAliases(Aliases aliases) {
        this.aliases = aliases;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener != null ? listener : defaultListener;
    }

    public ObjectMap<String, Body> getBodies() {
        return this.bodies;
    }

    public ObjectMap<String, Fixture> getFixtures() {
        return this.fixtures;
    }

    public ObjectMap<String, Joint> getJoints() {
        return this.joints;
    }

    public MapProperties getHeritage() {
        return this.heritage;
    }

    public void setHeritage(MapProperties heritage) {
        this.heritage = heritage;
    }

    public static interface Listener {
        public void init(Box2DMapObjectParser var1);

        public void load(Map var1, Array<MapLayer> var2);

        public void load(MapLayer var1, Array<MapObject> var2);

        public MapObject createObject(MapObject var1);

        public MapObject createBody(MapObject var1);

        public MapObject createFixtures(MapObject var1);

        public MapObject createFixture(MapObject var1);

        public MapObject createJoint(MapObject var1);

        public void created(Body var1, MapObject var2);

        public void created(Fixture var1, MapObject var2);

        public void created(Joint var1, MapObject var2);

        public static class Adapter
        implements Listener {
            @Override
            public void init(Box2DMapObjectParser parser) {
            }

            @Override
            public void load(Map map, Array<MapLayer> queue) {
                MapLayers layers = map.getLayers();
                queue.ensureCapacity(layers.getCount());
                for (MapLayer layer : layers) {
                    queue.add((Object)layer);
                }
            }

            @Override
            public void load(MapLayer layer, Array<MapObject> queue) {
                MapObjects objects = layer.getObjects();
                queue.ensureCapacity(objects.getCount());
                for (MapObject object : objects) {
                    queue.add((Object)object);
                }
            }

            @Override
            public MapObject createObject(MapObject mapObject) {
                return mapObject;
            }

            @Override
            public MapObject createBody(MapObject mapObject) {
                return mapObject;
            }

            @Override
            public MapObject createFixtures(MapObject mapObject) {
                return mapObject;
            }

            @Override
            public MapObject createFixture(MapObject mapObject) {
                return mapObject;
            }

            @Override
            public MapObject createJoint(MapObject mapObject) {
                return mapObject;
            }

            @Override
            public void created(Body body, MapObject mapObject) {
            }

            @Override
            public void created(Fixture fixture, MapObject mapObject) {
            }

            @Override
            public void created(Joint joint, MapObject mapObject) {
            }
        }
    }

    public static class Aliases {
        public String x = "x";
        public String y = "y";
        public String width = "width";
        public String height = "height";
        public String type = "type";
        public String bodyType = "bodyType";
        public String dynamicBody = "DynamicBody";
        public String kinematicBody = "KinematicBody";
        public String staticBody = "StaticBody";
        public String active = "active";
        public String allowSleep = "allowSleep";
        public String angle = "angle";
        public String angularDamping = "angularDamping";
        public String angularVelocity = "angularVelocity";
        public String awake = "awake";
        public String bullet = "bullet";
        public String fixedRotation = "fixedRotation";
        public String gravityScale = "gravityScale";
        public String linearDamping = "linearDamping";
        public String linearVelocityX = "linearVelocityX";
        public String linearVelocityY = "linearVelocityY";
        public String density = "density";
        public String categoryBits = "categoryBits";
        public String groupIndex = "groupIndex";
        public String maskBits = "maskBits";
        public String friciton = "friction";
        public String isSensor = "isSensor";
        public String restitution = "restitution";
        public String body = "body";
        public String fixture = "fixture";
        public String joint = "joint";
        public String jointType = "jointType";
        public String distanceJoint = "DistanceJoint";
        public String frictionJoint = "FrictionJoint";
        public String gearJoint = "GearJoint";
        public String mouseJoint = "MouseJoint";
        public String prismaticJoint = "PrismaticJoint";
        public String pulleyJoint = "PulleyJoint";
        public String revoluteJoint = "RevoluteJoint";
        public String ropeJoint = "RopeJoint";
        public String weldJoint = "WeldJoint";
        public String wheelJoint = "WheelJoint";
        public String bodyA = "bodyA";
        public String bodyB = "bodyB";
        public String collideConnected = "collideConnected";
        public String dampingRatio = "dampingRatio";
        public String frequencyHz = "frequencyHz";
        public String length = "length";
        public String localAnchorAX = "localAnchorAX";
        public String localAnchorAY = "localAnchorAY";
        public String localAnchorBX = "localAnchorBX";
        public String localAnchorBY = "localAnchorBY";
        public String maxForce = "maxForce";
        public String maxTorque = "maxTorque";
        public String joint1 = "joint1";
        public String joint2 = "joint2";
        public String ratio = "ratio";
        public String targetX = "targetX";
        public String targetY = "targetY";
        public String enableLimit = "enableLimit";
        public String enableMotor = "enableMotor";
        public String localAxisAX = "localAxisAX";
        public String localAxisAY = "localAxisAY";
        public String lowerTranslation = "lowerTranslation";
        public String maxMotorForce = "maxMotorForce";
        public String motorSpeed = "motorSpeed";
        public String referenceAngle = "referenceAngle";
        public String upperTranslation = "upperTranslation";
        public String groundAnchorAX = "groundAnchorAX";
        public String groundAnchorAY = "groundAnchorAY";
        public String groundAnchorBX = "groundAnchorBX";
        public String groundAnchorBY = "groundAnchorBY";
        public String lengthA = "lengthA";
        public String lengthB = "lengthB";
        public String lowerAngle = "lowerAngle";
        public String maxMotorTorque = "maxMotorTorque";
        public String upperAngle = "upperAngle";
        public String maxLength = "maxLength";
        public String object = "object";
        public String unitScale = "unitScale";
        public String userData = "userData";
        public String tileWidth = "tilewidth";
        public String tileHeight = "tileheight";
        public String gravityX = "gravityX";
        public String gravityY = "gravityY";
        public String autoClearForces = "autoClearForces";
        public String orientation = "orientation";
        public String orthogonal = "orthogonal";
        public String isometric = "isometric";
        public String staggered = "staggered";
    }
}

