/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import net.dermetfan.utils.Function;
import net.dermetfan.utils.math.MathUtils;

public class Breakable {
    private float normalResistance;
    private float tangentResistance;
    private final Vector2 reactionForceResistance = new Vector2();
    private float reactionForceLength2Resistance;
    private float reactionTorqueResistance;
    private boolean breakBody;
    private boolean breakBodyWithoutFixtures = true;
    private Callback callback;

    public Breakable(float normalResistance, float tangentResistance) {
        this(normalResistance, tangentResistance, false);
    }

    public Breakable(float normalResistance, float tangentResistance, boolean breakBody) {
        this(normalResistance, tangentResistance, breakBody, true);
    }

    public Breakable(float normalResistance, float tangentResistance, boolean breakBody, boolean breakBodyWithoutFixtures) {
        this(normalResistance, tangentResistance, Vector2.Zero, 0.0f, 0.0f, breakBody, breakBodyWithoutFixtures, null);
    }

    public Breakable(float normalResistance, float tangentResistance, Callback callback) {
        this(normalResistance, tangentResistance, false, callback);
    }

    public Breakable(float normalResistance, float tangentResistance, boolean breakBody, Callback callback) {
        this(normalResistance, tangentResistance, Vector2.Zero, 0.0f, 0.0f, breakBody, true, callback);
    }

    public Breakable(Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance) {
        this(reactionForceResistance, reactionForceLength2Resistance, reactionTorqueResistance, false);
    }

    public Breakable(Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance, boolean breakBody) {
        this(reactionForceResistance, reactionForceLength2Resistance, reactionTorqueResistance, breakBody, true);
    }

    public Breakable(Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance, boolean breakBody, boolean breakBodyWithoutFixtures) {
        this(0.0f, 0.0f, reactionForceResistance, reactionForceLength2Resistance, reactionTorqueResistance, breakBody, breakBodyWithoutFixtures, null);
    }

    public Breakable(Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance, Callback callback) {
        this(reactionForceResistance, reactionForceLength2Resistance, reactionTorqueResistance, false, callback);
    }

    public Breakable(Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance, boolean breakBody, Callback callback) {
        this(0.0f, 0.0f, reactionForceResistance, reactionForceLength2Resistance, reactionTorqueResistance, breakBody, true, callback);
    }

    public Breakable(float normalResistance, float tangentResistance, Vector2 reactionForceResistance, float reactionForceLength2Resistance, float reactionTorqueResistance, boolean breakBody, boolean breakBodyWithoutFixtures, Callback callback) {
        this.normalResistance = normalResistance;
        this.tangentResistance = tangentResistance;
        this.reactionForceResistance.set(reactionForceResistance);
        this.reactionForceLength2Resistance = reactionForceLength2Resistance;
        this.reactionTorqueResistance = reactionTorqueResistance;
        this.breakBody = breakBody;
        this.breakBodyWithoutFixtures = breakBodyWithoutFixtures;
        this.callback = callback;
    }

    public Breakable(Breakable other) {
        this(other.normalResistance, other.tangentResistance, other.reactionForceResistance, other.reactionForceLength2Resistance, other.reactionTorqueResistance, other.breakBody, other.breakBodyWithoutFixtures, other.callback);
    }

    public float getNormalResistance() {
        return this.normalResistance;
    }

    public void setNormalResistance(float normalResistance) {
        this.normalResistance = normalResistance;
    }

    public float getTangentResistance() {
        return this.tangentResistance;
    }

    public void setTangentResistance(float tangentResistance) {
        this.tangentResistance = tangentResistance;
    }

    public Vector2 getReactionForceResistance() {
        return this.reactionForceResistance;
    }

    public void setReactionForceResistance(Vector2 reactionForceResistance) {
        this.reactionForceResistance.set(reactionForceResistance);
    }

    public float getReactionForceLength2Resistance() {
        return this.reactionForceLength2Resistance;
    }

    public void setReactionForceLength2Resistance(float reactionForceLength2Resistance) {
        this.reactionForceLength2Resistance = reactionForceLength2Resistance;
    }

    public float getReactionTorqueResistance() {
        return this.reactionTorqueResistance;
    }

    public void setReactionTorqueResistance(float reactionTorqueResistance) {
        this.reactionTorqueResistance = reactionTorqueResistance;
    }

    public boolean isBreakBody() {
        return this.breakBody;
    }

    public void setBreakBody(boolean breakBody) {
        this.breakBody = breakBody;
    }

    public boolean isBreakBodyWithoutFixtures() {
        return this.breakBodyWithoutFixtures;
    }

    public void setBreakBodyWithoutFixtures(boolean breakBodyWithoutFixtures) {
        this.breakBodyWithoutFixtures = breakBodyWithoutFixtures;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public static interface Callback {
        public boolean strained(Fixture var1, Breakable var2, Contact var3, ContactImpulse var4, float var5, float var6);

        public boolean strained(Joint var1, Breakable var2, Vector2 var3, float var4);

        public boolean destroyed(Body var1, Breakable var2);

        public boolean destroyed(Fixture var1, Breakable var2);

        public boolean destroyed(Joint var1, Breakable var2);

        public static class Adapter
        implements Callback {
            @Override
            public boolean strained(Fixture fixture, Breakable breakable, Contact contact, ContactImpulse impulse, float normalImpulse, float tangentImpulse) {
                return false;
            }

            @Override
            public boolean strained(Joint joint, Breakable breakable, Vector2 reactionForce, float reactionTorque) {
                return false;
            }

            @Override
            public boolean destroyed(Body body, Breakable breakable) {
                return false;
            }

            @Override
            public boolean destroyed(Fixture fixture, Breakable breakable) {
                return false;
            }

            @Override
            public boolean destroyed(Joint joint, Breakable breakable) {
                return false;
            }
        }
    }

    public static class Manager
    implements ContactListener {
        public final Array<Fixture> brokenFixtures = new Array(1);
        public final Array<Body> brokenBodies = new Array(1);
        public final Array<Joint> brokenJoints = new Array(1);
        public static final Function<Breakable, Object> defaultUserDataAccessor = new Function<Breakable, Object>(){

            public Breakable apply(Object userData) {
                return userData instanceof Breakable ? (Breakable)userData : null;
            }
        };
        private Function<Breakable, Object> userDataAccessor = defaultUserDataAccessor;
        private final Array<Joint> tmpJoints = new Array(0);

        public Manager() {
        }

        public Manager(Function<Breakable, Object> userDataAccessor) {
            this.setUserDataAccessor(userDataAccessor);
        }

        public void destroy() {
            for (Fixture fixture : this.brokenFixtures) {
                this.brokenFixtures.removeValue((Object)fixture, true);
                fixture.getBody().destroyFixture(fixture);
            }
            for (Body body : this.brokenBodies) {
                this.brokenBodies.removeValue((Object)body, true);
                body.getWorld().destroyBody(body);
            }
            for (Joint joint : this.brokenJoints) {
                this.brokenJoints.removeValue((Object)joint, true);
                joint.getBodyA().getWorld().destroyJoint(joint);
            }
        }

        public void strain(Contact contact, ContactImpulse impulse) {
            float normalImpulse = MathUtils.sum((float[])impulse.getNormalImpulses());
            float tangentImpulse = Math.abs(MathUtils.sum((float[])impulse.getTangentImpulses()));
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            Breakable breakable = (Breakable)this.userDataAccessor.apply(fixtureA.getUserData());
            if (Manager.shouldBreak(breakable, normalImpulse, tangentImpulse, contact, impulse, fixtureA)) {
                this.destroy(fixtureA);
            }
            if (Manager.shouldBreak(breakable = (Breakable)this.userDataAccessor.apply(fixtureB.getUserData()), normalImpulse, tangentImpulse, contact, impulse, fixtureB)) {
                this.destroy(fixtureB);
            }
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            breakable = (Breakable)this.userDataAccessor.apply(bodyA.getUserData());
            if (Manager.shouldBreak(breakable, normalImpulse, tangentImpulse, contact, impulse, fixtureA)) {
                this.destroy(bodyA);
            }
            if (Manager.shouldBreak(breakable = (Breakable)this.userDataAccessor.apply(bodyB.getUserData()), normalImpulse, tangentImpulse, contact, impulse, fixtureB)) {
                this.destroy(bodyB);
            }
        }

        public void strain(World world, float delta) {
            world.getJoints(this.tmpJoints);
            for (Joint joint : this.tmpJoints) {
                this.strain(joint, delta);
            }
        }

        public void strain(Joint joint, float delta) {
            float reactionTorque;
            Breakable breakable = (Breakable)this.userDataAccessor.apply(joint.getUserData());
            if (breakable == null) {
                return;
            }
            Vector2 reactionForce = joint.getReactionForce(1.0f / delta);
            if (Manager.shouldBreak(breakable, reactionForce, reactionTorque = Math.abs(joint.getReactionTorque(1.0f / delta)), joint)) {
                this.destroy(joint);
            }
        }

        public static boolean shouldBreak(Breakable breakable, float normalImpulse, float tangentImpulse, Contact contact, ContactImpulse impulse, Fixture fixture) {
            return breakable != null && (normalImpulse > breakable.normalResistance || tangentImpulse > breakable.tangentResistance) && (breakable.callback == null || !breakable.callback.strained(fixture, breakable, contact, impulse, normalImpulse, tangentImpulse));
        }

        public static boolean shouldBreak(Breakable breakable, Vector2 reactionForce, float reactionTorque, Joint joint) {
            return breakable != null && (Math.abs(reactionForce.x) > ((Breakable)breakable).reactionForceResistance.x || Math.abs(reactionForce.y) > ((Breakable)breakable).reactionForceResistance.y || reactionForce.len2() > breakable.reactionForceLength2Resistance || reactionTorque > breakable.reactionTorqueResistance) && (breakable.callback == null || !breakable.callback.strained(joint, breakable, reactionForce, reactionTorque));
        }

        public void destroy(Fixture fixture) {
            if (this.brokenFixtures.contains((Object)fixture, true)) {
                return;
            }
            Breakable breakable = (Breakable)this.userDataAccessor.apply(fixture.getUserData());
            if (breakable == null || breakable.callback == null || !breakable.callback.destroyed(fixture, breakable)) {
                this.brokenFixtures.add((Object)fixture);
            }
            if (breakable != null) {
                Body body = fixture.getBody();
                if (breakable.breakBody) {
                    this.destroy(body);
                    return;
                }
                if (breakable.breakBodyWithoutFixtures) {
                    for (Fixture bodyFixture : body.getFixtureList()) {
                        if (this.brokenFixtures.contains((Object)bodyFixture, true)) continue;
                        return;
                    }
                    this.destroy(body);
                }
            }
        }

        public void destroy(Body body) {
            if (this.brokenBodies.contains((Object)body, true)) {
                return;
            }
            Breakable breakable = (Breakable)this.userDataAccessor.apply(body.getUserData());
            if (breakable == null || breakable.callback == null || !breakable.callback.destroyed(body, breakable)) {
                this.brokenBodies.add((Object)body);
            }
        }

        public void destroy(Joint joint) {
            if (this.brokenJoints.contains((Object)joint, true)) {
                return;
            }
            Breakable breakable = (Breakable)this.userDataAccessor.apply(joint.getUserData());
            if (breakable == null || breakable.callback == null || !breakable.callback.destroyed(joint, breakable)) {
                this.brokenJoints.add((Object)joint);
            }
            if (breakable != null && breakable.breakBody) {
                this.destroy(joint.getBodyA());
                this.destroy(joint.getBodyB());
            }
        }

        public void beginContact(Contact contact) {
        }

        public void preSolve(Contact contact, Manifold oldManifold) {
        }

        public void postSolve(Contact contact, ContactImpulse impulse) {
            this.strain(contact, impulse);
        }

        public void endContact(Contact contact) {
        }

        public Array<Fixture> getBrokenFixtures() {
            return this.brokenFixtures;
        }

        public Array<Body> getBrokenBodies() {
            return this.brokenBodies;
        }

        public Function<Breakable, Object> getUserDataAccessor() {
            return this.userDataAccessor;
        }

        public void setUserDataAccessor(Function<Breakable, Object> userDataAccessor) {
            this.userDataAccessor = userDataAccessor != null ? userDataAccessor : defaultUserDataAccessor;
        }
    }
}

