/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx;

import net.dermetfan.gdx.CharSequenceInterpolator;
import net.dermetfan.utils.Appender;

public class Typewriter {
    private boolean cursorWhileTyping = false;
    private boolean cursorAfterTyping = true;
    private CharSequenceInterpolator interpolator = new CharSequenceInterpolator(40.0f);
    private Appender appender = new Appender(new CharSequence[]{"|", ""}, 0.5f);

    public Typewriter() {
    }

    public Typewriter(CharSequence cursor) {
        this.appender.getAppendices()[0] = cursor;
    }

    public Typewriter(boolean cursorWhileTyping, boolean cursorAfterTyping) {
        this.cursorWhileTyping = cursorWhileTyping;
        this.cursorAfterTyping = cursorAfterTyping;
    }

    public Typewriter(CharSequence cursor, boolean cursorWhileTyping, boolean cursorAfterTyping) {
        this(cursorWhileTyping, cursorAfterTyping);
        this.appender.getAppendices()[0] = cursor;
    }

    public void update(float delta) {
        this.interpolator.update(delta);
        this.appender.update(delta);
    }

    public CharSequence type(CharSequence seq) {
        CharSequence str = this.interpolator.interpolate(seq);
        if (str.length() == seq.length()) {
            if (this.cursorAfterTyping) {
                str = this.appender.append(str);
            }
        } else if (this.cursorWhileTyping) {
            str = this.appender.append(str);
        }
        return str;
    }

    public CharSequence updateAndType(CharSequence seq, float delta) {
        this.update(delta);
        return this.type(seq);
    }

    public float getCharsPerSecond() {
        return this.interpolator.getCharsPerSecond();
    }

    public void setCharsPerSecond(float charsPerSecond) {
        this.interpolator.setCharsPerSecond(charsPerSecond);
    }

    public float getTime() {
        return this.interpolator.getTime();
    }

    public void setTime(float time) {
        this.interpolator.setTime(time);
    }

    public boolean isCursorWhileTyping() {
        return this.cursorWhileTyping;
    }

    public void setCursorWhileTyping(boolean cursorWhileTyping) {
        this.cursorWhileTyping = cursorWhileTyping;
    }

    public boolean isCursorAfterTyping() {
        return this.cursorAfterTyping;
    }

    public void setCursorAfterTyping(boolean cursorAfterTyping) {
        this.cursorAfterTyping = cursorAfterTyping;
    }

    public CharSequenceInterpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(CharSequenceInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender appender) {
        this.appender = appender;
    }
}

