/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.maps.tiled;

import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.Comparator;
import net.dermetfan.gdx.maps.MapUtils;

public abstract class TileAnimator {
    public static void animateLayer(TiledMapTile[] tiles, TiledMapTileLayer layer, String animationKey, String orderedKey, String intervalKey, float defaultInterval) {
        ObjectMap<String, Array<StaticTiledMapTile>> animations = TileAnimator.filterFrames(tiles, animationKey);
        TileAnimator.sortFrames(animations, orderedKey);
        TileAnimator.animateLayer(animations, layer, animationKey, intervalKey, defaultInterval);
    }

    public static void animateLayer(TiledMapTileSet tiles, TiledMapTileLayer target, String animationKey, String orderedKey, String intervalKey, float defaultInterval) {
        TileAnimator.animateLayer(MapUtils.toTiledMapTileArray(tiles), target, animationKey, orderedKey, intervalKey, defaultInterval);
    }

    public static void animateLayer(ObjectMap<String, Array<StaticTiledMapTile>> animations, TiledMapTileLayer layer, String animationKey, String intervalKey, float defaultInterval) {
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                MapProperties tileProperties;
                TiledMapTile tile;
                TiledMapTileLayer.Cell cell = layer.getCell(x, y);
                if (cell == null || (tile = cell.getTile()) == null || !(tileProperties = tile.getProperties()).containsKey(animationKey)) continue;
                AnimatedTiledMapTile animatedTile = new AnimatedTiledMapTile(MapUtils.getProperty(tileProperties, intervalKey, Float.valueOf(defaultInterval)).floatValue(), (Array)animations.get(tileProperties.get(animationKey, String.class)));
                animatedTile.getProperties().putAll(tile.getProperties());
                cell.setTile((TiledMapTile)animatedTile);
            }
        }
    }

    public static ObjectMap<String, Array<StaticTiledMapTile>> filterFrames(TiledMapTile[] tiles, String animationKey) {
        ObjectMap animations = new ObjectMap();
        for (TiledMapTile tile : tiles) {
            MapProperties tileProperties;
            if (!(tile instanceof StaticTiledMapTile) || !(tileProperties = tile.getProperties()).containsKey(animationKey)) continue;
            String animationName = (String)tileProperties.get(animationKey, String.class);
            if (!animations.containsKey((Object)animationName)) {
                animations.put((Object)animationName, (Object)new Array(3));
            }
            ((Array)animations.get((Object)animationName)).add((Object)((StaticTiledMapTile)tile));
        }
        return animations;
    }

    public static ObjectMap<String, Array<StaticTiledMapTile>> sortFrames(ObjectMap<String, Array<StaticTiledMapTile>> animations, String orderedKey) {
        ObjectMap.Entries entries = animations.entries();
        block0: while (entries.hasNext) {
            ObjectMap.Entry entry = entries.next();
            for (StaticTiledMapTile entryTile : (Array)entry.value) {
                if (!entryTile.getProperties().containsKey(orderedKey)) continue;
                TileAnimator.sortFrames((Array<StaticTiledMapTile>)((Array)entry.value), orderedKey);
                continue block0;
            }
        }
        return animations;
    }

    public static void sortFrames(Array<StaticTiledMapTile> frames, final String orderedKey) {
        frames.sort((Comparator)new Comparator<StaticTiledMapTile>(){

            @Override
            public int compare(StaticTiledMapTile tile1, StaticTiledMapTile tile2) {
                int tile2Frame;
                int tile1Frame = MapUtils.getProperty(tile1.getProperties(), orderedKey, -1);
                return tile1Frame < (tile2Frame = MapUtils.getProperty(tile2.getProperties(), orderedKey, -1).intValue()) ? -1 : (tile1Frame > tile2Frame ? 1 : 0);
            }
        });
    }
}

