/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.maps.tiled;

import com.badlogic.gdx.maps.Map;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.CircleMapObject;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.XmlWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import net.dermetfan.gdx.maps.MapUtils;
import net.dermetfan.gdx.math.GeometryUtils;

public class TmxMapWriter
extends XmlWriter {
    private int layerHeight;

    public TmxMapWriter(Writer writer) {
        super(writer);
    }

    public TmxMapWriter tmx(Map map, Format format) throws IOException {
        this.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.append("<!DOCTYPE map SYSTEM \"http://mapeditor.org/dtd/1.0/map.dtd\">\n");
        MapProperties props = map.getProperties();
        int height = MapUtils.getProperty(props, "height", 0);
        int tileHeight = MapUtils.getProperty(props, "tileheight", 0);
        int oldLayerHeight = this.layerHeight;
        this.layerHeight = height * tileHeight;
        this.element("map");
        this.attribute("version", "1.0");
        this.attribute("orientation", MapUtils.getProperty(props, "orientation", "orthogonal"));
        this.attribute("width", MapUtils.getProperty(props, "width", 0));
        this.attribute("height", height);
        this.attribute("tilewidth", MapUtils.getProperty(props, "tilewidth", 0));
        this.attribute("tileheight", tileHeight);
        Array excludedKeys = (Array)Pools.obtain(Array.class);
        excludedKeys.clear();
        excludedKeys.add((Object)"version");
        excludedKeys.add((Object)"orientation");
        excludedKeys.add((Object)"width");
        excludedKeys.add((Object)"height");
        excludedKeys.add((Object)"tilewidth");
        excludedKeys.add((Object)"tileheight");
        this.tmx(props, (Array<String>)excludedKeys);
        excludedKeys.clear();
        Pools.free((Object)excludedKeys);
        if (map instanceof TiledMap) {
            this.tmx(((TiledMap)map).getTileSets());
        }
        this.tmx(map.getLayers(), format);
        this.pop();
        this.layerHeight = oldLayerHeight;
        return this;
    }

    public TmxMapWriter tmx(MapProperties properties) throws IOException {
        return this.tmx(properties, null);
    }

    public TmxMapWriter tmx(MapProperties properties, Array<String> exclude) throws IOException {
        Iterator keys = properties.getKeys();
        if (!keys.hasNext()) {
            return this;
        }
        boolean elementEmitted = false;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (exclude != null && exclude.contains((Object)key, false)) continue;
            if (!elementEmitted) {
                this.element("properties");
                elementEmitted = true;
            }
            this.element("property").attribute("name", (Object)key).attribute("value", properties.get(key)).pop();
        }
        if (elementEmitted) {
            this.pop();
        }
        return this;
    }

    public TmxMapWriter tmx(TiledMapTileSets sets) throws IOException {
        for (TiledMapTileSet set : sets) {
            this.tmx(set);
        }
        return this;
    }

    public TmxMapWriter tmx(TiledMapTileSet set) throws IOException {
        Iterator iter;
        MapProperties props = set.getProperties();
        this.element("tileset");
        this.attribute("firstgid", MapUtils.getProperty(props, "firstgid", 1));
        this.attribute("name", set.getName());
        this.attribute("tilewidth", MapUtils.getProperty(props, "tilewidth", 0));
        this.attribute("tileheight", MapUtils.getProperty(props, "tileheight", 0));
        float spacing = MapUtils.getProperty(props, "spacing", Float.valueOf(Float.NaN)).floatValue();
        float margin = MapUtils.getProperty(props, "margin", Float.valueOf(Float.NaN)).floatValue();
        if (!Float.isNaN(spacing)) {
            this.attribute("spacing", MathUtils.round((float)spacing));
        }
        if (!Float.isNaN(margin)) {
            this.attribute("margin", MathUtils.round((float)margin));
        }
        if ((iter = set.iterator()).hasNext()) {
            TiledMapTile tile = (TiledMapTile)iter.next();
            this.element("tileoffset");
            this.attribute("x", MathUtils.round((float)tile.getOffsetX()));
            this.attribute("y", MathUtils.round((float)(-tile.getOffsetY())));
            this.pop();
        }
        this.element("image");
        this.attribute("source", MapUtils.getProperty(props, "imagesource", ""));
        this.attribute("imagewidth", MapUtils.getProperty(props, "imagewidth", 0));
        this.attribute("imageheight", MapUtils.getProperty(props, "imageheight", 0));
        this.pop();
        iter = set.iterator();
        if (iter.hasNext()) {
            Array asAttributes = (Array)Pools.obtain(Array.class);
            asAttributes.clear();
            boolean elementEmitted = false;
            TiledMapTile tile = (TiledMapTile)iter.next();
            while (iter.hasNext()) {
                MapProperties tileProps = tile.getProperties();
                for (String attribute : asAttributes) {
                    if (!tileProps.containsKey(attribute)) continue;
                    if (!elementEmitted) {
                        this.element("tile");
                        elementEmitted = true;
                    }
                    this.attribute(attribute, tileProps.get(attribute));
                }
                this.tmx(tileProps, (Array<String>)asAttributes);
                tile = (TiledMapTile)iter.next();
            }
            asAttributes.clear();
            Pools.free((Object)asAttributes);
            if (elementEmitted) {
                this.pop();
            }
        }
        this.pop();
        return this;
    }

    public TmxMapWriter tmx(MapLayers layers, Format format) throws IOException {
        for (MapLayer layer : layers) {
            if (layer instanceof TiledMapTileLayer) {
                this.tmx((TiledMapTileLayer)layer, format);
                continue;
            }
            this.tmx(layer);
        }
        return this;
    }

    public TmxMapWriter tmx(MapLayer layer) throws IOException {
        this.element("objectgroup");
        this.attribute("name", layer.getName());
        this.tmx(layer.getProperties());
        this.tmx(layer.getObjects());
        this.pop();
        return this;
    }

    public TmxMapWriter tmx(TiledMapTileLayer layer, Format format) throws IOException {
        this.element("layer");
        this.attribute("name", layer.getName());
        this.attribute("width", layer.getWidth());
        this.attribute("height", layer.getHeight());
        this.attribute("visible", layer.isVisible() ? 1 : 0);
        this.attribute("opacity", Float.valueOf(layer.getOpacity()));
        this.tmx(layer.getProperties());
        this.element("data");
        if (format == Format.XML) {
            this.attribute("encoding", "xml");
            for (int y = layer.getHeight() - 1; y > -1; --y) {
                for (int x = 0; x < layer.getWidth(); ++x) {
                    TiledMapTile tile;
                    TiledMapTileLayer.Cell cell = layer.getCell(x, y);
                    if (cell == null || (tile = cell.getTile()) == null) continue;
                    this.element("tile");
                    this.attribute("gid", tile.getId());
                    this.pop();
                }
            }
        } else if (format == Format.CSV) {
            this.attribute("encoding", "csv");
            StringBuilder csv = new StringBuilder();
            for (int y = layer.getHeight() - 1; y > -1; --y) {
                for (int x = 0; x < layer.getWidth(); ++x) {
                    TiledMapTileLayer.Cell cell = layer.getCell(x, y);
                    TiledMapTile tile = cell != null ? cell.getTile() : null;
                    csv.append(tile != null ? tile.getId() : 0);
                    if (x + 1 >= layer.getWidth() && y - 1 <= -1) continue;
                    csv.append(',');
                }
                csv.append('\n');
            }
            this.append('\n').append((CharSequence)csv);
        } else if (format == Format.Base64 || format == Format.Base64Zlib || format == Format.Base64Gzip) {
            this.attribute("encoding", "base64");
            if (format == Format.Base64Zlib) {
                this.attribute("compression", "zlib");
            } else if (format == Format.Base64Gzip) {
                this.attribute("compression", "gzip");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream out = format == Format.Base64Zlib ? new DeflaterOutputStream(baos) : (format == Format.Base64Gzip ? new GZIPOutputStream(baos) : baos);
            int LAST_BYTE = 255;
            for (int y = layer.getHeight() - 1; y > -1; --y) {
                for (int x = 0; x < layer.getWidth(); ++x) {
                    TiledMapTileLayer.Cell cell = layer.getCell(x, y);
                    TiledMapTile tile = cell != null ? cell.getTile() : null;
                    int gid = tile != null ? tile.getId() : 0;
                    out.write(gid & 0xFF);
                    out.write(gid >> 8 & 0xFF);
                    out.write(gid >> 16 & 0xFF);
                    out.write(gid >> 24 & 0xFF);
                }
            }
            if (out instanceof DeflaterOutputStream) {
                ((DeflaterOutputStream)out).finish();
            }
            out.close();
            baos.close();
            this.append('\n').append(String.valueOf(Base64Coder.encode((byte[])baos.toByteArray()))).append('\n');
        }
        this.pop();
        this.pop();
        return this;
    }

    public TmxMapWriter tmx(MapObjects objects) throws IOException {
        for (MapObject object : objects) {
            this.tmx(object);
        }
        return this;
    }

    public TmxMapWriter tmx(MapObject object) throws IOException {
        MapProperties props = object.getProperties();
        this.element("object");
        this.attribute("name", object.getName());
        if (props.containsKey("type")) {
            this.attribute("type", MapUtils.getProperty(props, "type", ""));
        }
        if (props.containsKey("gid")) {
            this.attribute("gid", MapUtils.getProperty(props, "gid", 0));
        }
        int objectX = MapUtils.getProperty(props, "x", 0);
        int objectY = MapUtils.getProperty(props, "y", 0);
        if (object instanceof RectangleMapObject) {
            Rectangle rect = ((RectangleMapObject)object).getRectangle();
            int height = MathUtils.round((float)rect.height);
            this.attribute("x", objectX).attribute("y", (Object)this.toYDown(objectY + height));
            this.attribute("width", MathUtils.round((float)rect.width)).attribute("height", (Object)height);
        } else if (object instanceof EllipseMapObject) {
            Ellipse ellipse = ((EllipseMapObject)object).getEllipse();
            int height = MathUtils.round((float)ellipse.height);
            this.attribute("x", objectX).attribute("y", (Object)this.toYDown(objectY + height));
            this.attribute("width", MathUtils.round((float)ellipse.width)).attribute("height", (Object)height);
            this.element("ellipse").pop();
        } else if (object instanceof CircleMapObject) {
            Circle circle = ((CircleMapObject)object).getCircle();
            this.attribute("x", objectX).attribute("y", (Object)objectY);
            this.attribute("width", MathUtils.round((float)(circle.radius * 2.0f))).attribute("height", (Object)MathUtils.round((float)(circle.radius * 2.0f)));
            this.element("ellipse").pop();
        } else if (object instanceof PolygonMapObject) {
            this.attribute("x", objectX).attribute("y", (Object)this.toYDown(objectY));
            Polygon polygon = ((PolygonMapObject)object).getPolygon();
            this.element("polygon");
            FloatArray tmp = (FloatArray)Pools.obtain(FloatArray.class);
            tmp.clear();
            tmp.addAll(polygon.getVertices());
            this.attribute("points", this.points(GeometryUtils.toYDown(tmp)));
            tmp.clear();
            Pools.free((Object)tmp);
            this.pop();
        } else if (object instanceof PolylineMapObject) {
            this.attribute("x", objectX).attribute("y", (Object)this.toYDown(objectY));
            Polyline polyline = ((PolylineMapObject)object).getPolyline();
            this.element("polyline");
            FloatArray tmp = (FloatArray)Pools.obtain(FloatArray.class);
            tmp.clear();
            tmp.addAll(polyline.getVertices());
            this.attribute("points", this.points(GeometryUtils.toYDown(tmp)));
            tmp.clear();
            Pools.free((Object)tmp);
            this.pop();
        }
        if (props.containsKey("rotation")) {
            this.attribute("rotation", MapUtils.getProperty(props, "rotation", Float.valueOf(0.0f)));
        }
        if (props.containsKey("visible")) {
            this.attribute("visible", object.isVisible() ? 1 : 0);
        }
        if (object.getOpacity() != 1.0f) {
            this.attribute("opacity", Float.valueOf(object.getOpacity()));
        }
        Array excludedKeys = (Array)Pools.obtain(Array.class);
        excludedKeys.clear();
        excludedKeys.add((Object)"type");
        excludedKeys.add((Object)"gid");
        excludedKeys.add((Object)"x");
        excludedKeys.add((Object)"y");
        excludedKeys.add((Object)"width");
        excludedKeys.add((Object)"height");
        excludedKeys.add((Object)"rotation");
        excludedKeys.add((Object)"visible");
        excludedKeys.add((Object)"opacity");
        this.tmx(props, (Array<String>)excludedKeys);
        excludedKeys.clear();
        Pools.free((Object)excludedKeys);
        this.pop();
        return this;
    }

    private String points(FloatArray vertices) {
        StringBuilder points = new StringBuilder();
        for (int i = 0; i < vertices.size; ++i) {
            points.append(MathUtils.round((float)vertices.get(i))).append(i % 2 != 0 ? (i + 1 < vertices.size ? " " : "") : ",");
        }
        return points.toString();
    }

    public int toYDown(int y) {
        return MathUtils.round((float)this.toYDown((float)y));
    }

    public float toYDown(float y) {
        return net.dermetfan.utils.math.GeometryUtils.invertAxis(y, this.layerHeight);
    }

    public int getLayerHeight() {
        return this.layerHeight;
    }

    public void setLayerHeight(int layerHeight) {
        this.layerHeight = layerHeight;
    }

    public static enum Format {
        XML,
        CSV,
        Base64,
        Base64Zlib,
        Base64Gzip;

    }
}

