/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.math;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import net.dermetfan.gdx.math.GeometryUtils;

public abstract class BayazitDecomposer {
    public static final float EPSILON = 1.1920929E-7f;
    public static int maxPolygonVertices = 8;

    public static Vector2 cross(Vector2 a, float s) {
        return new Vector2(s * a.y, -s * a.x);
    }

    private static Vector2 at(int i, Array<Vector2> vertices) {
        return (Vector2)vertices.get(i < 0 ? vertices.size - -i % vertices.size : i % vertices.size);
    }

    private static Array<Vector2> copy(int i, int j, Array<Vector2> vertices) {
        Array p = new Array();
        while (j < i) {
            j += vertices.size;
        }
        while (i <= j) {
            p.add((Object)BayazitDecomposer.at(i, vertices));
            ++i;
        }
        return p;
    }

    public static Array<Array<Vector2>> convexPartition(Array<Vector2> vertices) {
        int i;
        if (GeometryUtils.areVerticesClockwise(vertices)) {
            vertices.reverse();
        }
        Array list = new Array();
        Vector2 lowerInt = new Vector2();
        Vector2 upperInt = new Vector2();
        int lowerIndex = 0;
        int upperIndex = 0;
        for (i = 0; i < vertices.size; ++i) {
            Array<Vector2> upperPoly;
            Array<Vector2> lowerPoly;
            if (!BayazitDecomposer.reflex(i, vertices)) continue;
            float upperDist = Float.MAX_VALUE;
            float lowerDist = Float.MAX_VALUE;
            for (int j = 0; j < vertices.size; ++j) {
                float d;
                Vector2 p;
                if (BayazitDecomposer.left(BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices)) && BayazitDecomposer.rightOn(BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j - 1, vertices))) {
                    p = BayazitDecomposer.lineIntersect(BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j - 1, vertices));
                    if (BayazitDecomposer.right(BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(i, vertices), p) && (d = BayazitDecomposer.squareDist(BayazitDecomposer.at(i, vertices), p)) < lowerDist) {
                        lowerDist = d;
                        lowerInt = p;
                        lowerIndex = j;
                    }
                }
                if (!BayazitDecomposer.left(BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j + 1, vertices)) || !BayazitDecomposer.rightOn(BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices))) continue;
                p = BayazitDecomposer.lineIntersect(BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j + 1, vertices));
                if (!BayazitDecomposer.left(BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(i, vertices), p) || !((d = BayazitDecomposer.squareDist(BayazitDecomposer.at(i, vertices), p)) < upperDist)) continue;
                upperDist = d;
                upperIndex = j;
                upperInt = p;
            }
            if (lowerIndex == (upperIndex + 1) % vertices.size) {
                Vector2 sp = new Vector2((lowerInt.x + upperInt.x) / 2.0f, (lowerInt.y + upperInt.y) / 2.0f);
                lowerPoly = BayazitDecomposer.copy(i, upperIndex, vertices);
                lowerPoly.add((Object)sp);
                upperPoly = BayazitDecomposer.copy(lowerIndex, i, vertices);
                upperPoly.add((Object)sp);
            } else {
                double highestScore = 0.0;
                double bestIndex = lowerIndex;
                while (upperIndex < lowerIndex) {
                    upperIndex += vertices.size;
                }
                for (int j = lowerIndex; j <= upperIndex; ++j) {
                    if (!BayazitDecomposer.canSee(i, j, vertices)) continue;
                    double score = 1.0f / (BayazitDecomposer.squareDist(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices)) + 1.0f);
                    score = BayazitDecomposer.reflex(j, vertices) ? (BayazitDecomposer.rightOn(BayazitDecomposer.at(j - 1, vertices), BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(i, vertices)) && BayazitDecomposer.leftOn(BayazitDecomposer.at(j + 1, vertices), BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(i, vertices)) ? (score += 3.0) : (score += 2.0)) : (score += 1.0);
                    if (!(score > highestScore)) continue;
                    bestIndex = j;
                    highestScore = score;
                }
                lowerPoly = BayazitDecomposer.copy(i, (int)bestIndex, vertices);
                upperPoly = BayazitDecomposer.copy((int)bestIndex, i, vertices);
            }
            list.addAll(BayazitDecomposer.convexPartition(lowerPoly));
            list.addAll(BayazitDecomposer.convexPartition(upperPoly));
            return list;
        }
        if (vertices.size > maxPolygonVertices) {
            Array<Vector2> lowerPoly = BayazitDecomposer.copy(0, vertices.size / 2, vertices);
            Array<Vector2> upperPoly = BayazitDecomposer.copy(vertices.size / 2, 0, vertices);
            list.addAll(BayazitDecomposer.convexPartition(lowerPoly));
            list.addAll(BayazitDecomposer.convexPartition(upperPoly));
        } else {
            list.add(vertices);
        }
        for (i = 0; i < list.size; ++i) {
            list.set(i, SimplifyTools.collinearSimplify((Array<Vector2>)((Array)list.get(i)), 0.0f));
        }
        for (i = list.size - 1; i >= 0; --i) {
            if (((Array)list.get((int)i)).size != 0) continue;
            list.removeIndex(i);
        }
        return list;
    }

    private static boolean canSee(int i, int j, Array<Vector2> vertices) {
        if (BayazitDecomposer.reflex(i, vertices) ? BayazitDecomposer.leftOn(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(j, vertices)) && BayazitDecomposer.rightOn(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(j, vertices)) : BayazitDecomposer.rightOn(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(i + 1, vertices), BayazitDecomposer.at(j, vertices)) || BayazitDecomposer.leftOn(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(j, vertices))) {
            return false;
        }
        if (BayazitDecomposer.reflex(j, vertices) ? BayazitDecomposer.leftOn(BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j - 1, vertices), BayazitDecomposer.at(i, vertices)) && BayazitDecomposer.rightOn(BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j + 1, vertices), BayazitDecomposer.at(i, vertices)) : BayazitDecomposer.rightOn(BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j + 1, vertices), BayazitDecomposer.at(i, vertices)) || BayazitDecomposer.leftOn(BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(j - 1, vertices), BayazitDecomposer.at(i, vertices))) {
            return false;
        }
        for (int k = 0; k < vertices.size; ++k) {
            if ((k + 1) % vertices.size == i || k == i || (k + 1) % vertices.size == j || k == j) continue;
            Vector2 intersectionPoint = new Vector2();
            if (!BayazitDecomposer.lineIntersect(BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(j, vertices), BayazitDecomposer.at(k, vertices), BayazitDecomposer.at(k + 1, vertices), true, true, intersectionPoint)) continue;
            return false;
        }
        return true;
    }

    public static Vector2 lineIntersect(Vector2 p1, Vector2 p2, Vector2 q1, Vector2 q2) {
        Vector2 i = new Vector2();
        float a1 = p2.y - p1.y;
        float b1 = p1.x - p2.x;
        float c1 = a1 * p1.x + b1 * p1.y;
        float a2 = q2.y - q1.y;
        float b2 = q1.x - q2.x;
        float c2 = a2 * q1.x + b2 * q1.y;
        float det = a1 * b2 - a2 * b1;
        if (!BayazitDecomposer.floatEquals(det, 0.0f)) {
            i.x = (b2 * c1 - b1 * c2) / det;
            i.y = (a1 * c2 - a2 * c1) / det;
        }
        return i;
    }

    public static boolean floatEquals(float value1, float value2) {
        return Math.abs(value1 - value2) <= 1.1920929E-7f;
    }

    public static boolean lineIntersect(Vector2 point1, Vector2 point2, Vector2 point3, Vector2 point4, boolean firstIsSegment, boolean secondIsSegment, Vector2 point) {
        point = new Vector2();
        float a = point4.y - point3.y;
        float b = point2.x - point1.x;
        float c = point4.x - point3.x;
        float d = point2.y - point1.y;
        float denom = a * b - c * d;
        if (!(denom >= -1.1920929E-7f) || !(denom <= 1.1920929E-7f)) {
            float e = point1.y - point3.y;
            float f = point1.x - point3.x;
            float oneOverDenom = 1.0f / denom;
            float ua = c * e - a * f;
            ua *= oneOverDenom;
            if (!firstIsSegment || ua >= 0.0f && ua <= 1.0f) {
                float ub = b * e - d * f;
                if ((!secondIsSegment || ub >= 0.0f && ub <= 1.0f) && (ua != 0.0f || (ub *= oneOverDenom) != 0.0f)) {
                    point.x = point1.x + ua * b;
                    point.y = point1.y + ua * d;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean reflex(int i, Array<Vector2> vertices) {
        return BayazitDecomposer.right(i, vertices);
    }

    private static boolean right(int i, Array<Vector2> vertices) {
        return BayazitDecomposer.right(BayazitDecomposer.at(i - 1, vertices), BayazitDecomposer.at(i, vertices), BayazitDecomposer.at(i + 1, vertices));
    }

    private static boolean left(Vector2 a, Vector2 b, Vector2 c) {
        return BayazitDecomposer.area(a, b, c) > 0.0f;
    }

    private static boolean leftOn(Vector2 a, Vector2 b, Vector2 c) {
        return BayazitDecomposer.area(a, b, c) >= 0.0f;
    }

    private static boolean right(Vector2 a, Vector2 b, Vector2 c) {
        return BayazitDecomposer.area(a, b, c) < 0.0f;
    }

    private static boolean rightOn(Vector2 a, Vector2 b, Vector2 c) {
        return BayazitDecomposer.area(a, b, c) <= 0.0f;
    }

    public static float area(Vector2 a, Vector2 b, Vector2 c) {
        return a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
    }

    private static float squareDist(Vector2 a, Vector2 b) {
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        return dx * dx + dy * dy;
    }

    public static class SimplifyTools {
        private static boolean[] usePt;
        private static double distanceTolerance;

        public static Array<Vector2> collinearSimplify(Array<Vector2> vertices, float collinearityTolerance) {
            if (vertices.size < 3) {
                return vertices;
            }
            Array simplified = new Array();
            for (int i = 0; i < vertices.size; ++i) {
                Vector2 next;
                Vector2 current;
                Vector2 prev;
                int nextId;
                int prevId = i - 1;
                if (prevId < 0) {
                    prevId = vertices.size - 1;
                }
                if ((nextId = i + 1) >= vertices.size) {
                    nextId = 0;
                }
                if (SimplifyTools.collinear(prev = (Vector2)vertices.get(prevId), current = (Vector2)vertices.get(i), next = (Vector2)vertices.get(nextId), collinearityTolerance)) continue;
                simplified.add((Object)current);
            }
            return simplified;
        }

        public static boolean collinear(Vector2 a, Vector2 b, Vector2 c, float tolerance) {
            return SimplifyTools.floatInRange(BayazitDecomposer.area(a, b, c), -tolerance, tolerance);
        }

        public static boolean floatInRange(float value, float min, float max) {
            return value >= min && value <= max;
        }

        public static Array<Vector2> collinearSimplify(Array<Vector2> vertices) {
            return SimplifyTools.collinearSimplify(vertices, 0.0f);
        }

        public static Array<Vector2> douglasPeuckerSimplify(Array<Vector2> vertices, float distanceTolerance) {
            SimplifyTools.distanceTolerance = distanceTolerance;
            usePt = new boolean[vertices.size];
            for (int i = 0; i < vertices.size; ++i) {
                SimplifyTools.usePt[i] = true;
            }
            SimplifyTools.simplifySection(vertices, 0, vertices.size - 1);
            Array result = new Array();
            for (int i = 0; i < vertices.size; ++i) {
                if (!usePt[i]) continue;
                result.add(vertices.get(i));
            }
            return result;
        }

        private static void simplifySection(Array<Vector2> vertices, int i, int j) {
            int k;
            if (i + 1 == j) {
                return;
            }
            Vector2 A = (Vector2)vertices.get(i);
            Vector2 B = (Vector2)vertices.get(j);
            double maxDistance = -1.0;
            int maxIndex = i;
            for (k = i + 1; k < j; ++k) {
                double distance = SimplifyTools.distancePointLine((Vector2)vertices.get(k), A, B);
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                maxIndex = k;
            }
            if (maxDistance <= distanceTolerance) {
                for (k = i + 1; k < j; ++k) {
                    SimplifyTools.usePt[k] = false;
                }
            } else {
                SimplifyTools.simplifySection(vertices, i, maxIndex);
                SimplifyTools.simplifySection(vertices, maxIndex, j);
            }
        }

        private static double distancePointPoint(Vector2 p, Vector2 p2) {
            double dx = p.x - p2.x;
            double dy = p.y - p2.x;
            return Math.sqrt(dx * dx + dy * dy);
        }

        private static double distancePointLine(Vector2 p, Vector2 A, Vector2 B) {
            if (A.x == B.x && A.y == B.y) {
                return SimplifyTools.distancePointPoint(p, A);
            }
            double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
            if (r <= 0.0) {
                return SimplifyTools.distancePointPoint(p, A);
            }
            if (r >= 1.0) {
                return SimplifyTools.distancePointPoint(p, B);
            }
            double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
            return Math.abs(s) * Math.sqrt((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        }

        public static Array<Vector2> reduceByArea(Array<Vector2> vertices, float areaTolerance) {
            if (vertices.size <= 3) {
                return vertices;
            }
            if (areaTolerance < 0.0f) {
                throw new IllegalArgumentException("areaTolerance: must be equal to or greater then zero.");
            }
            Array result = new Array();
            Vector2 v1 = (Vector2)vertices.get(vertices.size - 2);
            Vector2 v2 = (Vector2)vertices.get(vertices.size - 1);
            areaTolerance *= 2.0f;
            for (int index = 0; index < vertices.size; ++index) {
                Vector2 v3;
                if (index == vertices.size - 1) {
                    if (result.size == 0) {
                        throw new IllegalArgumentException("areaTolerance: The tolerance is too high!");
                    }
                    v3 = (Vector2)result.get(0);
                } else {
                    v3 = (Vector2)vertices.get(index);
                }
                float old1 = SimplifyTools.cross(v1, v2).floatValue();
                float old2 = SimplifyTools.cross(v2, v3).floatValue();
                float new1 = SimplifyTools.cross(v1, v3).floatValue();
                if (Math.abs(new1 - (old1 + old2)) > areaTolerance) {
                    result.add((Object)v2);
                    v1 = v2;
                }
                v2 = v3;
            }
            return result;
        }

        public static Float cross(Vector2 a, Vector2 b) {
            return Float.valueOf(a.x * b.y - a.y * b.x);
        }

        public static void mergeParallelEdges(Array<Vector2> vertices, float tolerance) {
            if (vertices.size <= 3) {
                return;
            }
            boolean[] mergeMe = new boolean[vertices.size];
            int newNVertices = vertices.size;
            for (int i = 0; i < vertices.size; ++i) {
                int lower = i == 0 ? vertices.size - 1 : i - 1;
                int middle = i;
                int upper = i == vertices.size - 1 ? 0 : i + 1;
                float dx0 = ((Vector2)vertices.get((int)middle)).x - ((Vector2)vertices.get((int)lower)).x;
                float dy0 = ((Vector2)vertices.get((int)middle)).y - ((Vector2)vertices.get((int)lower)).y;
                float dx1 = ((Vector2)vertices.get((int)upper)).y - ((Vector2)vertices.get((int)middle)).x;
                float dy1 = ((Vector2)vertices.get((int)upper)).y - ((Vector2)vertices.get((int)middle)).y;
                float norm0 = (float)Math.sqrt(dx0 * dx0 + dy0 * dy0);
                float norm1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
                if (!(norm0 > 0.0f && norm1 > 0.0f || newNVertices <= 3)) {
                    mergeMe[i] = true;
                    --newNVertices;
                }
                float cross = (dx0 /= norm0) * (dy1 /= norm1) - (dx1 /= norm1) * (dy0 /= norm0);
                float dot = dx0 * dx1 + dy0 * dy1;
                if (Math.abs(cross) < tolerance && dot > 0.0f && newNVertices > 3) {
                    mergeMe[i] = true;
                    --newNVertices;
                    continue;
                }
                mergeMe[i] = false;
            }
            if (newNVertices == vertices.size || newNVertices == 0) {
                return;
            }
            int currIndex = 0;
            Array oldVertices = new Array(vertices);
            vertices.clear();
            for (int i = 0; i < oldVertices.size; ++i) {
                if (mergeMe[i] || newNVertices == 0 || currIndex == newNVertices) continue;
                vertices.add(oldVertices.get(i));
                ++currIndex;
            }
        }

        public static Array<Vector2> mergeIdenticalPoints(Array<Vector2> vertices) {
            Array results = new Array();
            for (int i = 0; i < vertices.size; ++i) {
                Vector2 vOriginal = (Vector2)vertices.get(i);
                boolean alreadyExists = false;
                for (int j = 0; j < results.size; ++j) {
                    Vector2 v = (Vector2)results.get(j);
                    if (!vOriginal.equals((Object)v)) continue;
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) continue;
                results.add(vertices.get(i));
            }
            return results;
        }

        public static Array<Vector2> reduceByDistance(Array<Vector2> vertices, float distance) {
            if (vertices.size < 3) {
                return vertices;
            }
            Array simplified = new Array();
            for (int i = 0; i < vertices.size; ++i) {
                Vector2 current = (Vector2)vertices.get(i);
                int ii = i + 1;
                if (ii >= vertices.size) {
                    ii = 0;
                }
                Vector2 next = (Vector2)vertices.get(ii);
                Vector2 diff = new Vector2(next.x - current.x, next.y - current.y);
                if (diff.len2() <= distance) continue;
                simplified.add((Object)current);
            }
            return simplified;
        }

        public static Array<Vector2> reduceByNth(Array<Vector2> vertices, int nth) {
            if (vertices.size < 3) {
                return vertices;
            }
            if (nth == 0) {
                return vertices;
            }
            Array result = new Array(vertices.size);
            for (int i = 0; i < vertices.size; ++i) {
                if (i % nth == 0) continue;
                result.add(vertices.get(i));
            }
            return result;
        }
    }
}

