/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;

public class Scene2DUtils {
    private static final Vector2 tmp = new Vector2();

    public static void copy(Event e, Event c) {
        c.setTarget(e.getTarget());
        c.setStage(e.getStage());
        c.setCapture(e.isCapture());
        c.setBubbles(e.getBubbles());
        c.setListenerActor(e.getListenerActor());
    }

    public static void copy(InputEvent e, InputEvent c) {
        Scene2DUtils.copy((Event)e, (Event)c);
        c.setStageX(e.getStageX());
        c.setStageY(e.getStageY());
        c.setButton(e.getButton());
        c.setCharacter(e.getCharacter());
        c.setKeyCode(e.getKeyCode());
        c.setPointer(e.getPointer());
        c.setType(e.getType());
        c.setRelatedActor(e.getRelatedActor());
        c.setScrollAmount(e.getScrollAmount());
    }

    public static Vector2 localToOtherCoordinates(Vector2 pos, Actor actor, Actor other) {
        Group lastParent = Scene2DUtils.lastParent(actor);
        if (lastParent == null || lastParent != Scene2DUtils.lastParent(other)) {
            throw new IllegalArgumentException(actor + " and " + other + " are not in the same hierarchy");
        }
        actor.localToAscendantCoordinates((Actor)lastParent, pos);
        lastParent.localToDescendantCoordinates(other, pos);
        return pos;
    }

    @Deprecated
    public static Vector2 stageToLocalCoordinates(Vector2 pos, Actor actor) {
        if (actor == actor.getStage().getRoot()) {
            return pos;
        }
        return actor.getStage().getRoot().localToDescendantCoordinates(actor, pos);
    }

    @Deprecated
    public static Vector2 stageToLocalCoordinates(float x, float y, Actor actor) {
        return Scene2DUtils.stageToLocalCoordinates(tmp.set(x, y), actor);
    }

    public static Group lastParent(Actor actor) {
        if (!actor.hasParent()) {
            return null;
        }
        Group parent = actor.getParent();
        while (parent.hasParent()) {
            parent = parent.getParent();
        }
        assert (!parent.hasParent());
        return parent;
    }

    public static Vector2 positionInStageCoordinates(Actor actor) {
        if (actor.hasParent()) {
            actor.localToStageCoordinates(tmp.set(0.0f, 0.0f));
        } else {
            tmp.set(actor.getX(), actor.getY());
        }
        return tmp;
    }

    public static void addAtStageCoordinates(Actor actor, Group newParent) {
        tmp.set(Scene2DUtils.positionInStageCoordinates(actor));
        newParent.stageToLocalCoordinates(tmp);
        newParent.addActor(actor);
        actor.setPosition(Scene2DUtils.tmp.x, Scene2DUtils.tmp.y);
    }

    public static Vector2 pointerPosition(Stage stage) {
        return Scene2DUtils.pointerPosition(stage, 0);
    }

    public static Vector2 pointerPosition(Stage stage, int pointer) {
        tmp.set((float)Gdx.input.getX(pointer), (float)Gdx.input.getY(pointer));
        stage.screenToStageCoordinates(tmp);
        return tmp;
    }

    public static Vector2 align(float width, float height, int align) {
        tmp.setZero();
        if ((align & 1) == 1) {
            tmp.set(width / 2.0f, height / 2.0f);
        }
        if ((align & 0x10) == 16) {
            Scene2DUtils.tmp.x = width;
        }
        if ((align & 8) == 8) {
            Scene2DUtils.tmp.x = 0.0f;
        }
        if ((align & 2) == 2) {
            Scene2DUtils.tmp.y = height;
        }
        if ((align & 4) == 4) {
            Scene2DUtils.tmp.y = 0.0f;
        }
        return tmp;
    }
}

