/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class CircularGroup
extends WidgetGroup {
    private float fullAngle;
    private float angleOffset;
    private float minAngleOffset;
    private float maxAngleOffset;
    private boolean virtualChildEnabled;
    private Modifier modifier;
    private boolean shrinkChildren;
    private final DragManager dragManager;
    private float cachedMinWidth;
    private float cachedMinHeight;
    private float cachedPrefWidth;
    private float cachedPrefHeight;
    private boolean sizeInvalid;
    private final Vector2 tmp;

    public CircularGroup() {
        this(null);
    }

    public CircularGroup(Modifier modifier) {
        this.maxAngleOffset = this.fullAngle = 360.0f;
        this.virtualChildEnabled = true;
        this.shrinkChildren = true;
        this.dragManager = new DragManager();
        this.sizeInvalid = true;
        this.tmp = new Vector2();
        this.modifier = modifier != null ? modifier : new Modifier.Adapter();
    }

    public CircularGroup(boolean draggable) {
        this(null, draggable);
    }

    public CircularGroup(Modifier modifier, boolean draggable) {
        this(modifier);
        this.setDraggable(draggable);
    }

    public void act(float delta) {
        this.dragManager.act(delta);
        super.act(delta);
    }

    public void drawDebug(ShapeRenderer shapes) {
        super.drawDebug(shapes);
        shapes.set(ShapeRenderer.ShapeType.Line);
        shapes.setColor(Color.CYAN);
        shapes.ellipse(this.getX(), this.getY(), this.getWidth() * this.getScaleX(), this.getHeight() * this.getScaleY());
        SnapshotArray children = this.getChildren();
        for (int index = 0; index < children.size; ++index) {
            Actor child = (Actor)children.get(index);
            this.tmp.set(this.modifier.localAnchor(this.tmp.set(child.getWidth(), child.getHeight() / 2.0f), child, index, children.size, this));
            shapes.line(this.getX() + this.getWidth() / 2.0f * this.getScaleX(), this.getY() + this.getHeight() / 2.0f * this.getScaleY(), this.getX() + (child.getX() + this.tmp.x) * this.getScaleX(), this.getY() + (child.getY() + this.tmp.y) * this.getScaleY());
        }
    }

    protected void computeSize() {
        this.cachedMinHeight = Float.POSITIVE_INFINITY;
        this.cachedMinWidth = Float.POSITIVE_INFINITY;
        this.cachedPrefHeight = 0.0f;
        this.cachedPrefWidth = 0.0f;
        SnapshotArray children = this.getChildren();
        for (int index = 0; index < children.size; ++index) {
            float prefHeight;
            float prefWidth;
            float minHeight;
            float minWidth;
            Actor child = (Actor)children.get(index);
            if (child instanceof Layout) {
                Layout layout = (Layout)child;
                minWidth = layout.getMinWidth();
                minHeight = layout.getMinHeight();
                prefWidth = layout.getPrefWidth();
                prefHeight = layout.getPrefHeight();
            } else {
                minWidth = prefWidth = child.getWidth();
                minHeight = prefHeight = child.getHeight();
            }
            this.tmp.set(this.modifier.anchorOffset(this.tmp.setZero(), child, index, children.size, this));
            float offsetX = this.tmp.x;
            float offsetY = this.tmp.y;
            this.tmp.set(this.modifier.localAnchor(this.tmp.set(minWidth, minHeight / 2.0f), child, index, children.size, this)).sub(offsetX, offsetY);
            minWidth = this.tmp.x < minWidth || this.tmp.x < 0.0f ? (minWidth -= this.tmp.x) : (minWidth += this.tmp.x - minWidth);
            minHeight = this.tmp.y < minHeight || this.tmp.y < 0.0f ? (minHeight -= this.tmp.y) : (minHeight += this.tmp.y - minHeight);
            this.tmp.set(this.modifier.localAnchor(this.tmp.set(prefWidth, prefHeight / 2.0f), child, index, children.size, this)).sub(offsetX, offsetY);
            prefWidth = this.tmp.x < prefWidth || this.tmp.x < 0.0f ? (prefWidth -= this.tmp.x) : (prefWidth += this.tmp.x - prefWidth);
            prefHeight = this.tmp.y < prefHeight || this.tmp.y < 0.0f ? (prefHeight -= this.tmp.y) : (prefHeight += this.tmp.y - prefHeight);
            if (minWidth < this.cachedMinWidth) {
                this.cachedMinWidth = minWidth;
            }
            if (minHeight < this.cachedMinHeight) {
                this.cachedMinHeight = minHeight;
            }
            if (prefWidth > this.cachedPrefWidth) {
                this.cachedPrefWidth = prefWidth;
            }
            if (!(prefHeight > this.cachedPrefHeight)) continue;
            this.cachedPrefHeight = prefHeight;
        }
        this.cachedMinWidth *= 2.0f;
        this.cachedMinHeight *= 2.0f;
        this.cachedPrefWidth *= 2.0f;
        this.cachedPrefHeight *= 2.0f;
        this.cachedMinWidth = this.cachedMinHeight = Math.max(this.cachedMinWidth, this.cachedMinHeight);
        this.cachedPrefWidth = this.cachedPrefHeight = Math.max(this.cachedPrefWidth, this.cachedPrefHeight);
        this.sizeInvalid = false;
    }

    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.cachedMinWidth;
    }

    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.cachedMinHeight;
    }

    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.cachedPrefWidth;
    }

    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.cachedPrefHeight;
    }

    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    public void layout() {
        float prefWidthUnderflow = this.shrinkChildren ? Math.max(0.0f, this.getPrefWidth() - this.getWidth()) / 2.0f : 0.0f;
        float prefHeightUnderflow = this.shrinkChildren ? Math.max(0.0f, this.getPrefHeight() - this.getHeight()) / 2.0f : 0.0f;
        SnapshotArray children = this.getChildren();
        for (int index = 0; index < children.size; ++index) {
            float height;
            float width;
            Actor child = (Actor)children.get(index);
            if (child instanceof Layout) {
                Layout childLayout = (Layout)child;
                width = childLayout.getPrefWidth() - prefWidthUnderflow;
                width = Math.max(width, childLayout.getMinWidth());
                if (childLayout.getMaxWidth() != 0.0f) {
                    width = Math.min(width, childLayout.getMaxWidth());
                }
                height = childLayout.getPrefHeight() - prefHeightUnderflow;
                height = Math.max(height, childLayout.getMinHeight());
                if (childLayout.getMaxHeight() != 0.0f) {
                    height = Math.min(height, childLayout.getMaxHeight());
                }
                child.setSize(width, height);
                childLayout.validate();
            } else {
                width = child.getWidth();
                height = child.getHeight();
            }
            float angle = this.fullAngle / (float)(children.size - (this.virtualChildEnabled ? 0 : 1)) * (float)index;
            angle += this.angleOffset;
            angle = this.modifier.angle(angle, child, index, children.size, this);
            float rotation = this.modifier.rotation(angle, child, index, children.size, this);
            this.tmp.set(this.modifier.anchorOffset(this.tmp.setZero(), child, index, children.size, this));
            this.tmp.rotate(angle);
            float offsetX = this.tmp.x;
            float offsetY = this.tmp.y;
            this.tmp.set(this.modifier.localAnchor(this.tmp.set(width, height / 2.0f), child, index, children.size, this));
            float localAnchorX = this.tmp.x;
            float localAnchorY = this.tmp.y;
            child.setOrigin(localAnchorX, localAnchorY);
            child.setRotation(rotation);
            child.setPosition(this.getWidth() / 2.0f + offsetX - localAnchorX, this.getHeight() / 2.0f + offsetY - localAnchorY);
        }
    }

    public boolean isDraggable() {
        return this.dragManager.isDraggingActivated();
    }

    public void setDraggable(boolean draggable) {
        this.dragManager.setDraggingActivated(draggable);
        if (draggable) {
            this.addListener((EventListener)this.dragManager);
        } else {
            this.removeListener((EventListener)this.dragManager);
        }
    }

    public void translateAngleOffsetLimits(float amount) {
        this.setMinAngleOffset(this.minAngleOffset + amount);
        this.setMaxAngleOffset(this.maxAngleOffset + amount);
    }

    public float getFullAngle() {
        return this.fullAngle;
    }

    public void setFullAngle(float fullAngle) {
        this.setFullAngle(fullAngle, fullAngle >= 360.0f);
    }

    public void setFullAngle(float fullAngle, boolean virtualChildEnabled) {
        this.fullAngle = fullAngle;
        this.virtualChildEnabled = virtualChildEnabled;
        this.invalidate();
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    public void setAngleOffset(float angleOffset) {
        this.angleOffset = MathUtils.clamp((float)angleOffset, (float)this.minAngleOffset, (float)this.maxAngleOffset);
        this.invalidate();
    }

    public float getMinAngleOffset() {
        return this.minAngleOffset;
    }

    public void setMinAngleOffset(float minAngleOffset) {
        if (minAngleOffset > this.maxAngleOffset) {
            throw new IllegalArgumentException("minAngleOffset must not be > maxAngleOffset");
        }
        this.minAngleOffset = minAngleOffset;
        this.angleOffset = Math.max(minAngleOffset, this.angleOffset);
    }

    public float getMaxAngleOffset() {
        return this.maxAngleOffset;
    }

    public void setMaxAngleOffset(float maxAngleOffset) {
        if (maxAngleOffset < this.minAngleOffset) {
            throw new IllegalArgumentException("maxAngleOffset must not be < minAngleOffset");
        }
        this.maxAngleOffset = maxAngleOffset;
        this.angleOffset = Math.min(this.angleOffset, maxAngleOffset);
    }

    public boolean isVirtualChildEnabled() {
        return this.virtualChildEnabled;
    }

    public void setVirtualChildEnabled(boolean virtualChildEnabled) {
        this.virtualChildEnabled = virtualChildEnabled;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException("modifier must not be null");
        }
        this.modifier = modifier;
        this.invalidateHierarchy();
    }

    public boolean isShrinkChildren() {
        return this.shrinkChildren;
    }

    public void setShrinkChildren(boolean shrinkChildren) {
        this.shrinkChildren = shrinkChildren;
    }

    public DragManager getDragManager() {
        return this.dragManager;
    }

    public class DragManager
    extends DragListener {
        private boolean velocityActivated = true;
        private boolean draggingActivated = true;
        private float velocity;
        private float deceleration = 500.0f;
        private boolean dragging;
        private float previousAngle;
        private float maxAbsDelta = 350.0f;

        private DragManager() {
        }

        public void dragStart(InputEvent event, float x, float y, int pointer) {
            if (!this.draggingActivated) {
                return;
            }
            this.velocity = 0.0f;
            this.dragging = true;
            this.previousAngle = this.angle(x, y);
        }

        public void drag(InputEvent event, float x, float y, int pointer) {
            if (!this.draggingActivated) {
                return;
            }
            float currentAngle = this.angle(x, y);
            float delta = currentAngle - this.previousAngle;
            this.previousAngle = currentAngle;
            if (Math.abs(delta) > this.maxAbsDelta) {
                return;
            }
            this.velocity = delta * (float)Gdx.graphics.getFramesPerSecond();
            float newAngleOffset = CircularGroup.this.angleOffset + delta;
            float oldAngleOffset = CircularGroup.this.angleOffset;
            this.setAngleOffset(newAngleOffset);
            if (CircularGroup.this.angleOffset != oldAngleOffset) {
                CircularGroup.this.invalidate();
            }
        }

        public void dragStop(InputEvent event, float x, float y, int pointer) {
            if (!this.draggingActivated) {
                return;
            }
            this.dragging = false;
        }

        public void act(float delta) {
            if (this.dragging || this.velocity == 0.0f || !this.velocityActivated) {
                return;
            }
            this.setAngleOffset(CircularGroup.this.angleOffset + this.velocity * delta);
            CircularGroup.this.invalidate();
            if (this.deceleration == 0.0f) {
                return;
            }
            this.velocity = net.dermetfan.utils.math.MathUtils.approachZero(this.velocity, this.deceleration * delta);
        }

        private float angle(float x, float y) {
            return CircularGroup.this.tmp.set(x, y).sub(CircularGroup.this.getWidth() / 2.0f, CircularGroup.this.getHeight() / 2.0f).angle();
        }

        private void setAngleOffset(float angleOffset) {
            if (CircularGroup.this.maxAngleOffset - CircularGroup.this.minAngleOffset == 360.0f) {
                CircularGroup.this.angleOffset = net.dermetfan.utils.math.MathUtils.normalize(angleOffset, CircularGroup.this.minAngleOffset, CircularGroup.this.maxAngleOffset, false, false);
            } else {
                CircularGroup.this.setAngleOffset(angleOffset);
            }
        }

        public boolean isVelocityActivated() {
            return this.velocityActivated;
        }

        public void setVelocityActivated(boolean velocityActivated) {
            this.velocityActivated = velocityActivated;
        }

        public boolean isDraggingActivated() {
            return this.draggingActivated;
        }

        public void setDraggingActivated(boolean draggingActivated) {
            this.draggingActivated = draggingActivated;
        }

        public float getVelocity() {
            return this.velocity;
        }

        public void setVelocity(float velocity) {
            this.velocity = velocity;
        }

        public float getDeceleration() {
            return this.deceleration;
        }

        public void setDeceleration(float deceleration) {
            this.deceleration = deceleration;
        }

        public float getMaxAbsDelta() {
            return this.maxAbsDelta;
        }

        public void setMaxAbsDelta(float maxAbsDelta) {
            this.maxAbsDelta = maxAbsDelta;
        }
    }

    public static interface Modifier {
        public float angle(float var1, Actor var2, int var3, int var4, CircularGroup var5);

        public float rotation(float var1, Actor var2, int var3, int var4, CircularGroup var5);

        public Vector2 anchorOffset(Vector2 var1, Actor var2, int var3, int var4, CircularGroup var5);

        public Vector2 localAnchor(Vector2 var1, Actor var2, int var3, int var4, CircularGroup var5);

        public static class Adapter
        implements Modifier {
            @Override
            public float angle(float defaultAngle, Actor child, int index, int numChildren, CircularGroup group) {
                return defaultAngle;
            }

            @Override
            public float rotation(float angle, Actor child, int index, int numChildren, CircularGroup group) {
                return angle;
            }

            @Override
            public Vector2 anchorOffset(Vector2 anchorOffset, Actor child, int index, int numChildren, CircularGroup group) {
                return anchorOffset;
            }

            @Override
            public Vector2 localAnchor(Vector2 localAnchor, Actor child, int index, int numChildren, CircularGroup group) {
                return localAnchor;
            }
        }
    }
}

