/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Timer;
import net.dermetfan.gdx.Multiplexer;
import net.dermetfan.gdx.scenes.scene2d.Scene2DUtils;

public class Popup<T extends Actor>
implements EventListener {
    private T popup;
    private Behavior behavior;

    public Popup(T popup, Behavior behavior) {
        this.popup = popup;
        this.behavior = behavior;
    }

    public Popup(T popup, Behavior ... behaviors) {
        this(popup, (Behavior)new BehaviorMultiplexer(behaviors));
    }

    public boolean show() {
        Event dummy = (Event)Pools.obtain(InputEvent.class);
        boolean result = this.show(dummy);
        Pools.free((Object)dummy);
        return result;
    }

    public boolean show(Event event) {
        return this.behavior.show(event, this);
    }

    public boolean hide() {
        Event dummy = (Event)Pools.obtain(InputEvent.class);
        boolean result = this.hide(dummy);
        Pools.free((Object)dummy);
        return result;
    }

    public boolean hide(Event event) {
        return this.behavior.hide(event, this);
    }

    public boolean handle(Event event) {
        Reaction reaction = this.behavior.handle(event, this);
        if (reaction == null) {
            reaction = Reaction.None;
        }
        switch (reaction) {
            case ShowHandle: 
            case Show: {
                this.show(event);
                break;
            }
            case HideHandle: 
            case Hide: {
                this.hide(event);
            }
        }
        return reaction.handles;
    }

    public boolean isAscendantOf(Actor child) {
        if (this.popup == child) {
            return true;
        }
        for (EventListener listener : this.popup.getListeners()) {
            if (!(listener instanceof Popup) || !((Popup)listener).isAscendantOf(child)) continue;
            return true;
        }
        return false;
    }

    public T getPopup() {
        return this.popup;
    }

    public void setPopup(T popup) {
        this.popup = popup;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    public static class PositionBehavior
    extends Behavior.Adapter {
        private Position position;

        public PositionBehavior(Position position) {
            this.position = position;
        }

        public PositionBehavior(Position ... positions) {
            this((Position)new PositionMultiplexer(positions));
        }

        @Override
        public boolean show(Event event, Popup popup) {
            this.position.apply(event, (Actor)popup.getPopup());
            return super.show(event, popup);
        }

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            this.position = position;
        }

        public static class AlignedOffsetPosition
        implements Position {
            private int align;

            public AlignedOffsetPosition(int align) {
                this.align = align;
            }

            @Override
            public void apply(Event event, Actor popup) {
                Vector2 offset = Scene2DUtils.align(popup.getWidth(), popup.getHeight(), this.align);
                popup.setPosition(popup.getX() - offset.x, popup.getY() - offset.y);
            }

            public int getAlign() {
                return this.align;
            }

            public void setAlign(int align) {
                this.align = align;
            }
        }

        public static class AlignPosition
        implements Position {
            private int targetAlign;
            private int align;

            public AlignPosition(int targetAlign, int align) {
                this.targetAlign = targetAlign;
                this.align = align;
            }

            @Override
            public void apply(Event event, Actor popup) {
                Actor target = event.getTarget();
                Vector2 pos = ((Vector2)Pools.obtain(Vector2.class)).setZero();
                pos.set(Scene2DUtils.align(target.getWidth(), target.getHeight(), this.targetAlign));
                target.localToStageCoordinates(pos);
                popup.stageToLocalCoordinates(pos);
                popup.localToParentCoordinates(pos);
                popup.setPosition(pos.x, pos.y, this.align);
                Pools.free((Object)pos);
            }

            public int getAlign() {
                return this.align;
            }

            public void setAlign(int align) {
                this.align = align;
            }

            public int getTargetAlign() {
                return this.targetAlign;
            }

            public void setTargetAlign(int targetAlign) {
                this.targetAlign = targetAlign;
            }
        }

        public static class EventPosition
        implements Position {
            @Override
            public void apply(Event event, Actor popup) {
                if (event instanceof InputEvent) {
                    InputEvent inputEvent = (InputEvent)event;
                    Vector2 pos = (Vector2)Pools.obtain(Vector2.class);
                    pos.set(inputEvent.getStageX(), inputEvent.getStageY());
                    if (popup.hasParent()) {
                        popup.getParent().stageToLocalCoordinates(pos);
                    }
                    popup.setPosition(pos.x, pos.y);
                    Pools.free((Object)pos);
                } else {
                    popup.setPosition(Float.NaN, Float.NaN);
                }
            }
        }

        public static class OffsetPosition
        implements Position {
            private float x;
            private float y;

            public OffsetPosition(float x, float y) {
                this.x = x;
                this.y = y;
            }

            @Override
            public void apply(Event event, Actor popup) {
                popup.setPosition(popup.getX() + this.x, popup.getY() + this.y);
            }

            public float getX() {
                return this.x;
            }

            public void setX(float x) {
                this.x = x;
            }

            public float getY() {
                return this.y;
            }

            public void setY(float y) {
                this.y = y;
            }
        }

        public static class PresetPosition
        implements Position {
            private float x;
            private float y;

            public PresetPosition() {
            }

            public PresetPosition(float x, float y) {
                this.x = x;
                this.y = y;
            }

            @Override
            public void apply(Event event, Actor popup) {
                popup.setPosition(this.x, this.y);
            }

            public float getX() {
                return this.x;
            }

            public void setX(float x) {
                this.x = x;
            }

            public float getY() {
                return this.y;
            }

            public void setY(float y) {
                this.y = y;
            }
        }

        public static class PointerPosition
        implements Position {
            private int pointer;

            public PointerPosition() {
            }

            public PointerPosition(int pointer) {
                this.pointer = pointer;
            }

            @Override
            public void apply(Event event, Actor popup) {
                Vector2 pos = Scene2DUtils.pointerPosition(event.getStage(), this.pointer);
                if (popup.hasParent()) {
                    popup.getParent().stageToLocalCoordinates(pos);
                }
                popup.setPosition(pos.x, pos.y);
            }

            public int getPointer() {
                return this.pointer;
            }

            public void setPointer(int pointer) {
                this.pointer = pointer;
            }
        }

        public static class PositionMultiplexer
        extends Multiplexer<Position>
        implements Position {
            public PositionMultiplexer() {
            }

            public PositionMultiplexer(int size) {
                super(size);
            }

            public PositionMultiplexer(Position ... receivers) {
                super(receivers);
            }

            public PositionMultiplexer(Array<Position> receivers) {
                super(receivers);
            }

            @Override
            public void apply(Event event, Actor popup) {
                for (Position position : this.receivers) {
                    position.apply(event, popup);
                }
            }
        }

        public static interface Position {
            public void apply(Event var1, Actor var2);
        }
    }

    public static class TooltipBehavior
    extends Behavior.Adapter {
        private final PopupTask showTask = new PopupTask(){

            public void run() {
                this.popup.show((Event)this.event);
            }
        };
        private final PopupTask hideTask = new PopupTask(){

            public void run() {
                this.popup.hide((Event)this.event);
            }
        };
        private int showEvents = 1 << InputEvent.Type.enter.ordinal();
        private int hideEvents = 1 << InputEvent.Type.touchDown.ordinal() | 1 << InputEvent.Type.touchUp.ordinal() | 1 << InputEvent.Type.exit.ordinal();
        private int cancelEvents = 1 << InputEvent.Type.touchDown.ordinal() | 1 << InputEvent.Type.exit.ordinal();
        private int targetPopupShowEvents = 1 << InputEvent.Type.enter.ordinal() | 1 << InputEvent.Type.exit.ordinal();
        private int targetPopupHideEvents = 1 << InputEvent.Type.mouseMoved.ordinal();
        private int targetPopupCancelEvents;
        private float showDelay = 0.75f;
        private float hideDelay;

        public TooltipBehavior() {
        }

        public TooltipBehavior(float delay) {
            this.setDelay(delay);
        }

        public TooltipBehavior(float showDelay, float hideDelay) {
            this.showDelay = showDelay;
            this.hideDelay = hideDelay;
        }

        public TooltipBehavior(int showEvents) {
            this.showEvents = showEvents;
        }

        public TooltipBehavior(int showEvents, int hideEvents) {
            this.showEvents = showEvents;
            this.hideEvents = hideEvents;
        }

        public TooltipBehavior(int showEvents, int hideEvents, int cancelEvents) {
            this.showEvents = showEvents;
            this.hideEvents = hideEvents;
            this.cancelEvents = cancelEvents;
        }

        @Override
        public Reaction handle(Event e, Popup popup) {
            if (!(e instanceof InputEvent)) {
                return super.handle(e, popup);
            }
            InputEvent event = (InputEvent)e;
            InputEvent.Type type = event.getType();
            int flag = 1 << type.ordinal();
            if (type == InputEvent.Type.keyDown && event.getKeyCode() == 131 && ((this.targetPopupHideEvents & flag) != flag || event.getTarget().getListeners().contains((Object)popup, true))) {
                return Reaction.Hide;
            }
            if (event.getRelatedActor() == popup.getPopup()) {
                return super.handle(e, popup);
            }
            if ((this.cancelEvents & flag) == flag && ((this.targetPopupCancelEvents & flag) != flag || event.getTarget().getListeners().contains((Object)popup, true))) {
                this.showTask.cancel();
            }
            if ((this.hideEvents & flag) == flag && ((this.targetPopupHideEvents & flag) != flag || event.getTarget().getListeners().contains((Object)popup, true))) {
                if (this.hideDelay > 0.0f) {
                    this.hideTask.init(event, popup);
                    if (!this.hideTask.isScheduled()) {
                        Timer.schedule((Timer.Task)this.hideTask, (float)this.hideDelay);
                    }
                } else {
                    return Reaction.Hide;
                }
            }
            if ((this.showEvents & flag) == flag && ((this.targetPopupShowEvents & flag) != flag || event.getTarget().getListeners().contains((Object)popup, true))) {
                if (this.showDelay > 0.0f) {
                    this.showTask.init(event, popup);
                    if (!this.showTask.isScheduled()) {
                        Timer.schedule((Timer.Task)this.showTask, (float)this.showDelay);
                    }
                } else {
                    return Reaction.Show;
                }
            }
            return super.handle(e, popup);
        }

        public int showOn(InputEvent.Type event) {
            return this.showEvents |= 1 << event.ordinal();
        }

        public int showNotOn(InputEvent.Type event) {
            return this.showEvents &= ~(1 << event.ordinal());
        }

        public int hideOn(InputEvent.Type event) {
            return this.hideEvents |= 1 << event.ordinal();
        }

        public int hideNotOn(InputEvent.Type event) {
            return this.hideEvents &= ~(1 << event.ordinal());
        }

        public int cancelOn(InputEvent.Type event) {
            return this.cancelEvents |= 1 << event.ordinal();
        }

        public int cancelNotOn(InputEvent.Type event) {
            return this.cancelEvents &= ~(1 << event.ordinal());
        }

        public void setDelay(float delay) {
            this.showDelay = this.hideDelay = delay;
        }

        public float getShowDelay() {
            return this.showDelay;
        }

        public void setShowDelay(float showDelay) {
            this.showDelay = showDelay;
        }

        public float getHideDelay() {
            return this.hideDelay;
        }

        public void setHideDelay(float hideDelay) {
            this.hideDelay = hideDelay;
        }

        public int getShowEvents() {
            return this.showEvents;
        }

        public void setShowEvents(int showEvents) {
            this.showEvents = showEvents;
        }

        public int getHideEvents() {
            return this.hideEvents;
        }

        public void setHideEvents(int hideEvents) {
            this.hideEvents = hideEvents;
        }

        public int getCancelEvents() {
            return this.cancelEvents;
        }

        public void setCancelEvents(int cancelEvents) {
            this.cancelEvents = cancelEvents;
        }

        public int getTargetPopupShowEvents() {
            return this.targetPopupShowEvents;
        }

        public void setTargetPopupShowEvents(int targetPopupShowEvents) {
            this.targetPopupShowEvents = targetPopupShowEvents;
        }

        public int getTargetPopupHideEvents() {
            return this.targetPopupHideEvents;
        }

        public void setTargetPopupHideEvents(int targetPopupHideEvents) {
            this.targetPopupHideEvents = targetPopupHideEvents;
        }

        public int getTargetPopupCancelEvents() {
            return this.targetPopupCancelEvents;
        }

        public void setTargetPopupCancelEvents(int targetPopupCancelEvents) {
            this.targetPopupCancelEvents = targetPopupCancelEvents;
        }

        public static class TooltipPositionBehavior
        extends PositionBehavior {
            private boolean followPointer;

            public TooltipPositionBehavior(PositionBehavior.Position position) {
                super(position);
            }

            public TooltipPositionBehavior(PositionBehavior.Position position, boolean followPointer) {
                super(position);
                this.followPointer = followPointer;
            }

            @Override
            public Reaction handle(Event event, Popup popup) {
                if (this.followPointer && event instanceof InputEvent && ((InputEvent)event).getType() == InputEvent.Type.mouseMoved) {
                    this.getPosition().apply(event, (Actor)popup.getPopup());
                }
                return super.handle(event, popup);
            }

            public boolean isFollowPointer() {
                return this.followPointer;
            }

            public void setFollowPointer(boolean followPointer) {
                this.followPointer = followPointer;
            }
        }

        private static abstract class PopupTask
        extends Timer.Task {
            protected final InputEvent event = new InputEvent();
            protected Popup popup;

            private PopupTask() {
            }

            public void init(InputEvent event, Popup popup) {
                this.event.reset();
                Scene2DUtils.copy(event, this.event);
                this.popup = popup;
            }
        }
    }

    public static class MenuBehavior
    extends Behavior.Adapter {
        private int showButtons = 1;

        public MenuBehavior() {
        }

        public MenuBehavior(int ... showButtons) {
            for (int button : showButtons) {
                this.showOn(button);
            }
        }

        @Override
        public Reaction handle(Event e, Popup popup) {
            if (!(e instanceof InputEvent)) {
                return Reaction.None;
            }
            InputEvent event = (InputEvent)e;
            switch (event.getType()) {
                case touchDown: {
                    if ((1 << event.getButton() & this.showButtons) == this.showButtons && event.getTarget().getListeners().contains((Object)popup, true)) {
                        return Reaction.ShowHandle;
                    }
                    if (!popup.isAscendantOf(event.getTarget())) {
                        return Reaction.Hide;
                    }
                }
                case keyDown: {
                    if (event.getKeyCode() == 82 && event.getTarget().getListeners().contains((Object)popup, true)) {
                        return Reaction.ShowHandle;
                    }
                    if (event.getKeyCode() != 131 && event.getKeyCode() != 4) break;
                    return Reaction.HideHandle;
                }
            }
            return null;
        }

        public int showOn(int button) {
            return this.showButtons |= 1 << button;
        }

        public int showNotOn(int button) {
            return this.showButtons &= ~(1 << button);
        }

        public int getShowButtons() {
            return this.showButtons;
        }

        public void setShowButtons(int showButtons) {
            this.showButtons = showButtons;
        }
    }

    public static class FadeBehavior
    extends Behavior.Adapter {
        private float fadeInDuration = 0.4f;
        private float fadeOutDuration = 0.4f;
        private Interpolation fadeInInterpolation = Interpolation.fade;
        private Interpolation fadeOutInterpolation = Interpolation.fade;

        public FadeBehavior() {
        }

        public FadeBehavior(float fadeDuration) {
            this(fadeDuration, fadeDuration);
        }

        public FadeBehavior(Interpolation fadeInterpolation) {
            this(fadeInterpolation, fadeInterpolation);
        }

        public FadeBehavior(float fadeDuration, Interpolation fadeInterpolation) {
            this(fadeDuration, fadeDuration, fadeInterpolation, fadeInterpolation);
        }

        public FadeBehavior(float fadeInDuration, float fadeOutDuration) {
            this.fadeInDuration = fadeInDuration;
            this.fadeOutDuration = fadeOutDuration;
        }

        public FadeBehavior(Interpolation fadeInInterpolation, Interpolation fadeOutInterpolation) {
            this.fadeInInterpolation = fadeInInterpolation;
            this.fadeOutInterpolation = fadeOutInterpolation;
        }

        public FadeBehavior(float fadeInDuration, float fadeOutDuration, Interpolation fadeInInterpolation, Interpolation fadeOutInterpolation) {
            this.fadeInDuration = fadeInDuration;
            this.fadeOutDuration = fadeOutDuration;
            this.fadeInInterpolation = fadeInInterpolation;
            this.fadeOutInterpolation = fadeOutInterpolation;
        }

        @Override
        public boolean show(Event event, Popup popup) {
            popup.getPopup().toFront();
            popup.getPopup().addAction((Action)Actions.sequence((Action)Actions.visible((boolean)true), (Action)Actions.fadeIn((float)this.fadeInDuration, (Interpolation)this.fadeInInterpolation)));
            return super.show(event, popup);
        }

        @Override
        public boolean hide(Event event, Popup popup) {
            popup.getPopup().addAction((Action)Actions.sequence((Action)Actions.fadeOut((float)this.fadeOutDuration, (Interpolation)this.fadeOutInterpolation), (Action)Actions.visible((boolean)false)));
            return super.hide(event, popup);
        }

        public float getFadeInDuration() {
            return this.fadeInDuration;
        }

        public void setFadeInDuration(float fadeInDuration) {
            this.fadeInDuration = fadeInDuration;
        }

        public float getFadeOutDuration() {
            return this.fadeOutDuration;
        }

        public void setFadeOutDuration(float fadeOutDuration) {
            this.fadeOutDuration = fadeOutDuration;
        }

        public Interpolation getFadeInInterpolation() {
            return this.fadeInInterpolation;
        }

        public void setFadeInInterpolation(Interpolation fadeInInterpolation) {
            this.fadeInInterpolation = fadeInInterpolation;
        }

        public Interpolation getFadeOutInterpolation() {
            return this.fadeOutInterpolation;
        }

        public void setFadeOutInterpolation(Interpolation fadeOutInterpolation) {
            this.fadeOutInterpolation = fadeOutInterpolation;
        }
    }

    public static class VisibilityBehavior
    extends Behavior.Adapter {
        @Override
        public boolean show(Event event, Popup popup) {
            popup.getPopup().setVisible(true);
            popup.getPopup().toFront();
            return true;
        }

        @Override
        public boolean hide(Event event, Popup popup) {
            popup.getPopup().setVisible(false);
            return false;
        }
    }

    public static class AddToStageBehavior
    extends Behavior.Adapter {
        @Override
        public boolean show(Event event, Popup popup) {
            if (popup.getPopup().getStage() != event.getStage()) {
                event.getStage().addActor(popup.getPopup());
            }
            return super.show(event, popup);
        }
    }

    public static class BehaviorMultiplexer
    extends Multiplexer<Behavior>
    implements Behavior {
        public BehaviorMultiplexer() {
        }

        public BehaviorMultiplexer(int size) {
            super(size);
        }

        public BehaviorMultiplexer(Behavior ... receivers) {
            super(receivers);
        }

        public BehaviorMultiplexer(Array<Behavior> receivers) {
            super(receivers);
        }

        @Override
        public boolean show(Event event, Popup popup) {
            boolean handled = false;
            for (Behavior behavior : this.receivers) {
                handled |= behavior.show(event, popup);
            }
            return handled;
        }

        @Override
        public boolean hide(Event event, Popup popup) {
            boolean handled = false;
            for (Behavior behavior : this.receivers) {
                handled |= behavior.hide(event, popup);
            }
            return handled;
        }

        @Override
        public Reaction handle(Event event, Popup popup) {
            Enum reaction = null;
            boolean handled = false;
            for (int i = 0; i < this.receivers.size - 1; ++i) {
                Reaction itsReaction = ((Behavior)this.receivers.get(i)).handle(event, popup);
                if (reaction == null) {
                    reaction = itsReaction;
                }
                if (handled || itsReaction == null || !itsReaction.handles) continue;
                handled = true;
            }
            if (handled && !((Reaction)reaction).handles) {
                switch (1.$SwitchMap$net$dermetfan$gdx$scenes$scene2d$ui$Popup$Reaction[reaction.ordinal()]) {
                    case 2: {
                        return Reaction.ShowHandle;
                    }
                    case 4: {
                        return Reaction.HideHandle;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                    case 5: 
                }
                return Reaction.Handle;
            }
            return reaction;
        }
    }

    public static interface Behavior {
        public boolean show(Event var1, Popup var2);

        public boolean hide(Event var1, Popup var2);

        public Reaction handle(Event var1, Popup var2);

        public static class Adapter
        implements Behavior {
            @Override
            public boolean show(Event event, Popup popup) {
                return false;
            }

            @Override
            public boolean hide(Event event, Popup popup) {
                return false;
            }

            @Override
            public Reaction handle(Event event, Popup popup) {
                return null;
            }
        }
    }

    public static enum Reaction {
        Show(false),
        Hide(false),
        None(false),
        ShowHandle(true),
        HideHandle(true),
        Handle(true);

        public final boolean handles;

        private Reaction(boolean handles) {
            this.handles = handles;
        }
    }
}

