/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Pools;
import java.io.File;
import java.io.FileFilter;
import net.dermetfan.gdx.scenes.scene2d.ui.FileChooser;
import net.dermetfan.gdx.scenes.scene2d.ui.UIUtils;
import net.dermetfan.utils.Function;

public class TreeFileChooser
extends FileChooser {
    private Style style;
    private Tree tree;
    private ScrollPane treePane;
    private Button chooseButton;
    private Button cancelButton;
    public final ClickListener treeListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            FileHandle file;
            Object lastObj;
            Selection selection = TreeFileChooser.this.tree.getSelection();
            if (selection.size() < 1) {
                TreeFileChooser.this.chooseButton.setDisabled(true);
                return;
            }
            if (!TreeFileChooser.this.isDirectoriesChoosable() && (lastObj = ((Tree.Node)selection.getLastSelected()).getObject()) instanceof FileHandle && (file = (FileHandle)lastObj).isDirectory()) {
                TreeFileChooser.this.chooseButton.setDisabled(true);
                return;
            }
            TreeFileChooser.this.chooseButton.setDisabled(false);
        }
    };
    public final ClickListener chooseButtonListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            if (TreeFileChooser.this.chooseButton.isDisabled()) {
                return;
            }
            Selection selection = TreeFileChooser.this.tree.getSelection();
            if (selection.size() < 1) {
                return;
            }
            if (selection.getMultiple() && selection.size() > 1) {
                Array files = (Array)Pools.obtain(Array.class);
                for (Tree.Node node : selection) {
                    Object object = node.getObject();
                    if (!(object instanceof FileHandle)) continue;
                    FileHandle file = (FileHandle)object;
                    if (!TreeFileChooser.this.isDirectoriesChoosable() && file.isDirectory()) continue;
                    files.add((Object)file);
                }
                TreeFileChooser.this.getListener().choose((Array<FileHandle>)files);
                files.clear();
                Pools.free((Object)files);
            } else {
                Object object = ((Tree.Node)selection.getLastSelected()).getObject();
                if (object instanceof FileHandle) {
                    FileHandle file = (FileHandle)object;
                    if (TreeFileChooser.this.isDirectoriesChoosable() || !file.isDirectory()) {
                        TreeFileChooser.this.getListener().choose(file);
                    }
                }
            }
        }
    };
    public final ClickListener cancelButtonListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            TreeFileChooser.this.getListener().cancel();
        }
    };

    public static Tree.Node fileNode(FileHandle file, Label.LabelStyle labelStyle) {
        return TreeFileChooser.fileNode(file, labelStyle, null);
    }

    public static Tree.Node fileNode(FileHandle file, Label.LabelStyle labelStyle, Function<Void, Tree.Node> nodeConsumer) {
        return TreeFileChooser.fileNode(file, null, labelStyle, nodeConsumer);
    }

    public static Tree.Node fileNode(FileHandle file, FileFilter filter, Label.LabelStyle labelStyle) {
        return TreeFileChooser.fileNode(file, filter, labelStyle, null);
    }

    public static Tree.Node fileNode(FileHandle file, FileFilter filter, final Label.LabelStyle labelStyle, Function<Void, Tree.Node> nodeConsumer) {
        return TreeFileChooser.fileNode(file, filter, new Function<Label, FileHandle>(){

            @Override
            public Label apply(FileHandle file) {
                String name = file.name();
                if (name.length() == 0) {
                    name = file.path();
                    name = name.substring(0, name.lastIndexOf(47));
                }
                if (file.isDirectory()) {
                    name = name + File.separatorChar;
                }
                return new Label((CharSequence)name, labelStyle);
            }
        }, nodeConsumer);
    }

    public static Tree.Node fileNode(FileHandle file, FileFilter filter, Function<Label, FileHandle> labelSupplier) {
        return TreeFileChooser.fileNode(file, filter, labelSupplier, null);
    }

    public static Tree.Node fileNode(final FileHandle file, final FileFilter filter, final Function<Label, FileHandle> labelSupplier, final Function<Void, Tree.Node> nodeConsumer) {
        Tree.Node node;
        Label label = labelSupplier.apply(file);
        if (file.isDirectory()) {
            final Tree.Node dummy = new Tree.Node(new Actor());
            node = new Tree.Node((Actor)label){
                private boolean childrenAdded;

                public void setExpanded(boolean expanded) {
                    if (expanded == this.isExpanded()) {
                        return;
                    }
                    if (expanded && !this.childrenAdded) {
                        if (filter != null) {
                            for (FileHandle child : file.list(filter)) {
                                this.add(TreeFileChooser.fileNode(file.child(child.name()), filter, labelSupplier, (Function<Void, Tree.Node>)nodeConsumer));
                            }
                        } else {
                            for (FileHandle child : file.list()) {
                                this.add(TreeFileChooser.fileNode(child, filter, labelSupplier, (Function<Void, Tree.Node>)nodeConsumer));
                            }
                        }
                        this.childrenAdded = true;
                        this.remove(dummy);
                    }
                    super.setExpanded(expanded);
                }
            };
            node.add(dummy);
            if (nodeConsumer != null) {
                nodeConsumer.apply(dummy);
            }
        } else {
            node = new Tree.Node((Actor)label);
        }
        node.setObject((Object)file);
        if (nodeConsumer != null) {
            nodeConsumer.apply(node);
        }
        return node;
    }

    public TreeFileChooser(Skin skin, FileChooser.Listener listener) {
        this((Style)skin.get(Style.class), listener);
        this.setSkin(skin);
    }

    public TreeFileChooser(Skin skin, String styleName, FileChooser.Listener listener) {
        this((Style)skin.get(styleName, Style.class), listener);
        this.setSkin(skin);
    }

    public TreeFileChooser(Style style, FileChooser.Listener listener) {
        super(listener);
        this.style = style;
        this.buildWidgets();
        this.build();
    }

    public Tree.Node add(FileHandle file) {
        Tree.Node node = TreeFileChooser.fileNode(file, this.handlingFileFilter, this.style.labelStyle);
        this.tree.add(node);
        return node;
    }

    protected void buildWidgets() {
        this.tree = new Tree(this.style.treeStyle);
        this.tree.addListener((EventListener)this.treeListener);
        this.treePane = this.style.scrollPaneStyle != null ? new ScrollPane((Actor)this.tree, this.style.scrollPaneStyle) : new ScrollPane((Actor)this.tree);
        this.chooseButton = UIUtils.newButton(this.style.selectButtonStyle, "select");
        this.chooseButton.addListener((EventListener)this.chooseButtonListener);
        this.chooseButton.setDisabled(true);
        this.cancelButton = UIUtils.newButton(this.style.cancelButtonStyle, "cancel");
        this.cancelButton.addListener((EventListener)this.cancelButtonListener);
    }

    @Override
    protected void build() {
        this.clearChildren();
        this.treePane.setWidget((Actor)this.tree);
        this.add((Actor)this.treePane).colspan(2).row();
        this.add((Actor)this.chooseButton).fill();
        this.add((Actor)this.cancelButton).fill();
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.setBackground(style.background);
        this.tree.setStyle(style.treeStyle);
        this.chooseButton.setStyle(style.selectButtonStyle);
        this.cancelButton.setStyle(style.cancelButtonStyle);
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree.removeListener((EventListener)this.treeListener);
        this.tree = tree;
        this.tree.addListener((EventListener)this.treeListener);
        this.treePane.setWidget((Actor)tree);
    }

    public ScrollPane getTreePane() {
        return this.treePane;
    }

    public void setTreePane(ScrollPane treePane) {
        treePane.setWidget((Actor)this.tree);
        this.treePane = treePane;
        this.getCell((Actor)this.treePane).setActor((Actor)this.treePane);
    }

    public Button getChooseButton() {
        return this.chooseButton;
    }

    public void setChooseButton(Button chooseButton) {
        this.chooseButton.removeListener((EventListener)this.chooseButtonListener);
        chooseButton.addListener((EventListener)this.chooseButtonListener);
        this.chooseButton = chooseButton;
        this.getCell((Actor)this.chooseButton).setActor((Actor)this.chooseButton);
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(Button cancelButton) {
        this.cancelButton.removeListener((EventListener)this.cancelButtonListener);
        cancelButton.addListener((EventListener)this.cancelButtonListener);
        this.cancelButton = cancelButton;
        this.getCell((Actor)this.cancelButton).setActor((Actor)this.cancelButton);
    }

    public static class Style
    implements Json.Serializable {
        public Tree.TreeStyle treeStyle;
        public ScrollPane.ScrollPaneStyle scrollPaneStyle;
        public Label.LabelStyle labelStyle;
        public Button.ButtonStyle selectButtonStyle;
        public Button.ButtonStyle cancelButtonStyle;
        public Drawable background;

        public void write(Json json) {
            json.writeObjectStart("");
            json.writeFields((Object)this);
            json.writeObjectEnd();
        }

        public void read(Json json, JsonValue jsonData) {
            this.treeStyle = (Tree.TreeStyle)json.readValue("treeStyle", Tree.TreeStyle.class, jsonData);
            if (jsonData.has("scrollPaneStyle")) {
                this.scrollPaneStyle = (ScrollPane.ScrollPaneStyle)json.readValue("scrollPaneStyle", ScrollPane.ScrollPaneStyle.class, jsonData);
            }
            this.labelStyle = (Label.LabelStyle)json.readValue("labelStyle", Label.LabelStyle.class, jsonData);
            this.selectButtonStyle = UIUtils.readButtonStyle("selectButtonStyle", json, jsonData);
            this.cancelButtonStyle = UIUtils.readButtonStyle("cancelButtonStyle", json, jsonData);
            if (jsonData.has("background")) {
                this.background = (Drawable)json.readValue("background", Drawable.class, jsonData);
            }
        }
    }
}

