/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import net.dermetfan.utils.math.GeometryUtils;

public class PolygonRegionDrawable
extends BaseDrawable
implements TransformDrawable {
    private PolygonRegion region;
    private float polygonX;
    private float polygonY;
    private float polygonWidth;
    private float polygonHeight;

    public PolygonRegionDrawable() {
    }

    public PolygonRegionDrawable(PolygonRegion region) {
        this.setRegion(region);
    }

    public PolygonRegionDrawable(PolygonRegionDrawable drawable) {
        super((Drawable)drawable);
        this.region = drawable.region;
        this.polygonX = drawable.polygonX;
        this.polygonY = drawable.polygonY;
        this.polygonWidth = drawable.polygonWidth;
        this.polygonHeight = drawable.polygonHeight;
    }

    public void draw(Batch batch, float x, float y, float width, float height) {
        width += (float)this.region.getRegion().getRegionWidth() - this.polygonWidth;
        height += (float)this.region.getRegion().getRegionHeight() - this.polygonHeight;
        if (batch instanceof PolygonSpriteBatch) {
            ((PolygonSpriteBatch)batch).draw(this.region, x - this.polygonX, y - this.polygonY, width, height);
        } else {
            batch.draw(this.region.getRegion(), x, y, width, height);
        }
    }

    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        width += (float)this.region.getRegion().getRegionWidth() - this.polygonWidth;
        height += (float)this.region.getRegion().getRegionHeight() - this.polygonHeight;
        if (batch instanceof PolygonSpriteBatch) {
            ((PolygonSpriteBatch)batch).draw(this.region, x - this.polygonX, y - this.polygonY, originX, originY, width, height, scaleX, scaleY, rotation);
        } else {
            batch.draw(this.region.getRegion(), x, y, originX, originY, width, height, scaleX, scaleY, rotation);
        }
    }

    public void setRegion(PolygonRegion region) {
        this.region = region;
        float[] vertices = region.getVertices();
        this.polygonWidth = GeometryUtils.width(vertices);
        this.polygonHeight = GeometryUtils.height(vertices);
        this.polygonX = GeometryUtils.minX(vertices);
        this.polygonY = GeometryUtils.minY(vertices);
        this.setMinWidth(this.polygonWidth);
        this.setMinHeight(this.polygonHeight);
    }

    public PolygonRegion getRegion() {
        return this.region;
    }

    public float getPolygonX() {
        return this.polygonX;
    }

    public float getPolygonY() {
        return this.polygonY;
    }

    public float getPolygonWidth() {
        return this.polygonWidth;
    }

    public float getPolygonHeight() {
        return this.polygonHeight;
    }
}

