/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;

public class ArrayUtils
extends net.dermetfan.utils.ArrayUtils {
    public static <T> T getRepeated(Array<T> array, int index) {
        return (T)array.get(ArrayUtils.repeat(array.size, index));
    }

    public static <T> Array<T> select(Array<T> items, int offset, int length, int start, int everyXth, Array<T> dest) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        if (dest == null) {
            dest = new Array(outputLength);
        }
        dest.clear();
        dest.ensureCapacity(outputLength);
        if (start + length > items.size) {
            throw new ArrayIndexOutOfBoundsException(start + length - 1);
        }
        dest.size = outputLength;
        ArrayUtils.select(items.items, offset, length, start, everyXth, dest.items);
        return dest;
    }

    public static <T> Array<T> select(Array<T> items, int start, int everyXth, Array<T> dest) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth, dest);
    }

    public static <T> Array<T> select(Array<T> items, int everyXth, Array<T> dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static <T> Array<T> select(Array<T> items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, null);
    }

    public static <T> Array<T> select(Array<T> items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth);
    }

    public static <T> Array<T> select(Array<T> items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static <T> Array<T> select(Array<T> items, int[] indices, int indicesOffset, int indicesLength, Array<T> dest) {
        if (dest == null) {
            dest = new Array(true, indicesLength, items.items.getClass().getComponentType());
        }
        dest.clear();
        dest.ensureCapacity(indicesLength);
        if (indicesLength > items.size) {
            throw new ArrayIndexOutOfBoundsException(indicesLength - 1);
        }
        dest.size = indicesLength;
        ArrayUtils.select(items.items, indices, indicesOffset, indicesLength, dest.items, 0);
        return dest;
    }

    public static <T> Array<T> select(Array<T> items, int[] indices, Array<T> dest) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest);
    }

    public static <T> Array<T> select(Array<T> items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static <T> Array<T> select(Array<T> items, IntArray indices, Array<T> dest) {
        return ArrayUtils.select(items, indices.items, 0, indices.size, dest);
    }

    public static <T> Array<T> select(Array<T> items, IntArray indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static <T> Array<T> skipselect(Array<T> elements, IntArray skips, IntArray repeatSkips, Array<T> output) {
        int length;
        boolean repeat;
        boolean normal = skips != null && skips.size > 0;
        boolean bl = repeat = repeatSkips != null && repeatSkips.size > 0;
        if (!normal && !repeat) {
            return elements;
        }
        int span = 0;
        int rsi = 0;
        for (length = 0; length < elements.size; ++length) {
            int skip;
            int n = normal && length < skips.size ? skips.get(length) : (repeat ? repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++) : (skip = Integer.MAX_VALUE - span - 1));
            if (span + skip + 1 > elements.size) break;
            span += skip + 1;
        }
        if (length == elements.size) {
            return elements;
        }
        if (output == null) {
            output = new Array(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        rsi = 0;
        int si = 0;
        int ei = 0;
        while (si < length) {
            output.add(elements.get(ei++));
            if (++si >= skips.size) {
                if (!repeat) break;
                ei += repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++);
                continue;
            }
            ei += skips.get(si);
        }
        return output;
    }

    public static <T> Array<T> skipselect(Array<T> elements, IntArray skips, IntArray repeatSkips) {
        return ArrayUtils.skipselect(elements, skips, repeatSkips, null);
    }

    public static <T> Array<T> skipselect(Array<T> elements, int firstSkip, int skips, Array<T> output) {
        int length;
        int span = firstSkip;
        for (length = 0; length < elements.size; ++length) {
            if (span + skips + 1 <= elements.size) {
                span += skips + 1;
                continue;
            }
            ++length;
            break;
        }
        if (output == null) {
            output = new Array(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        int si = 0;
        int ei = firstSkip;
        while (si < length) {
            output.add(elements.get(ei));
            ++si;
            ei += skips + 1;
        }
        return output;
    }

    public static <T> Array<T> skipselect(Array<T> elements, int firstSkip, int skips) {
        return ArrayUtils.skipselect(elements, firstSkip, skips, null);
    }

    public static <T> boolean equalsAny(T obj, Array<T> array) {
        return ArrayUtils.equalsAny(obj, array.items, 0, array.size);
    }

    public static int getRepeated(IntArray array, int index) {
        return array.get(ArrayUtils.repeat(array.size, index));
    }

    public static IntArray select(IntArray items, int offset, int length, int start, int everyXth, IntArray dest) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        if (dest == null) {
            dest = new IntArray(outputLength);
        }
        dest.clear();
        dest.ensureCapacity(outputLength);
        if (start + length > items.size) {
            throw new ArrayIndexOutOfBoundsException(start + length - 1);
        }
        dest.size = outputLength;
        ArrayUtils.select(items.items, offset, length, start, everyXth, dest.items);
        return dest;
    }

    public static IntArray select(IntArray items, int start, int everyXth, IntArray dest) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth, dest);
    }

    public static IntArray select(IntArray items, int everyXth, IntArray dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static IntArray select(IntArray items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, null);
    }

    public static IntArray select(IntArray items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth);
    }

    public static IntArray select(IntArray items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static IntArray select(IntArray items, int[] indices, int indicesOffset, int indicesLength, IntArray dest) {
        if (dest == null) {
            dest = new IntArray(true, indicesLength);
        }
        dest.clear();
        dest.ensureCapacity(indicesLength);
        if (indicesLength > items.size) {
            throw new ArrayIndexOutOfBoundsException(indicesLength - 1);
        }
        dest.size = indicesLength;
        ArrayUtils.select(items.items, indices, indicesOffset, indicesLength, dest.items, 0);
        return dest;
    }

    public static IntArray select(IntArray items, int[] indices, IntArray dest) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest);
    }

    public static IntArray select(IntArray items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static IntArray select(IntArray items, IntArray indices, IntArray dest) {
        return ArrayUtils.select(items, indices.items, 0, indices.size, dest);
    }

    public static IntArray select(IntArray items, IntArray indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static IntArray skipselect(IntArray elements, IntArray skips, IntArray repeatSkips, IntArray output) {
        int length;
        boolean repeat;
        boolean normal = skips != null && skips.size > 0;
        boolean bl = repeat = repeatSkips != null && repeatSkips.size > 0;
        if (!normal && !repeat) {
            return elements;
        }
        int span = 0;
        int rsi = 0;
        for (length = 0; length < elements.size; ++length) {
            int skip;
            int n = normal && length < skips.size ? skips.get(length) : (repeat ? repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++) : (skip = Integer.MAX_VALUE - span - 1));
            if (span + skip + 1 > elements.size) break;
            span += skip + 1;
        }
        if (length == elements.size) {
            return elements;
        }
        if (output == null) {
            output = new IntArray(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        rsi = 0;
        int si = 0;
        int ei = 0;
        while (si < length) {
            output.add(elements.get(ei++));
            if (++si >= skips.size) {
                if (!repeat) break;
                ei += repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++);
                continue;
            }
            ei += skips.get(si);
        }
        return output;
    }

    public static IntArray skipselect(IntArray elements, IntArray skips, IntArray repeatSkips) {
        return ArrayUtils.skipselect(elements, skips, repeatSkips, null);
    }

    public static IntArray skipselect(IntArray elements, int firstSkip, int skips, IntArray output) {
        int length;
        int span = firstSkip;
        for (length = 0; length < elements.size; ++length) {
            if (span + skips + 1 <= elements.size) {
                span += skips + 1;
                continue;
            }
            ++length;
            break;
        }
        if (output == null) {
            output = new IntArray(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        int si = 0;
        int ei = firstSkip;
        while (si < length) {
            output.add(elements.get(ei));
            ++si;
            ei += skips + 1;
        }
        return output;
    }

    public static IntArray skipselect(IntArray elements, int firstSkip, int skips) {
        return ArrayUtils.skipselect(elements, firstSkip, skips, null);
    }

    public static float getRepeated(FloatArray array, int index) {
        return array.get(ArrayUtils.repeat(array.size, index));
    }

    public static FloatArray select(FloatArray items, int offset, int length, int start, int everyXth, FloatArray dest) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        if (dest == null) {
            dest = new FloatArray(outputLength);
        }
        dest.clear();
        dest.ensureCapacity(outputLength);
        if (start + length > items.size) {
            throw new ArrayIndexOutOfBoundsException(start + length - 1);
        }
        dest.size = outputLength;
        ArrayUtils.select(items.items, offset, length, start, everyXth, dest.items);
        return dest;
    }

    public static FloatArray select(FloatArray items, int start, int everyXth, FloatArray dest) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth, dest);
    }

    public static FloatArray select(FloatArray items, int everyXth, FloatArray dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static FloatArray select(FloatArray items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, null);
    }

    public static FloatArray select(FloatArray items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.size, start, everyXth);
    }

    public static FloatArray select(FloatArray items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static FloatArray select(FloatArray items, int[] indices, int indicesOffset, int indicesLength, FloatArray dest) {
        if (dest == null) {
            dest = new FloatArray(true, indicesLength);
        }
        dest.clear();
        dest.ensureCapacity(indicesLength);
        if (indicesLength > items.size) {
            throw new ArrayIndexOutOfBoundsException(indicesLength - 1);
        }
        dest.size = indicesLength;
        ArrayUtils.select(items.items, indices, indicesOffset, indicesLength, dest.items, 0);
        return dest;
    }

    public static FloatArray select(FloatArray items, int[] indices, FloatArray dest) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest);
    }

    public static FloatArray select(FloatArray items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static FloatArray select(FloatArray items, IntArray indices, FloatArray dest) {
        return ArrayUtils.select(items, indices.items, 0, indices.size, dest);
    }

    public static FloatArray select(FloatArray items, IntArray indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static FloatArray skipselect(FloatArray elements, IntArray skips, IntArray repeatSkips, FloatArray output) {
        int length;
        boolean repeat;
        boolean normal = skips != null && skips.size > 0;
        boolean bl = repeat = repeatSkips != null && repeatSkips.size > 0;
        if (!normal && !repeat) {
            return elements;
        }
        int span = 0;
        int rsi = 0;
        for (length = 0; length < elements.size; ++length) {
            int skip;
            int n = normal && length < skips.size ? skips.get(length) : (repeat ? repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++) : (skip = Integer.MAX_VALUE - span - 1));
            if (span + skip + 1 > elements.size) break;
            span += skip + 1;
        }
        if (length == elements.size) {
            return elements;
        }
        if (output == null) {
            output = new FloatArray(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        rsi = 0;
        int si = 0;
        int ei = 0;
        while (si < length) {
            output.add(elements.get(ei++));
            if (++si >= skips.size) {
                if (!repeat) break;
                ei += repeatSkips.get(rsi >= repeatSkips.size ? (rsi = 0) : rsi++);
                continue;
            }
            ei += skips.get(si);
        }
        return output;
    }

    public static FloatArray skipselect(FloatArray elements, IntArray skips, IntArray repeatSkips) {
        return ArrayUtils.skipselect(elements, skips, repeatSkips, null);
    }

    public static FloatArray skipselect(FloatArray elements, int firstSkip, int skips, FloatArray output) {
        int length;
        int span = firstSkip;
        for (length = 0; length < elements.size; ++length) {
            if (span + skips + 1 <= elements.size) {
                span += skips + 1;
                continue;
            }
            ++length;
            break;
        }
        if (output == null) {
            output = new FloatArray(length);
        }
        output.clear();
        output.ensureCapacity(length - output.size);
        int si = 0;
        int ei = firstSkip;
        while (si < length) {
            output.add(elements.get(ei));
            ++si;
            ei += skips + 1;
        }
        return output;
    }

    public static FloatArray skipselect(FloatArray elements, int firstSkip, int skips) {
        return ArrayUtils.skipselect(elements, firstSkip, skips, null);
    }
}

