/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.utils;

import com.badlogic.gdx.utils.ObjectMap;

public class DualObjectMap<K, V> {
    private final ObjectMap<K, V> keyToValue;
    private final ObjectMap<V, K> valueToKey;

    public DualObjectMap() {
        this.keyToValue = new ObjectMap();
        this.valueToKey = new ObjectMap();
    }

    public DualObjectMap(int initialCapacity) {
        this.keyToValue = new ObjectMap(initialCapacity);
        this.valueToKey = new ObjectMap(initialCapacity);
    }

    public DualObjectMap(int initialCapacity, float loadFactor) {
        this.keyToValue = new ObjectMap(initialCapacity, loadFactor);
        this.valueToKey = new ObjectMap(initialCapacity, loadFactor);
    }

    public DualObjectMap(ObjectMap<K, V> map) {
        this.keyToValue = new ObjectMap(map);
        this.valueToKey = new ObjectMap(map.size);
        for (Object key : map.keys()) {
            this.valueToKey.put(map.get(key), key);
        }
    }

    public DualObjectMap(DualObjectMap<K, V> map) {
        this.keyToValue = new ObjectMap(map.keyToValue);
        this.valueToKey = new ObjectMap(map.valueToKey);
    }

    public void put(K key, V value) {
        this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
    }

    public K getKey(V value) {
        Object key = this.valueToKey.get(value);
        assert (key != null);
        return (K)key;
    }

    public V getValue(K key) {
        Object value = this.keyToValue.get(key);
        assert (value != null);
        return (V)value;
    }

    public V removeKey(K key) {
        Object value = this.keyToValue.remove(key);
        assert (value != null);
        Object removed = this.valueToKey.remove(value);
        assert (removed != null);
        return (V)value;
    }

    public K removeValue(V value) {
        Object key = this.valueToKey.remove(value);
        assert (key != null);
        Object oldObject = this.keyToValue.remove(key);
        assert (oldObject != null);
        return (K)key;
    }

    public ObjectMap<K, V> getKeyToValue() {
        return this.keyToValue;
    }

    public ObjectMap<V, K> getValueToKey() {
        return this.valueToKey;
    }
}

