/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.utils;

import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.PooledLinkedList;

public class IntArrayPool {
    private final IntMap<PooledLinkedList<int[]>> lists;
    private final Pool<PooledLinkedList<int[]>> listPool;
    public final int max;
    public final int maxEach;

    public IntArrayPool(int max, final int maxEach) {
        this.max = max;
        this.maxEach = maxEach;
        this.lists = new IntMap(max < 0 ? 10 : max, 1.0f);
        this.listPool = new Pool<PooledLinkedList<int[]>>(){

            protected PooledLinkedList<int[]> newObject() {
                return new PooledLinkedList(maxEach);
            }
        };
    }

    public int[] obtain(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("negative array length: " + length);
        }
        PooledLinkedList list = (PooledLinkedList)this.lists.get(length);
        if (list == null) {
            return new int[length];
        }
        list.iterReverse();
        int[] array = (int[])list.previous();
        list.remove();
        if (list.previous() == null) {
            this.lists.remove(length);
            this.listPool.free((Object)list);
        }
        return array;
    }

    public void free(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array cannot be null");
        }
        PooledLinkedList list = (PooledLinkedList)this.lists.get(array.length);
        if (list == null && this.lists.size < this.max) {
            list = (PooledLinkedList)this.listPool.obtain();
            this.lists.put(array.length, (Object)list);
        }
        if (list != null && this.size(list) < this.maxEach) {
            list.add((Object)array);
        }
    }

    public void clear() {
        for (PooledLinkedList list : this.lists.values()) {
            list.clear();
        }
        this.lists.clear();
    }

    public int getFree(int length) {
        PooledLinkedList list = (PooledLinkedList)this.lists.get(length);
        return list == null ? 0 : this.size(list);
    }

    private int size(PooledLinkedList list) {
        int size = 0;
        list.iter();
        while (list.next() != null) {
            ++size;
        }
        return size;
    }
}

