/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils;

import net.dermetfan.utils.math.MathUtils;

public class ArrayUtils {
    public static String toString(Object[] array) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1);
    }

    public static String toString(Object[] array, String separator) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1, separator);
    }

    public static String toString(Object[] array, int offset, int length) {
        return ArrayUtils.toString(array, offset, length, ", ");
    }

    public static String toString(Object[] array, int offset, int length, String separator) {
        if (array == null) {
            return "null";
        }
        ArrayUtils.checkRegion(array, offset, length);
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder s = new StringBuilder(2 + (array.length - 1) * separator.length());
        s.append('[');
        int i = offset;
        while (i < offset + length) {
            s.append(String.valueOf(array[i]));
            if (++i >= offset + length) continue;
            s.append(separator);
        }
        return s.append(']').toString();
    }

    public static String toString(int[] array) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1);
    }

    public static String toString(int[] array, String separator) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1, separator);
    }

    public static String toString(int[] array, int offset, int length) {
        return ArrayUtils.toString(array, offset, length, ", ");
    }

    public static String toString(int[] array, int offset, int length, String separator) {
        if (array == null) {
            return "null";
        }
        ArrayUtils.checkRegion(array, offset, length);
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder s = new StringBuilder(2 + (array.length - 1) * separator.length());
        s.append('[');
        int i = offset;
        while (i < offset + length) {
            s.append(array[i]);
            if (++i >= offset + length) continue;
            s.append(separator);
        }
        return s.append(']').toString();
    }

    public static String toString(float[] array) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1);
    }

    public static String toString(float[] array, String separator) {
        return ArrayUtils.toString(array, 0, array != null ? array.length : -1, separator);
    }

    public static String toString(float[] array, int offset, int length) {
        return ArrayUtils.toString(array, offset, length, ", ");
    }

    public static String toString(float[] array, int offset, int length, String separator) {
        if (array == null) {
            return "null";
        }
        ArrayUtils.checkRegion(array, offset, length);
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder s = new StringBuilder(2 + (array.length - 1) * separator.length());
        s.append('[');
        int i = offset;
        while (i < offset + length) {
            s.append(array[i]);
            if (++i >= offset + length) continue;
            s.append(separator);
        }
        return s.append(']').toString();
    }

    public static <T> T getRepeated(T[] array, int index) {
        return array[ArrayUtils.repeat(array.length, index)];
    }

    public static int getRepeated(int[] array, int index) {
        return array[ArrayUtils.repeat(array.length, index)];
    }

    public static float getRepeated(float[] array, int index) {
        return array[ArrayUtils.repeat(array.length, index)];
    }

    public static int repeat(int length, int index) {
        return ArrayUtils.repeat(0, length, index);
    }

    public static int repeat(int offset, int length, int index) {
        return MathUtils.normalize(index, offset, offset + length, false, true);
    }

    public static <T> boolean contains(T[] array, T value, boolean identity) {
        int i = array.length - 1;
        if (identity) {
            while (i >= 0) {
                if (array[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!array[i--].equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T, T2 extends T> boolean contains(T[] array, T2[] other, boolean identity) {
        for (T2 value : other) {
            if (ArrayUtils.contains(array, value, identity)) continue;
            return false;
        }
        return true;
    }

    public static <T, T2 extends T> boolean containsAny(T[] array, T2[] other, boolean identity) {
        for (T2 value : other) {
            if (!ArrayUtils.contains(array, value, identity)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(Object obj, Object[] array, int offset, int length) {
        for (int i = offset + length - 1; i >= offset; --i) {
            if (!obj.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(Object obj, Object[] array) {
        return ArrayUtils.equalsAny(obj, array, 0, array.length);
    }

    public static void shift(Object[] array, int shift) {
        ArrayUtils.shift(array, 0, array.length, shift);
    }

    public static void shift(Object[] array, int offset, int length, int shift) {
        ArrayUtils.checkRegion(array, offset, length);
        if (shift == 0) {
            return;
        }
        ArrayUtils.shift(array, offset, length, shift, offset);
    }

    private static void shift(Object[] array, int offset, int length, int shift, int i) {
        if (i == offset + length) {
            return;
        }
        Object newItem = array[ArrayUtils.repeat(offset, length, i - shift)];
        ArrayUtils.shift(array, offset, length, shift, i + 1);
        array[i] = newItem;
    }

    public static void shift(int[] array, int shift) {
        ArrayUtils.shift(array, 0, array.length, shift);
    }

    public static void shift(int[] array, int offset, int length, int shift) {
        ArrayUtils.checkRegion(array, offset, length);
        if (shift == 0) {
            return;
        }
        ArrayUtils.shift(array, offset, length, shift, offset);
    }

    private static void shift(int[] array, int offset, int length, int shift, int i) {
        if (i == offset + length) {
            return;
        }
        int newItem = array[ArrayUtils.repeat(offset, length, i - shift)];
        ArrayUtils.shift(array, offset, length, shift, i + 1);
        array[i] = newItem;
    }

    public static void shift(float[] array, int shift) {
        ArrayUtils.shift(array, 0, array.length, shift);
    }

    public static void shift(float[] array, int offset, int length, int shift) {
        ArrayUtils.checkRegion(array, offset, length);
        if (shift == 0) {
            return;
        }
        ArrayUtils.shift(array, offset, length, shift, offset);
    }

    private static void shift(float[] array, int offset, int length, int shift, int i) {
        if (i == offset + length) {
            return;
        }
        float newItem = array[ArrayUtils.repeat(offset, length, i - shift)];
        ArrayUtils.shift(array, offset, length, shift, i + 1);
        array[i] = newItem;
    }

    public static void shuffle(Object[] array) {
        ArrayUtils.shuffle(array, 0, array.length);
    }

    public static void shuffle(Object[] array, int offset, int length) {
        ArrayUtils.checkRegion(array, offset, length);
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = (int)(Math.random() * (double)(i + 1));
            Object tmp = array[i];
            array[i] = array[ii];
            array[ii] = tmp;
        }
    }

    public static void shuffle(int[] array) {
        ArrayUtils.shuffle(array, 0, array.length);
    }

    public static void shuffle(int[] array, int offset, int length) {
        ArrayUtils.checkRegion(array, offset, length);
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = (int)(Math.random() * (double)(i + 1));
            int tmp = array[i];
            array[i] = array[ii];
            array[ii] = tmp;
        }
    }

    public static void shuffle(float[] array) {
        ArrayUtils.shuffle(array, 0, array.length);
    }

    public static void shuffle(float[] array, int offset, int length) {
        ArrayUtils.checkRegion(array, offset, length);
        for (int i = offset + length - 1; i > offset; --i) {
            int ii = (int)(Math.random() * (double)(i + 1));
            float tmp = array[i];
            array[i] = array[ii];
            array[ii] = tmp;
        }
    }

    public static float[] unbox(Float[] values) {
        float[] unboxed = new float[values.length];
        for (int i = 0; i < unboxed.length; ++i) {
            unboxed[i] = values[i].floatValue();
        }
        return unboxed;
    }

    public static Float[] box(float[] values) {
        Float[] boxed = new Float[values.length];
        for (int i = 0; i < boxed.length; ++i) {
            boxed[i] = Float.valueOf(values[i]);
        }
        return boxed;
    }

    public static int[] unbox(Integer[] values) {
        int[] unboxed = new int[values.length];
        for (int i = 0; i < unboxed.length; ++i) {
            unboxed[i] = values[i];
        }
        return unboxed;
    }

    public static Integer[] box(int[] values) {
        Integer[] boxed = new Integer[values.length];
        for (int i = 0; i < boxed.length; ++i) {
            boxed[i] = values[i];
        }
        return boxed;
    }

    public static boolean[] unbox(Boolean[] values) {
        boolean[] unboxed = new boolean[values.length];
        for (int i = 0; i < unboxed.length; ++i) {
            unboxed[i] = values[i];
        }
        return unboxed;
    }

    public static Boolean[] box(boolean[] values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < boxed.length; ++i) {
            boxed[i] = values[i];
        }
        return boxed;
    }

    public static void checkRegion(Object[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException("array is null");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset: " + offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("negative length: " + length);
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException(offset + length);
        }
    }

    public static void requireCapacity(Object[] source, int offset, int length, Object[] dest, int destOffset) {
        ArrayUtils.checkRegion(source, offset, length);
        ArrayUtils.checkRegion(dest, destOffset, length);
    }

    public static int selectCount(int offset, int length, int start, int everyXth) {
        int count = 0;
        for (int i = start - 1; i < offset + length; i += everyXth) {
            if (i < offset) continue;
            ++count;
        }
        return count;
    }

    public static <T> T[] select(T[] items, int offset, int length, int start, int everyXth, T[] dest, int destOffset) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        ArrayUtils.checkRegion(dest, destOffset, outputLength);
        int di = destOffset;
        int i = start - 1;
        while (di < outputLength) {
            if (i >= offset) {
                dest[di] = items[i];
                ++di;
            }
            i += everyXth;
        }
        return dest;
    }

    public static <T> T[] select(T[] items, int offset, int length, int start, int everyXth, T[] dest) {
        return ArrayUtils.select(items, offset, length, start, everyXth, dest, 0);
    }

    public static <T> T[] select(T[] items, int start, int everyXth, T[] dest) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth, dest);
    }

    public static <T> T[] select(T[] items, int everyXth, T[] dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static <T> T[] select(T[] items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, new Object[ArrayUtils.selectCount(offset, length, start, everyXth)], 0);
    }

    public static <T> T[] select(T[] items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth);
    }

    public static <T> T[] select(T[] items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static <T> T[] select(T[] items, int[] indices, int indicesOffset, int indicesLength, T[] dest, int destOffset) {
        ArrayUtils.checkRegion(indices, indicesOffset, indicesLength);
        if (dest != null) {
            ArrayUtils.checkRegion(dest, destOffset, indicesLength);
        } else {
            dest = new Object[destOffset + indicesLength];
        }
        int i = indicesOffset;
        int di = destOffset;
        while (i < indicesOffset + indicesLength) {
            dest[di] = items[indices[i]];
            ++i;
            ++di;
        }
        return dest;
    }

    public static <T> T[] select(T[] items, int[] indices, T[] dest, int destOffset) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest, destOffset);
    }

    public static <T> T[] select(T[] items, int[] indices, T[] dest) {
        return ArrayUtils.select(items, indices, dest, 0);
    }

    public static <T> T[] select(T[] items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static void checkRegion(float[] array, int offset, int length) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset: " + offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("negative length: " + length);
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException(offset + length);
        }
    }

    public static void requireCapacity(float[] source, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(source, offset, length);
        ArrayUtils.checkRegion(dest, destOffset, length);
    }

    public static float[] select(float[] items, int offset, int length, int start, int everyXth, float[] dest, int destOffset) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        ArrayUtils.checkRegion(dest, destOffset, outputLength);
        int di = destOffset;
        int i = start - 1;
        while (di < outputLength) {
            if (i >= offset) {
                dest[di] = items[i];
                ++di;
            }
            i += everyXth;
        }
        return dest;
    }

    public static float[] select(float[] items, int offset, int length, int start, int everyXth, float[] dest) {
        return ArrayUtils.select(items, offset, length, start, everyXth, dest, 0);
    }

    public static float[] select(float[] items, int start, int everyXth, float[] dest) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth, dest);
    }

    public static float[] select(float[] items, int everyXth, float[] dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static float[] select(float[] items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, new float[ArrayUtils.selectCount(offset, length, start, everyXth)], 0);
    }

    public static float[] select(float[] items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth);
    }

    public static float[] select(float[] items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static float[] select(float[] items, int[] indices, int indicesOffset, int indicesLength, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(indices, indicesOffset, indicesLength);
        if (dest != null) {
            ArrayUtils.checkRegion(dest, destOffset, indicesLength);
        } else {
            dest = new float[destOffset + indicesLength];
        }
        int i = indicesOffset;
        int di = destOffset;
        while (i < indicesOffset + indicesLength) {
            dest[di] = items[indices[i]];
            ++i;
            ++di;
        }
        return dest;
    }

    public static float[] select(float[] items, int[] indices, float[] dest, int destOffset) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest, destOffset);
    }

    public static float[] select(float[] items, int[] indices, float[] dest) {
        return ArrayUtils.select(items, indices, dest, 0);
    }

    public static float[] select(float[] items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }

    public static void checkRegion(int[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException("array is null");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset: " + offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("negative length: " + length);
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException(offset + length);
        }
    }

    public static void requireCapacity(int[] source, int offset, int length, int[] dest, int destOffset) {
        ArrayUtils.checkRegion(source, offset, length);
        ArrayUtils.checkRegion(dest, destOffset, length);
    }

    public static int[] select(int[] items, int offset, int length, int start, int everyXth, int[] dest, int destOffset) {
        int outputLength = ArrayUtils.selectCount(offset, length, start, everyXth);
        ArrayUtils.checkRegion(dest, destOffset, outputLength);
        int di = destOffset;
        int i = start - 1;
        while (di < outputLength) {
            if (i >= offset) {
                dest[di] = items[i];
                ++di;
            }
            i += everyXth;
        }
        return dest;
    }

    public static int[] select(int[] items, int offset, int length, int start, int everyXth, int[] dest) {
        return ArrayUtils.select(items, offset, length, start, everyXth, dest, 0);
    }

    public static int[] select(int[] items, int start, int everyXth, int[] dest) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth, dest);
    }

    public static int[] select(int[] items, int everyXth, int[] dest) {
        return ArrayUtils.select(items, 0, everyXth, dest);
    }

    public static int[] select(int[] items, int offset, int length, int start, int everyXth) {
        return ArrayUtils.select(items, offset, length, start, everyXth, new int[ArrayUtils.selectCount(offset, length, start, everyXth)], 0);
    }

    public static int[] select(int[] items, int start, int everyXth) {
        return ArrayUtils.select(items, 0, items.length, start, everyXth);
    }

    public static int[] select(int[] items, int everyXth) {
        return ArrayUtils.select(items, 0, everyXth);
    }

    public static int[] select(int[] items, int[] indices, int indicesOffset, int indicesLength, int[] dest, int destOffset) {
        ArrayUtils.checkRegion(indices, indicesOffset, indicesLength);
        if (dest != null) {
            ArrayUtils.checkRegion(dest, destOffset, indicesLength);
        } else {
            dest = new int[destOffset + indicesLength];
        }
        int i = indicesOffset;
        int di = destOffset;
        while (i < indicesOffset + indicesLength) {
            dest[di] = items[indices[i]];
            ++i;
            ++di;
        }
        return dest;
    }

    public static int[] select(int[] items, int[] indices, int[] dest, int destOffset) {
        return ArrayUtils.select(items, indices, 0, indices.length, dest, destOffset);
    }

    public static int[] select(int[] items, int[] indices, int[] dest) {
        return ArrayUtils.select(items, indices, dest, 0);
    }

    public static int[] select(int[] items, int[] indices) {
        return ArrayUtils.select(items, indices, null);
    }
}

