/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils;

public class Pair<K, V> {
    private K key;
    private V value;

    public Pair() {
    }

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public Pair(Pair<K, V> pair) {
        this.key = pair.key;
        this.value = pair.value;
    }

    public Pair<K, V> set(Pair<K, V> pair) {
        this.key = pair.key;
        this.value = pair.value;
        return this;
    }

    public Pair<K, V> set(K key, V value) {
        this.key = key;
        this.value = value;
        return this;
    }

    public void clear() {
        this.key = null;
        this.value = null;
    }

    public void clearKey() {
        this.key = null;
    }

    public void clearValue() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.key == null && this.value == null;
    }

    public boolean isFull() {
        return this.key != null && this.value != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public void swap() throws IllegalStateException {
        if (this.key.getClass() != this.value.getClass()) {
            throw new IllegalStateException("key and value are not of the same type: " + this.key.getClass() + " & " + this.value.getClass());
        }
        V oldValue = this.value;
        this.value = this.key;
        this.key = oldValue;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair pair = (Pair)obj;
            return this.key.equals(pair.key) && this.value.equals(pair.value);
        }
        return super.equals(obj);
    }

    public String toString() {
        return "[" + this.key + " & " + this.value + ']';
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }
}

