/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.entity.projectile;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mixac1.dangerrpg.init.RPGOther;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityProjectile
extends EntityArrow
implements IThrowableEntity {
    protected boolean beenInGround;
    protected int lifespan;
    public EntityLivingBase thrower;
    protected String throwerName;

    public EntityProjectile(World world) {
        super(world);
        this.field_70255_ao = 0.0;
        this.field_70249_b = this.getMaxUntouchability();
        this.field_70173_aa = -1;
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityProjectile(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70255_ao = 0.0;
        this.field_70249_b = this.getMaxUntouchability();
        this.field_70173_aa = -1;
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityProjectile(World world, EntityLivingBase thrower, float speed, float deviation) {
        this(world);
        this.thrower = thrower;
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, deviation);
    }

    public EntityProjectile(World world, EntityLivingBase thrower, EntityLivingBase target, float speed, float deviation) {
        super(world, thrower, target, speed, deviation);
        this.field_70255_ao = 0.0;
        this.field_70249_b = this.getMaxUntouchability();
        this.field_70173_aa = -1;
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70186_c(double x, double y, double z, float speed, float deviation) {
        super.func_70186_c(x, y, z, speed, deviation);
        this.lifespan = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.needAimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        Block i;
        super.func_70030_z();
        if (this.getMaxLifespan() > 0 && ++this.lifespan >= this.getMaxLifespan()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.needAimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.makeAimRotation();
        }
        if ((i = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f)) != null) {
            i.func_149719_a((IBlockAccess)this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            AxisAlignedBB axisalignedbb = i.func_149668_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.field_70254_i = true;
            }
        }
        if (this.field_70254_i) {
            Block j = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f);
            int k = this.field_70170_p.func_72805_g(this.field_145791_d, this.field_145792_e, this.field_145789_f);
            if (j != this.field_145790_g || k != this.field_70253_h) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            }
            return;
        }
        MovingObjectPosition mop = this.findMovingObjectPosition();
        if (mop != null) {
            this.preInpact(mop);
            if (mop.field_72308_g != null) {
                this.onEntityHit((EntityLivingBase)mop.field_72308_g);
                if (this.dieAfterEntityHit()) {
                    this.func_70106_y();
                }
            } else {
                this.onGroundHit(mop);
                if (this.dieAfterGroundHit()) {
                    this.func_70106_y();
                }
            }
            this.field_70249_b = this.getMaxUntouchability();
            this.postInpact(mop);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if (this.needAimRotation()) {
            float tmp = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, tmp) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        }
        if (this.canRotation()) {
            this.field_70177_z += this.getRotationOnYaw();
            this.field_70125_A += this.getRotationOnPitch();
        }
        this.field_70159_w *= (double)this.getAirResistance();
        this.field_70181_x *= (double)this.getAirResistance();
        this.field_70179_y *= (double)this.getAirResistance();
        this.field_70181_x -= (double)this.getGravity();
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.func_70090_H()) {
            this.onCollideWithWater();
        }
        this.playOnUpdateSound();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void makeAimRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
    }

    public MovingObjectPosition findMovingObjectPosition() {
        Vec3 vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec32 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition mop = this.field_70170_p.func_147447_a(vec31, vec32, false, true, false);
        vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec32 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (mop != null) {
            vec32 = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (Entity iterEntity : list) {
            double d1;
            float f4;
            AxisAlignedBB aabb;
            MovingObjectPosition newMop;
            if (!iterEntity.func_70067_L() || !(iterEntity instanceof EntityLivingBase) || iterEntity == this.thrower && this.lifespan < 5 || (newMop = (aabb = iterEntity.field_70121_D.func_72314_b((double)(f4 = 0.3f), (double)f4, (double)f4)).func_72327_a(vec31, vec32)) == null || !((d1 = vec31.func_72438_d(newMop.field_72307_f)) < d) && d != 0.0) continue;
            entity = iterEntity;
            d = d1;
        }
        if (entity != null) {
            mop = new MovingObjectPosition(entity);
            if (mop.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)mop.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.thrower instanceof EntityPlayer && this.thrower != null && !((EntityPlayer)this.thrower).func_96122_a(entityplayer)) {
                    mop = null;
                }
            }
        }
        return mop;
    }

    public void preInpact(MovingObjectPosition mop) {
    }

    public void postInpact(MovingObjectPosition mop) {
    }

    public void onEntityHit(EntityLivingBase entity) {
        if (!this.field_70170_p.field_72995_K) {
            this.applyEntityHitEffects(entity, this.getDamageMul());
        }
        this.bounceBack();
    }

    public void applyEntityHitEffects(EntityLivingBase entity, float dmgMul) {
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (this.thrower != null) {
            int fire;
            EnchantmentHelper.func_151384_a((EntityLivingBase)entity, (Entity)this.thrower);
            EnchantmentHelper.func_151385_b((EntityLivingBase)this.thrower, (Entity)entity);
            if (this.thrower instanceof EntityPlayerMP && this.thrower != entity && entity instanceof EntityPlayer) {
                ((EntityPlayerMP)this.thrower).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
            }
            if ((fire = EnchantmentHelper.func_90036_a((EntityLivingBase)this.thrower)) > 0 && !entity.func_70027_ad()) {
                entity.func_70015_d(1);
            }
        }
        entity.func_70097_a(RPGOther.RPGDamageSource.magic, (float)this.field_70255_ao * dmgMul);
        this.playHitSound();
    }

    public void onGroundHit(MovingObjectPosition mop) {
        this.field_145791_d = mop.field_72311_b;
        this.field_145792_e = mop.field_72312_c;
        this.field_145789_f = mop.field_72309_d;
        this.field_145790_g = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.field_70253_h = this.field_70170_p.func_72805_g(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70254_i = true;
        this.beenInGround = true;
        this.field_70249_b = this.getMaxUntouchability();
        this.playHitSound();
        if (this.field_145790_g != null) {
            this.field_145790_g.func_149670_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f, (Entity)this);
        }
        if (this.needAimRotation()) {
            this.makeAimRotation();
        }
    }

    public void onCollideWithWater() {
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.field_70159_w *= (double)this.getWaterResistance();
        this.field_70181_x *= (double)this.getWaterResistance();
        this.field_70179_y *= (double)this.getWaterResistance();
        this.beenInGround = true;
    }

    public void func_70100_b_(EntityPlayer player) {
    }

    protected void bounceBack() {
        this.field_70159_w *= -0.05;
        this.field_70181_x *= -0.05;
        this.field_70179_y *= -0.05;
    }

    public float getDamageMul() {
        return 1.0f;
    }

    public Entity getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.thrower = (EntityLivingBase)entity;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public float getAirResistance() {
        return 1.0f;
    }

    public float getWaterResistance() {
        return 1.0f;
    }

    public float getGravity() {
        return 0.0f;
    }

    public int getMaxUntouchability() {
        return 7;
    }

    public boolean dieAfterEntityHit() {
        return true;
    }

    public boolean dieAfterGroundHit() {
        return false;
    }

    public boolean canRotation() {
        return !this.beenInGround;
    }

    public float getRotationOnPitch() {
        return 0.0f;
    }

    public float getRotationOnYaw() {
        return 0.0f;
    }

    public boolean needAimRotation() {
        return this.field_70254_i || !this.field_70254_i && (!this.canRotation() || this.getRotationOnYaw() == 0.0f && this.getRotationOnPitch() == 0.0f);
    }

    public int getMaxLifespan() {
        return 6000;
    }

    public void playHitSound() {
    }

    public void playOnUpdateSound() {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("beenInGround", this.beenInGround);
        nbt.func_74768_a("lifespan", this.lifespan);
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        nbt.func_74778_a("throwerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.beenInGround = nbt.func_74767_n("beenInGrond");
        this.lifespan = nbt.func_74762_e("lifespan");
        this.throwerName = nbt.func_74779_i("throwerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        this.thrower = (EntityLivingBase)this.getThrower();
    }
}

