/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.hook;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import java.util.ArrayList;
import java.util.Arrays;
import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.ea.PlayerAttributes;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.init.RPGConfig;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class HookArmorSystem {
    public static final float MAX_PHISICAL_ARMOR = 40.0f;

    public static float convertPhisicArmor(float armor) {
        return Utils.alignment(armor * 100.0f / 40.0f, 0.0f, 100.0f);
    }

    private static float getPhisicArmor(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemArmor) {
            if (ItemAttributes.PHISIC_ARMOR.hasIt(stack)) {
                return ItemAttributes.PHISIC_ARMOR.get(stack);
            }
            return HookArmorSystem.convertPhisicArmor(((ItemArmor)stack.func_77973_b()).field_77879_b);
        }
        return 0.0f;
    }

    private static float getMagicArmor(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemArmor && ItemAttributes.MAGIC_ARMOR.hasIt(stack)) {
            return ItemAttributes.MAGIC_ARMOR.get(stack);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getTotalArmor(DamageSource source) {
        float value = 0.0f;
        Minecraft mc = Minecraft.func_71410_x();
        float damage = (float)RPGConfig.mainDamageForArmorBar * 40.0f;
        ArrayList<ISpecialArmor.ArmorProperties> list = HookArmorSystem.getArrayArmorProperties((EntityLivingBase)mc.field_71439_g, mc.field_71439_g.field_71071_by.field_70460_b, source, damage);
        if (list.size() > 0) {
            ISpecialArmor.ArmorProperties[] props = list.toArray(new ISpecialArmor.ArmorProperties[list.size()]);
            HookArmorSystem.standardizeList(props, damage);
            for (ISpecialArmor.ArmorProperties prop : props) {
                value = (float)((double)value + prop.AbsorbRatio);
            }
        }
        return Utils.alignment(value += HookArmorSystem.getPassiveArmor((EntityLivingBase)mc.field_71439_g, source) / 100.0f, 0.0f, 1.0f) * 100.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getTotalPhisicArmor() {
        return HookArmorSystem.getTotalArmor(RPGOther.RPGDamageSource.phisic);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getTotalMagicArmor() {
        return HookArmorSystem.getTotalArmor(RPGOther.RPGDamageSource.magic);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getArmor(ItemStack stack, DamageSource source) {
        return (float)(HookArmorSystem.getArmorProperties((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, (ItemStack)stack, (int)0, (DamageSource)source, (double)5.0).AbsorbRatio * 100.0);
    }

    public static float getPassiveArmor(EntityLivingBase entity, DamageSource source) {
        float specArmor = 0.0f;
        if (entity instanceof EntityPlayer) {
            specArmor = source.func_82725_o() ? ((Float)PlayerAttributes.MAG_IMUN.getValue(entity)).floatValue() : ((Float)PlayerAttributes.STONESKIN.getValue(entity)).floatValue();
        }
        return specArmor;
    }

    private static ISpecialArmor.ArmorProperties getArmorProperties(EntityLivingBase entity, ItemStack stack, int slot, DamageSource source, double damage) {
        ISpecialArmor.ArmorProperties prop = null;
        if (stack.func_77973_b() instanceof ISpecialArmor) {
            ISpecialArmor armor = (ISpecialArmor)stack.func_77973_b();
            prop = armor.getProperties(entity, stack, source, damage, slot).copy();
        } else if (LvlableItem.isLvlable(stack)) {
            if (stack.func_77973_b() instanceof ItemArmor && !source.func_76363_c()) {
                float armorValue = source.func_82725_o() ? HookArmorSystem.getMagicArmor(stack) : HookArmorSystem.getPhisicArmor(stack);
                prop = new ISpecialArmor.ArmorProperties(0, (double)(armorValue / 100.0f), ((ItemArmor)stack.func_77973_b()).func_77612_l() + 1 - stack.func_77960_j());
            }
        } else if (stack.func_77973_b() instanceof ItemArmor && !source.func_76363_c()) {
            float armorValue = source.func_82725_o() ? 0.0f : (float)((ItemArmor)stack.func_77973_b()).field_77879_b / 40.0f;
            prop = new ISpecialArmor.ArmorProperties(0, (double)armorValue, ((ItemArmor)stack.func_77973_b()).func_77612_l() + 1 - stack.func_77960_j());
        }
        return prop;
    }

    private static ArrayList<ISpecialArmor.ArmorProperties> getArrayArmorProperties(EntityLivingBase entity, ItemStack[] inventory, DamageSource source, double damage) {
        ArrayList<ISpecialArmor.ArmorProperties> dmgVals = new ArrayList<ISpecialArmor.ArmorProperties>();
        for (int x = 0; x < inventory.length; ++x) {
            ISpecialArmor.ArmorProperties prop;
            ItemStack stack = inventory[x];
            if (stack == null || (prop = HookArmorSystem.getArmorProperties(entity, inventory[x], x, source, damage)) == null) continue;
            prop.Slot = x;
            dmgVals.add(prop);
        }
        return dmgVals;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static float ApplyArmor(ISpecialArmor.ArmorProperties nullObj, EntityLivingBase entity, ItemStack[] inventory, DamageSource source, double damage) {
        ArrayList<ISpecialArmor.ArmorProperties> dmgVals = HookArmorSystem.getArrayArmorProperties(entity, inventory, source, damage);
        damage *= 40.0;
        if (dmgVals.size() > 0) {
            ISpecialArmor.ArmorProperties[] props = dmgVals.toArray(new ISpecialArmor.ArmorProperties[dmgVals.size()]);
            HookArmorSystem.standardizeList(props, damage);
            int level = props[0].Priority;
            double ratio = 0.0;
            for (ISpecialArmor.ArmorProperties prop : props) {
                if (level != prop.Priority) {
                    damage -= damage * ratio;
                    ratio = 0.0;
                    level = prop.Priority;
                }
                ratio += prop.AbsorbRatio;
                double absorb = damage * prop.AbsorbRatio;
                if (!(absorb > 0.0)) continue;
                ItemStack stack = inventory[prop.Slot];
                int itemDamage = (int)(absorb / 40.0 < 1.0 ? 1.0 : absorb / 40.0);
                if (stack.func_77973_b() instanceof ISpecialArmor) {
                    ((ISpecialArmor)stack.func_77973_b()).damageArmor(entity, stack, source, itemDamage, prop.Slot);
                } else {
                    stack.func_77972_a(itemDamage, entity);
                }
                if (stack.field_77994_a > 0) continue;
                inventory[prop.Slot] = null;
            }
            damage -= damage * (double)Utils.alignment((float)(ratio += (double)(HookArmorSystem.getPassiveArmor(entity, source) / 100.0f)), 0.0f, 1.0f);
        }
        return (float)(damage / 40.0);
    }

    private static void standardizeList(ISpecialArmor.ArmorProperties[] armor, double damage) {
        Arrays.sort(armor);
        int start = 0;
        double total = 0.0;
        int priority = armor[0].Priority;
        int pStart = 0;
        boolean pChange = false;
        boolean pFinished = false;
        for (int x = 0; x < armor.length; ++x) {
            int y;
            total += armor[x].AbsorbRatio;
            if (x != armor.length - 1 && armor[x].Priority == priority) continue;
            if (armor[x].Priority != priority) {
                total -= armor[x].AbsorbRatio;
                --x;
                pChange = true;
            }
            if (total > 1.0) {
                for (y = start; y <= x; ++y) {
                    double newRatio = armor[y].AbsorbRatio / total;
                    if (newRatio * damage > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                        total = 0.0;
                        for (int z = pStart; z <= y; ++z) {
                            total += armor[z].AbsorbRatio;
                        }
                        start = y + 1;
                        x = y;
                        break;
                    }
                    armor[y].AbsorbRatio = newRatio;
                    pFinished = true;
                }
                if (!pChange || !pFinished) continue;
                damage -= damage * total;
                total = 0.0;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                pFinished = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            } else {
                for (y = start; y <= x; ++y) {
                    total -= armor[y].AbsorbRatio;
                    if (damage * armor[y].AbsorbRatio > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                    }
                    total += armor[y].AbsorbRatio;
                }
                damage -= damage * total;
                total = 0.0;
                if (x == armor.length - 1) continue;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            }
            break;
        }
    }
}

