/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.item;

import java.util.HashMap;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.item.IMaterialSpecial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.util.EnumHelper;

public class RPGArmorMaterial
implements IMaterialSpecial {
    public static HashMap<ItemArmor.ArmorMaterial, RPGArmorMaterial> map = new HashMap();
    public static final RPGArmorMaterial CLOTH = new RPGArmorMaterial("cloth", ItemArmor.ArmorMaterial.CLOTH);
    public static final RPGArmorMaterial CHAIN = new RPGArmorMaterial("chain", ItemArmor.ArmorMaterial.CHAIN);
    public static final RPGArmorMaterial IRON = new RPGArmorMaterial("iron", ItemArmor.ArmorMaterial.IRON);
    public static final RPGArmorMaterial GOLD = new RPGArmorMaterial("gold", ItemArmor.ArmorMaterial.GOLD);
    public static final RPGArmorMaterial DIAMOND = new RPGArmorMaterial("diamond", ItemArmor.ArmorMaterial.DIAMOND);
    public static final RPGArmorMaterial OBSIDIAN = new RPGArmorMaterial("obsidian", EnumHelper.addArmorMaterial((String)"OBSIDIAN", (int)41, (int[])new int[]{4, 8, 6, 4}, (int)12), 15379456, RPGOther.RPGItemRarity.rare);
    public static final RPGArmorMaterial BEDROCK = new RPGArmorMaterial("bedrock", EnumHelper.addArmorMaterial((String)"BEDROCK", (int)82, (int[])new int[]{7, 9, 8, 6}, (int)14), 17408, RPGOther.RPGItemRarity.mythic);
    public static final RPGArmorMaterial BLACK_MATTER = new RPGArmorMaterial("black_matter", EnumHelper.addArmorMaterial((String)"BLACK_MATTER", (int)164, (int[])new int[]{8, 10, 10, 8}, (int)19), 0x111111, RPGOther.RPGItemRarity.epic);
    public static final RPGArmorMaterial WHITE_MATTER = new RPGArmorMaterial("white_matter", EnumHelper.addArmorMaterial((String)"WHITE_MATTER", (int)206, (int[])new int[]{9, 10, 10, 9}, (int)22), 0xFFFFFF, RPGOther.RPGItemRarity.legendary);
    public ItemArmor.ArmorMaterial material;
    public String name;
    public float magicRes;
    public Integer color;
    public EnumRarity rarity;

    public RPGArmorMaterial(String name, ItemArmor.ArmorMaterial material) {
        this.name = name;
        this.material = material;
        map.put(material, this);
    }

    public RPGArmorMaterial(String name, ItemArmor.ArmorMaterial material, Integer color, EnumRarity rarity) {
        this(name, material);
        this.color = color;
        this.rarity = rarity;
    }

    protected void init(float magicRes) {
        this.magicRes = magicRes;
    }

    public static RPGArmorMaterial armorMaterialHook(ItemArmor.ArmorMaterial material) {
        if (!map.containsKey(material)) {
            map.put(material, new RPGArmorMaterial(material.name(), material));
        }
        return map.get(material);
    }

    @Override
    public boolean hasSpecialColor() {
        return this.color != null;
    }

    @Override
    public int getSpecialColor() {
        return this.color;
    }

    @Override
    public EnumRarity getItemRarity() {
        return this.rarity == null ? RPGOther.RPGItemRarity.common : this.rarity;
    }

    static {
        CLOTH.init(0.0f);
        CHAIN.init(0.0f);
        IRON.init(4.0f);
        GOLD.init(10.0f);
        DIAMOND.init(8.0f);
        OBSIDIAN.init(6.0f);
        BEDROCK.init(12.0f);
        BLACK_MATTER.init(16.0f);
        WHITE_MATTER.init(20.0f);
    }
}

