/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.item;

import java.util.HashMap;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.item.IMaterialSpecial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;

public class RPGToolMaterial
implements IMaterialSpecial {
    public static HashMap<Item.ToolMaterial, RPGToolMaterial> map = new HashMap();
    public static final RPGToolMaterial WOOD = new RPGToolMaterial("wood", Item.ToolMaterial.WOOD);
    public static final RPGToolMaterial STONE = new RPGToolMaterial("stone", Item.ToolMaterial.STONE);
    public static final RPGToolMaterial IRON = new RPGToolMaterial("iron", Item.ToolMaterial.IRON);
    public static final RPGToolMaterial GOLD = new RPGToolMaterial("gold", Item.ToolMaterial.GOLD);
    public static final RPGToolMaterial DIAMOND = new RPGToolMaterial("diamond", Item.ToolMaterial.EMERALD);
    public static final RPGToolMaterial OBSIDIAN = new RPGToolMaterial("obsidian", EnumHelper.addToolMaterial((String)"OBSIDIAN", (int)3, (int)2000, (float)8.0f, (float)5.0f, (int)12), 15379456, RPGOther.RPGItemRarity.rare);
    public static final RPGToolMaterial BEDROCK = new RPGToolMaterial("bedrock", EnumHelper.addToolMaterial((String)"BEDROCK", (int)3, (int)4000, (float)18.0f, (float)11.0f, (int)14), 17408, RPGOther.RPGItemRarity.mythic);
    public static final RPGToolMaterial BLACK_MATTER = new RPGToolMaterial("black_matter", EnumHelper.addToolMaterial((String)"BLACK_MATTER", (int)3, (int)8000, (float)30.0f, (float)21.0f, (int)19), 0, RPGOther.RPGItemRarity.epic);
    public static final RPGToolMaterial WHITE_MATTER = new RPGToolMaterial("white_matter", EnumHelper.addToolMaterial((String)"WHITE_MATTER", (int)3, (int)10000, (float)50.0f, (float)36.0f, (int)22), 0xFFFFFF, RPGOther.RPGItemRarity.legendary);
    public Item.ToolMaterial material;
    public String name;
    public Integer color;
    public EnumRarity rarity;

    public RPGToolMaterial(String name, Item.ToolMaterial material) {
        this.name = name;
        this.material = material;
        map.put(material, this);
    }

    public RPGToolMaterial(String name, Item.ToolMaterial material, Integer color, EnumRarity rarity) {
        this(name, material);
        this.color = color;
        this.rarity = rarity;
    }

    protected void init() {
    }

    public static RPGToolMaterial toolMaterialHook(Item.ToolMaterial material) {
        if (!map.containsKey(material)) {
            map.put(material, new RPGToolMaterial(material.name(), material));
        }
        return map.get(material);
    }

    @Override
    public boolean hasSpecialColor() {
        return this.color != null;
    }

    @Override
    public int getSpecialColor() {
        return this.color;
    }

    @Override
    public EnumRarity getItemRarity() {
        return this.rarity == null ? RPGOther.RPGItemRarity.common : this.rarity;
    }

    static {
        WOOD.init();
        STONE.init();
        IRON.init();
        GOLD.init();
        DIAMOND.init();
        OBSIDIAN.init();
        BEDROCK.init();
        BLACK_MATTER.init();
        WHITE_MATTER.init();
    }
}

