/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface ITypeProvider<Type> {
    public static final ITypeProvider<Boolean> BOOLEAN = new ITypeProvider<Boolean>(){

        @Override
        public void toNBT(Boolean value, String key, NBTTagCompound nbt) {
            nbt.func_74757_a(key, value.booleanValue());
        }

        @Override
        public Boolean fromNBT(String key, NBTTagCompound nbt) {
            return nbt.func_74767_n(key);
        }

        @Override
        public boolean isValid(Boolean value) {
            return true;
        }

        @Override
        public Boolean concat(Boolean value1, Boolean value2) {
            return value1 != false || value2 != false;
        }

        @Override
        public String toString(Boolean value) {
            return value.toString();
        }

        @Override
        public Boolean getEmpty() {
            return false;
        }
    };
    public static final ITypeProvider<Integer> INTEGER = new ITypeProvider<Integer>(){

        @Override
        public void toNBT(Integer value, String key, NBTTagCompound nbt) {
            nbt.func_74768_a(key, value.intValue());
        }

        @Override
        public Integer fromNBT(String key, NBTTagCompound nbt) {
            return nbt.func_74762_e(key);
        }

        @Override
        public boolean isValid(Integer value) {
            return value >= 0;
        }

        @Override
        public Integer concat(Integer value1, Integer value2) {
            return value1 + value2;
        }

        @Override
        public String toString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer getEmpty() {
            return 0;
        }
    };
    public static final ITypeProvider<Float> FLOAT = new ITypeProvider<Float>(){

        @Override
        public void toNBT(Float value, String key, NBTTagCompound nbt) {
            nbt.func_74776_a(key, value.floatValue());
        }

        @Override
        public Float fromNBT(String key, NBTTagCompound nbt) {
            return Float.valueOf(nbt.func_74760_g(key));
        }

        @Override
        public boolean isValid(Float value) {
            return value.floatValue() >= 0.0f;
        }

        @Override
        public Float concat(Float value1, Float value2) {
            return Float.valueOf(value1.floatValue() + value2.floatValue());
        }

        @Override
        public String toString(Float value) {
            return String.format("%.1f", value);
        }

        @Override
        public Float getEmpty() {
            return Float.valueOf(0.0f);
        }
    };
    public static final ITypeProvider<String> STRING = new ITypeProvider<String>(){

        @Override
        public void toNBT(String value, String key, NBTTagCompound nbt) {
            nbt.func_74778_a(key, value);
        }

        @Override
        public String fromNBT(String key, NBTTagCompound nbt) {
            return nbt.func_74779_i(key);
        }

        @Override
        public boolean isValid(String value) {
            return value != null && value != "";
        }

        @Override
        public String concat(String value1, String value2) {
            value1 = value1.concat(value2);
            return value1;
        }

        @Override
        public String toString(String value) {
            return value;
        }

        @Override
        public String getEmpty() {
            return "";
        }
    };
    public static final ITypeProvider<NBTTagCompound> NBT_TAG = new ITypeProvider<NBTTagCompound>(){

        @Override
        public void toNBT(NBTTagCompound value, String key, NBTTagCompound nbt) {
            nbt.func_74782_a(key, (NBTBase)value);
        }

        @Override
        public NBTTagCompound fromNBT(String key, NBTTagCompound nbt) {
            return (NBTTagCompound)nbt.func_74781_a(key);
        }

        @Override
        public boolean isValid(NBTTagCompound value) {
            return value != null;
        }

        @Override
        @Deprecated
        public NBTTagCompound concat(NBTTagCompound value1, NBTTagCompound value2) {
            return value1;
        }

        @Override
        public String toString(NBTTagCompound value) {
            return value.toString();
        }

        @Override
        public NBTTagCompound getEmpty() {
            return new NBTTagCompound();
        }
    };
    public static final ITypeProvider<ItemStack> ITEM_STACK = new ITypeProvider<ItemStack>(){

        @Override
        public void toNBT(ItemStack value, String key, NBTTagCompound nbt) {
            value.func_77955_b(nbt);
        }

        @Override
        public ItemStack fromNBT(String key, NBTTagCompound nbt) {
            return ItemStack.func_77949_a((NBTTagCompound)nbt);
        }

        @Override
        public boolean isValid(ItemStack value) {
            return value != null;
        }

        @Override
        @Deprecated
        public ItemStack concat(ItemStack value1, ItemStack value2) {
            return value1;
        }

        @Override
        public String toString(ItemStack value) {
            return value.toString();
        }

        @Override
        public ItemStack getEmpty() {
            return null;
        }
    };

    public void toNBT(Type var1, String var2, NBTTagCompound var3);

    public Type fromNBT(String var1, NBTTagCompound var2);

    public Type getEmpty();

    public boolean isValid(Type var1);

    public Type concat(Type var1, Type var2);

    public String toString(Type var1);
}

