/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.world.explosion;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import mixac1.dangerrpg.init.RPGNetwork;
import mixac1.dangerrpg.network.MsgExplosion;
import mixac1.dangerrpg.world.explosion.ExplosionEffect;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionCommonRPG
extends Explosion {
    public float powerMul = 1.0f;
    public float damage = 1.0f;
    public boolean isDependDist = true;
    public boolean isBlockDestroy = false;

    public ExplosionCommonRPG(Entity entity, double x, double y, double z, float explosionSize) {
        super(entity.field_70170_p, entity, x, y, z, explosionSize);
    }

    public void init(boolean isBlockDestroy, float powerMul, float damage, boolean isDependDist) {
        this.isBlockDestroy = isBlockDestroy;
        this.powerMul = powerMul;
        this.damage = damage;
        this.isDependDist = isDependDist;
    }

    public void doExplosion() {
        if (!this.field_77287_j.field_72995_K) {
            if (ForgeEventFactory.onExplosionStart((World)this.field_77287_j, (Explosion)this)) {
                return;
            }
            if (this.isBlockDestroy) {
                this.explosionBlocksPre();
                this.explosionBlocksPost();
            }
            this.explosionEntities();
            RPGNetwork.net.sendToAll((IMessage)new MsgExplosion(this.getExplosionEffect().getId(), this.field_77284_b, this.field_77285_c, this.field_77282_d, this.field_77280_f, this.getEffectMeta()));
        }
    }

    public ExplosionEffect getExplosionEffect() {
        return ExplosionEffect.EMPTY;
    }

    public Object[] getEffectMeta() {
        return null;
    }

    public void explosionBlocksPre() {
        for (int i = 0; i < this.field_77289_h; ++i) {
            for (int j = 0; j < this.field_77289_h; ++j) {
                for (int k = 0; k < this.field_77289_h; ++k) {
                    if (i != 0 && i != this.field_77289_h - 1 && j != 0 && j != this.field_77289_h - 1 && k != 0 && k != this.field_77289_h - 1) continue;
                    double d0 = (float)i / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d5 = this.field_77285_c;
                    double d6 = this.field_77282_d;
                    float f2 = 0.3f;
                    for (float f1 = this.field_77280_f * this.powerMul * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int l1;
                        int k1;
                        int j1 = MathHelper.func_76128_c((double)d4);
                        Block block = this.field_77287_j.func_147439_a(j1, k1 = MathHelper.func_76128_c((double)d5), l1 = MathHelper.func_76128_c((double)d6));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            float f3 = block.getExplosionResistance(this.field_77283_e, this.field_77287_j, j1, k1, l1, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                            f1 -= (f3 + 0.3f) * f2;
                        }
                        if (f1 > 0.0f) {
                            this.field_77281_g.add(new ChunkPosition(j1, k1, l1));
                        }
                        d4 += d0 * (double)f2;
                        d5 += d1 * (double)f2;
                        d6 += d2 * (double)f2;
                    }
                }
            }
        }
    }

    public void explosionBlocksPost() {
        for (Object obj : this.field_77281_g) {
            ChunkPosition chunkposition = (ChunkPosition)obj;
            int i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            int k = chunkposition.field_151328_c;
            Block block = this.field_77287_j.func_147439_a(i, j, k);
            if (block.func_149688_o() == Material.field_151579_a) continue;
            if (block.func_149659_a((Explosion)this)) {
                block.func_149690_a(this.field_77287_j, i, j, k, this.field_77287_j.func_72805_g(i, j, k), 1.0f / this.field_77280_f, 0);
            }
            block.onBlockExploded(this.field_77287_j, i, j, k, (Explosion)this);
        }
    }

    public void explosionEntities() {
        int minX = MathHelper.func_76128_c((double)(this.field_77284_b - (double)this.field_77280_f - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.field_77284_b + (double)this.field_77280_f + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.field_77285_c - (double)this.field_77280_f - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.field_77285_c + (double)this.field_77280_f + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.field_77282_d - (double)this.field_77280_f - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.field_77282_d + (double)this.field_77280_f + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3 vec3 = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
        for (Object obj : list) {
            double posZ;
            double posY;
            double posX;
            double dist1;
            EntityLivingBase entity;
            double dist;
            if (!(obj instanceof EntityLivingBase) || !((dist = (entity = (EntityLivingBase)obj).func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)this.field_77280_f) <= 1.0) || (dist1 = (double)MathHelper.func_76133_a((double)((posX = entity.field_70165_t - this.field_77284_b) * posX + (posY = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * posY + (posZ = entity.field_70161_v - this.field_77282_d) * posZ))) == 0.0) continue;
            posX /= dist1;
            posY /= dist1;
            posZ /= dist1;
            float power = (float)(1.0 - dist);
            this.applyEntityHitEffects(entity, (float)(1.0 - dist));
        }
    }

    public void applyEntityHitEffects(EntityLivingBase entity, float power) {
        entity.func_70097_a(DamageSource.field_76376_m, this.isDependDist ? this.damage * power : this.damage);
    }

    @Deprecated
    public void func_77278_a() {
    }

    @Deprecated
    public void func_77279_a(boolean p_77279_1_) {
    }
}

