/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.asm.AsmHook;
import gloomyfolken.hooklib.asm.HookContainerParser;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookLogger;
import gloomyfolken.hooklib.asm.SafeClassWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class HookClassTransformer {
    public HookLogger logger = new HookLogger.SystemOutLogger();
    public HashMap<String, List<AsmHook>> hooksMap = new HashMap();
    private HookContainerParser containerParser = new HookContainerParser(this);

    public void registerHook(AsmHook hook) {
        if (this.hooksMap.containsKey(hook.getTargetClassName())) {
            this.hooksMap.get(hook.getTargetClassName()).add(hook);
        } else {
            ArrayList<AsmHook> list = new ArrayList<AsmHook>(2);
            list.add(hook);
            this.hooksMap.put(hook.getTargetClassName(), list);
        }
    }

    public void registerHookContainer(String className) {
        this.containerParser.parseHooks(className);
    }

    public void registerHookContainer(InputStream classData) {
        this.containerParser.parseHooks(classData);
    }

    public byte[] transform(String className, byte[] bytecode) {
        List<AsmHook> hooks = this.hooksMap.get(className);
        if (hooks != null) {
            try {
                Collections.sort(hooks);
                this.logger.debug("Injecting hooks into class " + className);
                int numHooks = hooks.size();
                int majorVersion = (bytecode[6] & 0xFF) << 8 | bytecode[7] & 0xFF;
                boolean java7 = majorVersion > 50;
                ClassReader cr = new ClassReader(bytecode);
                ClassWriter cw = this.createClassWriter(java7 ? 2 : 1);
                HookInjectorClassVisitor hooksWriter = this.createInjectorClassVisitor(cw, hooks);
                cr.accept((ClassVisitor)hooksWriter, java7 ? 4 : 8);
                int numInjectedHooks = numHooks - hooksWriter.hooks.size();
                this.logger.debug("Successfully injected " + numInjectedHooks + " hook" + (numInjectedHooks == 1 ? "" : "s") + " to " + className);
                for (AsmHook notInjected : hooksWriter.hooks) {
                    this.logger.warning("Can not found target method of hook " + notInjected);
                }
                return cw.toByteArray();
            }
            catch (Exception e) {
                this.logger.severe("A problem has occured during transformation of class " + className + ".");
                this.logger.severe("Attached hooks:");
                for (AsmHook hook : hooks) {
                    this.logger.severe(hook.toString());
                }
                this.logger.severe("Stack trace:", e);
            }
        }
        return bytecode;
    }

    protected HookInjectorClassVisitor createInjectorClassVisitor(ClassWriter cw, List<AsmHook> hooks) {
        return new HookInjectorClassVisitor(cw, hooks);
    }

    protected ClassWriter createClassWriter(int flags) {
        return new SafeClassWriter(flags);
    }
}

