/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.api.entity;

import mixac1.dangerrpg.api.entity.EntityAttribute;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.capability.ea.EntityAttributes;
import net.minecraft.entity.EntityLivingBase;

public interface IRPGEntity {
    public static final IRPGEntity DEFAULT_PLAYER = new IRPGEntity(){

        @Override
        public EntityAttribute.EAFloat getEAMeleeDamage(EntityLivingBase entity) {
            return null;
        }

        @Override
        public EntityAttribute.EAFloat getEARangeDamage(EntityLivingBase entity) {
            return null;
        }

        @Override
        public void registerAttributes(Class<? extends EntityLivingBase> entityClass, RPGEntityData.EntityAttributesSet set) {
            RPGEntityData.registerEntityPlayer(entityClass, set);
        }
    };
    public static final IRPGEntity DEFAULT_LIVING = new RPGLivingEntity();
    public static final IRPGEntity DEFAULT_MOB = new RPGDefaultEntityMob();

    public EntityAttribute.EAFloat getEAMeleeDamage(EntityLivingBase var1);

    public EntityAttribute.EAFloat getEARangeDamage(EntityLivingBase var1);

    public void registerAttributes(Class<? extends EntityLivingBase> var1, RPGEntityData.EntityAttributesSet var2);

    public static class RPGEntityRangeMob
    extends RPGDefaultEntityMob {
        protected float value;

        public RPGEntityRangeMob(float value) {
            this.value = value;
        }

        @Override
        public EntityAttribute.EAFloat getEARangeDamage(EntityLivingBase entity) {
            return EntityAttributes.RANGE_DAMAGE;
        }

        @Override
        public void registerAttributes(Class<? extends EntityLivingBase> entityClass, RPGEntityData.EntityAttributesSet set) {
            super.registerAttributes(entityClass, set);
            set.addEntityAttribute(EntityAttributes.RANGE_DAMAGE, Float.valueOf(this.value));
        }
    }

    public static class RPGCommonEntityMob
    extends RPGDefaultEntityMob {
        protected EntityAttribute.EAFloat meleeAttr;
        protected float meleeValue;

        public RPGCommonEntityMob(EntityAttribute.EAFloat meleeAttr, float meleeValue) {
            this.meleeAttr = meleeAttr;
            this.meleeValue = meleeValue;
        }

        @Override
        public EntityAttribute.EAFloat getEAMeleeDamage(EntityLivingBase entity) {
            return this.meleeAttr;
        }

        @Override
        public void registerAttributes(Class<? extends EntityLivingBase> entityClass, RPGEntityData.EntityAttributesSet set) {
            super.registerAttributes(entityClass, set);
            if (set.attributes.containsKey(EntityAttributes.MELEE_DAMAGE)) {
                set.attributes.remove(EntityAttributes.MELEE_DAMAGE);
            }
            set.addEntityAttribute(this.meleeAttr, Float.valueOf(this.meleeValue));
        }
    }

    public static class RPGDefaultEntityMob
    extends RPGLivingEntity {
        @Override
        public EntityAttribute.EAFloat getEAMeleeDamage(EntityLivingBase entity) {
            return EntityAttributes.MELEE_DAMAGE;
        }

        @Override
        public void registerAttributes(Class<? extends EntityLivingBase> entityClass, RPGEntityData.EntityAttributesSet set) {
            super.registerAttributes(entityClass, set);
            RPGEntityData.registerEntityMob(entityClass, set);
        }
    }

    public static class RPGLivingEntity
    implements IRPGEntity {
        @Override
        public EntityAttribute.EAFloat getEAMeleeDamage(EntityLivingBase entity) {
            return null;
        }

        @Override
        public EntityAttribute.EAFloat getEARangeDamage(EntityLivingBase entity) {
            return null;
        }

        @Override
        public void registerAttributes(Class<? extends EntityLivingBase> entityClass, RPGEntityData.EntityAttributesSet set) {
            RPGEntityData.registerEntityLiving(entityClass, set);
        }
    }
}

