/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashSet;
import java.util.Set;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.api.item.ItemAttribute;
import mixac1.dangerrpg.capability.GemType;
import mixac1.dangerrpg.capability.GemableItem;
import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.client.gui.GuiInfoBook;
import mixac1.dangerrpg.client.gui.GuiInfoBookContent;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.item.IHasBooksInfo;
import mixac1.dangerrpg.item.gem.Gem;
import mixac1.dangerrpg.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class GuiInfoBookContentStack
extends GuiInfoBookContent {
    private ItemStack stack;
    private EntityPlayer player;

    public GuiInfoBookContentStack(Minecraft mc, int width, int height, int top, int size, int left, GuiInfoBook parent, ItemStack stack) {
        super(mc, width, height, top, size, left, mc.field_71466_p.field_78288_b + 2, parent);
        this.stack = stack;
        if (parent.target instanceof EntityPlayer) {
            this.player = (EntityPlayer)parent.target;
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.stack == null) {
            this.addCenteredString(DangerRPG.trans("rpgstr.no_item"));
            return;
        }
        if (this.player == null) {
            return;
        }
        this.addCenteredString(this.stack.func_82833_r().toUpperCase());
        this.addString("");
        boolean isLvlable = LvlableItem.isLvlable(this.stack);
        if (isLvlable) {
            this.addString(String.format("%s: %d\n", ItemAttributes.LEVEL.getDispayName(), (int)ItemAttributes.LEVEL.get(this.stack)));
            this.addString(String.format("%s: %d/%d", ItemAttributes.CURR_EXP.getDispayName(), (int)ItemAttributes.CURR_EXP.get(this.stack), (int)ItemAttributes.MAX_EXP.get(this.stack)));
            if (ItemAttributes.MAX_DURABILITY.hasIt(this.stack)) {
                if (!this.stack.func_77984_f()) {
                    this.addString(String.format("%s: %s", ItemAttributes.DURABILITY.getDispayName(), DangerRPG.trans("rpgstr.unbreakable")));
                } else {
                    this.addString(String.format("%s: %s/%s", ItemAttributes.DURABILITY.getDispayName(), ItemAttributes.DURABILITY.getDispayValue(this.stack, this.player), ItemAttributes.MAX_DURABILITY.getDispayValue(this.stack, this.player)));
                }
            }
            this.addString("");
        }
        if (this.stack.func_77973_b() instanceof IHasBooksInfo) {
            this.addCenteredString(DangerRPG.trans("rpgstr.item_description").toUpperCase());
            this.addString("");
            String s = ((IHasBooksInfo)this.stack.func_77973_b()).getInformationToInfoBook(this.stack, this.player);
            if (s != null) {
                this.addString(s);
                this.addString("");
            }
        }
        if (isLvlable) {
            if (!RPGCapability.lvlItemRegistr.data.get((Object)this.stack.func_77973_b()).isSupported) {
                this.addString(DangerRPG.trans("rpgstr.item_not_supported"));
                this.addString("");
            }
            LinkedHashSet<ItemAttribute> itemAttributes = new LinkedHashSet<ItemAttribute>(LvlableItem.getAttributeValues(this.stack));
            itemAttributes.remove(ItemAttributes.MAX_EXP);
            itemAttributes.remove(ItemAttributes.DURABILITY);
            itemAttributes.remove(ItemAttributes.MAX_DURABILITY);
            if (itemAttributes.size() != 0) {
                this.addCenteredString(DangerRPG.trans("rpgstr.parametres").toUpperCase());
                this.addString("");
                boolean flag = false;
                flag |= this.addAttribute(ItemAttributes.PHISIC_ARMOR, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.MAGIC_ARMOR, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.MELEE_DAMAGE, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.SHOT_DAMAGE, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.SHOT_POWER, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.MELEE_SPEED, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.SHOT_SPEED, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.MANA_COST, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.REACH, itemAttributes);
                if (flag |= this.addAttribute(ItemAttributes.KNOCKBACK, itemAttributes)) {
                    this.addString("");
                    flag = false;
                }
                flag |= this.addAttribute(ItemAttributes.STR_MUL, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.AGI_MUL, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.INT_MUL, itemAttributes);
                if (flag |= this.addAttribute(ItemAttributes.KNBACK_MUL, itemAttributes)) {
                    this.addString("");
                    flag = false;
                }
                flag |= this.addAttribute(ItemAttributes.EFFICIENCY, itemAttributes);
                flag |= this.addAttribute(ItemAttributes.ENCHANTABILITY, itemAttributes);
                for (ItemAttribute iter : itemAttributes) {
                    if (!iter.isVisibleInInfoBook(this.stack)) continue;
                    this.addString(String.format("%s : %s", iter.getDispayName(), iter.getDispayValue(this.stack, this.player)));
                }
                this.addString("");
            }
        }
        if (GemableItem.isGemable(this.stack)) {
            GemType[] gems = GemableItem.getGemTypes(this.stack);
            boolean empty = true;
            if (gems.length != 0) {
                for (GemType gemType : gems) {
                    ItemStack gem = gemType.get(this.stack);
                    if (gem == null || !(gem.func_77973_b() instanceof Gem)) continue;
                    if (empty) {
                        empty = false;
                        this.addCenteredString(DangerRPG.trans("rpgstr.gems").toUpperCase());
                        this.addString("");
                    }
                    this.addString(Utils.toString(DangerRPG.trans("rpgstr.name"), ": ", gem.func_82833_r()));
                    this.addString(Utils.toString(DangerRPG.trans("rpgstr.type"), ": ", ((Gem)gem.func_77973_b()).getGemType().getDispayName()));
                    this.addString("");
                }
            }
        }
    }

    private void addString(String str) {
        this.list.addAll(this.mc.field_71466_p.func_78271_c(str, this.listWidth - 15));
    }

    private void addCenteredString(String str) {
        this.list.add(new CenteredString(str));
    }

    private boolean addAttribute(ItemAttribute attr, Set<ItemAttribute> set) {
        if (attr.hasIt(this.stack) && attr.isVisibleInInfoBook(this.stack)) {
            this.addString(String.format("%s : %s", attr.getDispayName(), attr.getDispayValue(this.stack, this.player)));
            set.remove(attr);
            return true;
        }
        return false;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float par3) {
        super.drawScreen(mouseX, mouseY, par3);
        String s = DangerRPG.trans("rpgstr.item_info");
        this.mc.field_71466_p.func_78261_a(s, this.left + (this.listWidth - this.mc.field_71466_p.func_78256_a(s)) / 2, this.top - this.mc.field_71466_p.field_78288_b - 4, 0xFFFFFF);
    }

    protected void elementClicked(int index, boolean doubleClick) {
    }

    protected boolean isSelected(int index) {
        return false;
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
        Object obj = this.list.get(var1);
        if (obj instanceof CenteredString) {
            ((CenteredString)obj).draw(this.left, var3, 0xFFFFFF);
        } else {
            this.mc.field_71466_p.func_78276_b(obj.toString(), this.left + 5, var3, 0xFFFFFF);
        }
    }

    public class CenteredString {
        String str;

        public CenteredString(String str) {
            this.str = str;
        }

        public void draw(int x, int y, int color) {
            String s = GuiInfoBookContentStack.this.mc.field_71466_p.func_78269_a(this.str, GuiInfoBookContentStack.this.listWidth);
            GuiInfoBookContentStack.this.mc.field_71466_p.func_78276_b(s, x + (GuiInfoBookContentStack.this.listWidth - GuiInfoBookContentStack.this.mc.field_71466_p.func_78256_a(s)) / 2, y, color);
        }
    }
}

