/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.api.entity.EntityAttribute;
import mixac1.dangerrpg.api.event.InitRPGEntityEvent;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.capability.ea.EntityAttributes;
import mixac1.dangerrpg.capability.ea.PlayerAttributes;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.init.RPGNetwork;
import mixac1.dangerrpg.network.MsgSyncConfig;
import mixac1.dangerrpg.network.MsgSyncEntityData;
import mixac1.dangerrpg.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EventHandlerEntity {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing e) {
        if (e.entity instanceof EntityLivingBase && RPGEntityData.isRPGEntity((EntityLivingBase)e.entity)) {
            RPGEntityData.register((EntityLivingBase)e.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        if (e.entity instanceof EntityLivingBase && RPGEntityData.isRPGEntity((EntityLivingBase)e.entity)) {
            if (e.entity.field_70170_p.field_72995_K) {
                RPGNetwork.net.sendToServer((IMessage)new MsgSyncEntityData((EntityLivingBase)e.entity));
            } else {
                RPGEntityData.get((EntityLivingBase)e.entity).serverInit();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone e) {
        if (e.wasDeath) {
            RPGEntityData.get((EntityLivingBase)e.original).rebuildOnDeath();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        RPGEntityData.get((EntityLivingBase)e.original).saveNBTData(nbt);
        RPGEntityData.get((EntityLivingBase)e.entityPlayer).loadNBTData(nbt);
    }

    @SubscribeEvent
    public void onInitRPGEntity(InitRPGEntityEvent e) {
        EntityAttribute.EAFloat attr;
        ChunkCoordinates spawn = e.entity.field_70170_p.func_72861_E();
        double distance = Utils.getDiagonal(e.entity.field_70165_t - (double)spawn.field_71574_a, e.entity.field_70161_v - (double)spawn.field_71573_c);
        int lvl = (int)(distance / 50.0);
        if (EntityAttributes.LVL.hasIt(e.entity)) {
            EntityAttributes.LVL.setValue(lvl + 1, e.entity);
        }
        if (EntityAttributes.HEALTH.hasIt(e.entity)) {
            float health = e.entity.func_110143_aJ() / 10.0f;
            EntityAttributes.HEALTH.addValue(Float.valueOf(health * (float)lvl), e.entity);
        }
        if ((attr = RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)e.entity).rpgComponent.getEAMeleeDamage(e.entity)) != null) {
            attr.addValue(Float.valueOf(((Float)attr.getValue(e.entity)).floatValue() / 10.0f * (float)lvl), e.entity);
        }
        if ((attr = RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)e.entity).rpgComponent.getEARangeDamage(e.entity)) != null) {
            attr.addValue(Float.valueOf(((Float)attr.getValue(e.entity)).floatValue() / 10.0f * (float)lvl), e.entity);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent e) {
        if (e.entityLiving instanceof EntityPlayer) {
            e.entityLiving.field_70181_x += (double)((Float)PlayerAttributes.JUMP_HEIGHT.getValue(e.entityLiving)).floatValue();
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent e) {
        if (e.entityLiving instanceof EntityPlayer) {
            e.distance -= ((Float)PlayerAttributes.STEEL_MUSC.getValue(e.entityLiving)).floatValue();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            DangerRPG.proxy.fireTick(e.side);
            if (!e.player.field_70170_p.field_72995_K) {
                float tmp1;
                if (e.player != null) {
                    float f;
                    tmp1 = ((Float)PlayerAttributes.SPEED_COUNTER.getValue((EntityLivingBase)e.player)).floatValue();
                    if (f > 0.0f) {
                        PlayerAttributes.SPEED_COUNTER.setValue(Float.valueOf(tmp1 - 1.0f), (EntityLivingBase)e.player);
                    }
                }
                if (DangerRPG.proxy.getTick(e.side) % 20 == 0) {
                    float tmp2;
                    float f;
                    tmp1 = ((Float)PlayerAttributes.CURR_MANA.getValue((EntityLivingBase)e.player)).floatValue();
                    if (f < ((Float)PlayerAttributes.MANA.getValue((EntityLivingBase)e.player)).floatValue() && (tmp2 = ((Float)PlayerAttributes.MANA_REGEN.getValue((EntityLivingBase)e.player)).floatValue()) != 0.0f) {
                        PlayerAttributes.CURR_MANA.setValue(Float.valueOf(tmp1 + tmp2), (EntityLivingBase)e.player);
                    }
                }
                if (DangerRPG.proxy.getTick(e.side) % 100 == 0) {
                    e.player.func_70691_i(((Float)PlayerAttributes.HEALTH_REGEN.getValue((EntityLivingBase)e.player)).floatValue());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent e) {
        RPGNetwork.net.sendTo((IMessage)new MsgSyncConfig(), (EntityPlayerMP)e.player);
    }
}

