/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.hook;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import java.util.UUID;
import mixac1.dangerrpg.api.event.ItemStackEvent;
import mixac1.dangerrpg.capability.GemableItem;
import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.ea.PlayerAttributes;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.item.IMaterialSpecial;
import mixac1.dangerrpg.util.RPGHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class HookItems {
    @Hook(injectOnExit=true, targetMethod="<init>")
    public static void ItemStack(ItemStack stack, Item item, int size, int metadata) {
        if (LvlableItem.isLvlable(stack)) {
            LvlableItem.createLvlableItem(stack);
            GemableItem.createGemableItem(stack);
        }
    }

    @Hook(injectOnExit=true, returnCondition=ReturnCondition.ALWAYS)
    public static Multimap getAttributeModifiers(Item item, ItemStack stack, @Hook.ReturnValue Multimap returnValue) {
        if (LvlableItem.isLvlable(stack)) {
            if (ItemAttributes.MELEE_DAMAGE.hasIt(stack)) {
                returnValue.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                returnValue.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"), "Weapon modifier", (double)ItemAttributes.MELEE_DAMAGE.get(stack), 0));
            }
            MinecraftForge.EVENT_BUS.post((Event)new ItemStackEvent.AddAttributeModifiers(stack, returnValue));
        }
        return returnValue;
    }

    @Hook(injectOnExit=true, returnCondition=ReturnCondition.ALWAYS)
    public static int getItemEnchantability(Item item, ItemStack stack, @Hook.ReturnValue int returnValue) {
        if (LvlableItem.isLvlable(stack) && ItemAttributes.ENCHANTABILITY.hasIt(stack)) {
            return (int)ItemAttributes.ENCHANTABILITY.get(stack);
        }
        return returnValue;
    }

    @Hook(injectOnExit=true, returnCondition=ReturnCondition.ALWAYS)
    public static int getMaxDamage(ItemStack stack, @Hook.ReturnValue int returnValue) {
        if (LvlableItem.isLvlable(stack) && returnValue > 0 && ItemAttributes.MAX_DURABILITY.hasIt(stack)) {
            return (int)ItemAttributes.MAX_DURABILITY.get(stack);
        }
        return returnValue;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static boolean onEntitySwing(Item item, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            return ((Float)PlayerAttributes.SPEED_COUNTER.getValue(entity)).floatValue() != 0.0f;
        }
        return false;
    }

    @Hook(injectOnExit=true, returnCondition=ReturnCondition.ALWAYS)
    public static EnumRarity getRarity(Item item, ItemStack stack, @Hook.ReturnValue EnumRarity returnValue) {
        IMaterialSpecial mat;
        if (LvlableItem.isLvlable(stack) && (returnValue == EnumRarity.common || stack.func_77948_v() && returnValue == EnumRarity.rare) && (mat = RPGHelper.getMaterialSpecial(stack)) != null) {
            return mat.getItemRarity();
        }
        if (returnValue == EnumRarity.uncommon) {
            return RPGOther.RPGItemRarity.uncommon;
        }
        if (returnValue == EnumRarity.rare) {
            return RPGOther.RPGItemRarity.rare;
        }
        if (returnValue == EnumRarity.epic) {
            return RPGOther.RPGItemRarity.epic;
        }
        return returnValue;
    }
}

