/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.init;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.api.RPGRegister;
import mixac1.dangerrpg.api.entity.IRPGEntity;
import mixac1.dangerrpg.api.item.ILvlableItem;
import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.capability.ea.EntityAttributes;
import mixac1.dangerrpg.init.RPGConfig;
import mixac1.dangerrpg.util.Utils;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public abstract class RPGCapability {
    public static LvlItemRegistr lvlItemRegistr = new LvlItemRegistr();
    public static RPGEntityRegistr rpgEntityRegistr = new RPGEntityRegistr();

    public static void preLoad(FMLPostInitializationEvent e) {
        RPGCapability.registerDefaultLvlableItems();
        RPGCapability.registerDefaultRPGEntities();
    }

    public static void load(FMLPostInitializationEvent e) {
        RPGCapability.loadEntities();
        RPGCapability.loadItems();
        RPGCapability.lvlItemRegistr.createCloneSet();
        RPGCapability.rpgEntityRegistr.createCloneSet();
    }

    private static void registerDefaultLvlableItems() {
        for (Item item : GameData.getItemRegistry()) {
            if (!(item instanceof ILvlableItem)) continue;
            RPGRegister.registerLvlableItem(item, (ILvlableItem)item);
        }
        RPGRegister.registerLvlableItem(Items.field_151017_I, ILvlableItem.DEFAULT_SWORD);
        RPGRegister.registerLvlableItem(Items.field_151018_J, ILvlableItem.DEFAULT_SWORD);
        RPGRegister.registerLvlableItem(Items.field_151019_K, ILvlableItem.DEFAULT_SWORD);
        RPGRegister.registerLvlableItem(Items.field_151013_M, ILvlableItem.DEFAULT_SWORD);
        RPGRegister.registerLvlableItem(Items.field_151012_L, ILvlableItem.DEFAULT_SWORD);
        RPGRegister.registerLvlableItem(Items.field_151053_p, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151049_t, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151036_c, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151006_E, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151056_x, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151039_o, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151050_s, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151035_b, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151005_D, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151046_w, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151038_n, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151051_r, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151037_a, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151011_C, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151047_v, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151017_I, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151018_J, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151019_K, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151013_M, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem(Items.field_151012_L, ILvlableItem.DEFAULT_TOOL);
        RPGRegister.registerLvlableItem((Item)Items.field_151021_T, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151027_R, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151024_Q, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151026_S, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151029_X, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151023_V, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151020_U, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151022_W, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151167_ab, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151030_Z, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151028_Y, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151165_aa, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151151_aj, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151171_ah, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151169_ag, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151149_ai, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151175_af, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151163_ad, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151161_ac, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151173_ae, ILvlableItem.DEFAULT_ARMOR);
        RPGRegister.registerLvlableItem((Item)Items.field_151031_f, ILvlableItem.DEFAULT_BOW);
    }

    private static void registerDefaultRPGEntities() {
        RPGRegister.registerRPGEntity(EntityBlaze.class, new IRPGEntity.RPGEntityRangeMob(5.0f));
        RPGRegister.registerRPGEntity(EntitySkeleton.class, new IRPGEntity.RPGEntityRangeMob(2.0f));
        RPGRegister.registerRPGEntity(EntityGhast.class, new IRPGEntity.RPGEntityRangeMob(6.0f));
        RPGRegister.registerRPGEntity(EntityWither.class, new IRPGEntity.RPGEntityRangeMob(8.0f));
        RPGRegister.registerRPGEntity(EntitySlime.class, new IRPGEntity.RPGCommonEntityMob(EntityAttributes.MELEE_DAMAGE_SLIME, 0.0f));
        RPGRegister.registerRPGEntity(EntityMagmaCube.class, new IRPGEntity.RPGCommonEntityMob(EntityAttributes.MELEE_DAMAGE_SLIME, 2.0f));
        RPGRegister.registerRPGEntity(EntityWolf.class, new IRPGEntity.RPGCommonEntityMob(EntityAttributes.MELEE_DAMAGE_STAB, 3.0f));
        RPGRegister.registerRPGEntity(EntityIronGolem.class, new IRPGEntity.RPGCommonEntityMob(EntityAttributes.MELEE_DAMAGE_STAB, 14.0f));
        RPGRegister.registerRPGEntity(EntityDragon.class, new IRPGEntity.RPGCommonEntityMob(EntityAttributes.MELEE_DAMAGE_STAB, 10.0f));
    }

    private static void loadEntities() {
        for (Map.Entry entry : EntityList.field_75626_c.entrySet()) {
            Map.Entry entry2 = entry;
            if (entry2.getKey() == null || entry2.getValue() == null) continue;
            RPGEntityData.registerEntity((Class)entry2.getKey());
        }
        RPGEntityData.registerEntity(EntityPlayer.class);
        for (Map.Entry<Object, Object> entry : RPGCapability.rpgEntityRegistr.data.entrySet()) {
            RPGEntityData.registerEntityDefault((Class)entry.getKey(), (RPGEntityData.EntityAttributesSet)entry.getValue());
            ((RPGEntityData.EntityAttributesSet)entry.getValue()).rpgComponent.registerAttributes((Class)entry.getKey(), (RPGEntityData.EntityAttributesSet)entry.getValue());
            if (!RPGConfig.entityAllEntityRPG && !RPGConfig.entitySupportedRPGEntities.contains(EntityList.field_75626_c.get(entry.getKey()))) continue;
            RPGCapability.rpgEntityRegistr.registr.add((Class<? extends EntityLivingBase>)entry.getKey());
            DangerRPG.infoLog(Utils.toString("Register rpg entity: ", EntityList.field_75626_c.get(entry.getKey())));
        }
        RPGCapability.rpgEntityRegistr.registr.add(EntityPlayer.class);
    }

    private static void loadItems() {
        Iterator iterator = GameData.getItemRegistry().iterator();
        while (iterator.hasNext()) {
            LvlableItem.registerLvlableItem((Item)iterator.next());
        }
        for (Map.Entry<Item, LvlableItem.ItemAttributesMap> data : RPGCapability.lvlItemRegistr.data.entrySet()) {
            LvlableItem.registerParamsDefault(data.getKey(), data.getValue());
            data.getValue().lvlComponent.registerAttributes(data.getKey(), data.getValue());
            if (!RPGConfig.itemAllItemsLvlable && !RPGConfig.itemSupportedLvlItems.contains(data.getKey().field_77774_bZ)) continue;
            RPGCapability.lvlItemRegistr.registr.add(data.getKey());
            DangerRPG.infoLog(Utils.toString("Register lvlable item: ", data.getKey().field_77774_bZ, " (mod supported: ", String.valueOf(data.getValue().isSupported), ")"));
        }
    }

    public static class RPGEntityRegistr {
        public Set<Class<? extends EntityLivingBase>> registr = new HashSet<Class<? extends EntityLivingBase>>();
        public HashMap<Class<? extends EntityLivingBase>, RPGEntityData.EntityAttributesSet> data = new HashMap();
        private Set<Class<? extends EntityLivingBase>> copy;

        private void createCloneSet() {
            this.copy = new HashSet<Class<? extends EntityLivingBase>>(this.registr);
        }

        public Set<Class<? extends EntityLivingBase>> getCloneSet() {
            return this.copy;
        }

        public boolean isRegistered(EntityLivingBase entity) {
            return entity instanceof EntityPlayer ? RPGCapability.rpgEntityRegistr.registr.contains(EntityPlayer.class) : RPGCapability.rpgEntityRegistr.registr.contains(entity.getClass());
        }

        public RPGEntityData.EntityAttributesSet getAttributesSet(EntityLivingBase entity) {
            return entity instanceof EntityPlayer ? RPGCapability.rpgEntityRegistr.data.get(EntityPlayer.class) : RPGCapability.rpgEntityRegistr.data.get(entity.getClass());
        }

        public void setAttributesSet(EntityLivingBase entity, RPGEntityData.EntityAttributesSet set) {
            this.data.put(entity instanceof EntityPlayer ? EntityPlayer.class : entity.getClass(), set);
        }
    }

    public static class LvlItemRegistr {
        public Set<Item> registr = new HashSet<Item>();
        public HashMap<Item, LvlableItem.ItemAttributesMap> data = new HashMap();
        private Set<Item> copy;

        private void createCloneSet() {
            this.copy = new HashSet<Item>(this.registr);
        }

        public Set<Item> getCloneSet() {
            return this.copy;
        }
    }
}

