/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.init;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.util.RPGHelper;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class RPGConfig {
    public static Configuration config;
    public static File dir;
    public static boolean mainEnableModGui;
    public static int mainDamageForArmorBar;
    public static boolean mainEnableInfoLog;
    public static boolean mainShowShapedRecipe;
    public static int playerLoseLvlCount;
    public static boolean entityAllEntityRPG;
    public static HashSet<String> entitySupportedRPGEntities;
    public static boolean itemAllItemsLvlable;
    public static boolean itemCanUpInTable;
    public static int itemMaxLevel;
    public static int itemStartMaxExp;
    public static float itemExpMul;
    public static HashSet<String> itemSupportedLvlItems;

    public static void load(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile(), "1.0.3", true);
        config.load();
        dir = new File((File)FMLInjectionData.data()[6], "config/".concat("dangerrpg"));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                dir.delete();
            }
        } else {
            dir.mkdir();
        }
        RPGConfig.initMainCategory();
        RPGConfig.initPlayerCategory();
        RPGConfig.initEntityCategory();
        RPGConfig.initItemCategory();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void preLoadCapability(FMLPostInitializationEvent e) {
        ArrayList<String> names = RPGHelper.getItemNames(RPGCapability.lvlItemRegistr.data.keySet(), true);
        Property prop = RPGConfig.getPropertyStrings("Supported Lvl items", "itemSupportedLvlItems", names.toArray(new String[names.size()]), "Set supported lvlable items (activated if 'itemAllItemsLvlable' is false)", false);
        if (!itemAllItemsLvlable) {
            itemSupportedLvlItems = new HashSet<String>(Arrays.asList(prop.getStringList()));
        }
        prop = RPGConfig.getPropertyStrings("Supported RPG entities", "entitySupportedRPGEntities", new String[0], "Set supported RPGable entities (activated if 'entityAllEntityRPG' is false)", false);
        if (!entityAllEntityRPG) {
            entitySupportedRPGEntities = new HashSet<String>(Arrays.asList(prop.getStringList()));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postLoadCapability(FMLPostInitializationEvent e) {
        ArrayList<String> names = RPGHelper.getItemNames(RPGCapability.lvlItemRegistr.registr, true);
        RPGConfig.getPropertyStrings("Supported Lvl items", "itemSupportedLvlItems", names.toArray(new String[names.size()]), null, true);
        names = RPGHelper.getEntityNames(RPGCapability.rpgEntityRegistr.registr, true);
        RPGConfig.getPropertyStrings("Supported RPG entities", "entitySupportedRPGEntities", names.toArray(new String[names.size()]), null, true);
        if (config.hasChanged()) {
            config.save();
        }
        PrintWriter file = RPGConfig.createPrintWriter("AllEntityNames.txt");
        names = RPGHelper.getEntityNames(RPGCapability.rpgEntityRegistr.data.keySet(), true);
        for (String str : names) {
            file.write(str.concat("\n"));
        }
        file.flush();
        file.close();
        file = RPGConfig.createPrintWriter("AllItemNames.txt");
        names = RPGHelper.getItemNames(RPGCapability.lvlItemRegistr.data.keySet(), true);
        for (String str : names) {
            file.write(str.concat("\n"));
        }
        file.flush();
        file.close();
    }

    private static void initMainCategory() {
        ConfigCategory cat = config.getCategory("Main Category");
        cat.setRequiresMcRestart(true);
        cat.setShowInGui(true);
        mainEnableModGui = RPGConfig.getBoolean(cat.getName(), "mainEnableModGui", true, "Enable Modify Gui");
        mainEnableInfoLog = RPGConfig.getBoolean(cat.getName(), "mainEnableInfoLog", true, "Enable writing info message to log");
        mainShowShapedRecipe = RPGConfig.getBoolean(cat.getName(), "mainShowShapedRecipe", false, "Show default shape recipes in Shaped and Shapeless Crafting(need NEI)");
        mainDamageForArmorBar = RPGConfig.getInteger(cat.getName(), "mainDamageForArmorBar", 25, "Damage count for calculate resistance in armor bar");
    }

    private static void initPlayerCategory() {
        ConfigCategory cat = config.getCategory("Player Category");
        cat.setRequiresMcRestart(true);
        cat.setShowInGui(true);
        playerLoseLvlCount = RPGConfig.getInteger(cat.getName(), "playerLoseLvlCount", 3, "Set number of lost points of level when player die");
    }

    private static void initEntityCategory() {
        ConfigCategory cat = config.getCategory("Entity Category");
        cat.setRequiresMcRestart(true);
        cat.setShowInGui(true);
        entityAllEntityRPG = RPGConfig.getBoolean(cat.getName(), "entityAllEntityRPG", true, "Are all entity RPGable?");
    }

    private static void initItemCategory() {
        ConfigCategory cat = config.getCategory("Item Category");
        cat.setRequiresMcRestart(true);
        cat.setShowInGui(true);
        itemAllItemsLvlable = RPGConfig.getBoolean(cat.getName(), "itemAllItemsLvlable", false, "Are all weapons, tools levelable?");
        itemCanUpInTable = RPGConfig.getBoolean(cat.getName(), "itemCanUpInTable", true, "Can items upgrade in lvlup table without creative mode?");
        itemMaxLevel = RPGConfig.getInteger(cat.getName(), "itemMaxLevel", 100, "Set items max level");
        itemStartMaxExp = RPGConfig.getInteger(cat.getName(), "itemStartMaxExp", 100, "Set items start needed expirience");
        itemExpMul = (float)RPGConfig.getDouble(cat.getName(), "itemExpMul", 1.15, "Set items expirience multiplier");
    }

    public static Property getPropertyStrings(String category, String field, String[] defValue, String comment, boolean needClear) {
        ConfigCategory cat = config.getCategory(category);
        if (needClear) {
            cat.clear();
        }
        Property prop = config.get(category, field, defValue);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop;
    }

    private static int getInteger(String category, String field, int defValue, String comment) {
        Property prop = config.get(category, field, defValue);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getInt(defValue);
    }

    private static double getDouble(String category, String field, double defValue, String comment) {
        Property prop = config.get(category, field, defValue);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getDouble(defValue);
    }

    private static boolean getBoolean(String category, String field, boolean defValue, String comment) {
        Property prop = config.get(category, field, defValue);
        if (comment != null) {
            prop.comment = comment;
        }
        return prop.getBoolean(defValue);
    }

    private static File createFile(String path) {
        File file = new File(dir, path);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static PrintWriter createPrintWriter(String path) {
        try {
            return new PrintWriter(RPGConfig.createFile(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        entitySupportedRPGEntities = new HashSet();
        itemSupportedLvlItems = new HashSet();
    }
}

