/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import mixac1.dangerrpg.world.explosion.ExplosionEffect;
import org.apache.commons.lang3.SerializationUtils;

public class MsgExplosion
implements IMessage {
    int effectId;
    double x;
    double y;
    double z;
    double size;
    Object[] meta;

    public MsgExplosion() {
    }

    public MsgExplosion(int effectId, double x, double y, double z, double size, Object[] meta) {
        this.effectId = effectId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.meta = meta;
    }

    public void fromBytes(ByteBuf buf) {
        this.effectId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.size = buf.readDouble();
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        this.meta = (Object[])SerializationUtils.deserialize((byte[])bytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.effectId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.size);
        byte[] bytes = SerializationUtils.serialize((Serializable)this.meta);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static class Handler
    implements IMessageHandler<MsgExplosion, IMessage> {
        public IMessage onMessage(MsgExplosion msg, MessageContext ctx) {
            ExplosionEffect.list.get(msg.effectId).doEffect(msg.x, msg.y, msg.z, msg.size, msg.meta);
            return null;
        }
    }
}

