/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.init.RPGNetwork;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MsgSyncEntityData
implements IMessage {
    public NBTTagCompound data;
    public int entityId;
    public boolean isPlayer;

    public MsgSyncEntityData() {
    }

    public MsgSyncEntityData(EntityLivingBase entity) {
        this.entityId = entity.func_145782_y();
        this.isPlayer = entity instanceof EntityPlayer;
    }

    public MsgSyncEntityData(EntityLivingBase entity, RPGEntityData entityData) {
        this(entity);
        this.data = new NBTTagCompound();
        entityData.saveNBTData(this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.entityId = buf.readInt();
        this.isPlayer = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isPlayer);
    }

    public static class HandlerServer
    extends Handler {
        public IMessage onMessage(MsgSyncEntityData msg, MessageContext ctx) {
            this.init(msg, ctx);
            if (this.data != null) {
                RPGNetwork.net.sendTo((IMessage)new MsgSyncEntityData(this.target, this.data), (EntityPlayerMP)this.player);
            }
            return null;
        }
    }

    public static class HandlerClient
    extends Handler {
        public IMessage onMessage(MsgSyncEntityData msg, MessageContext ctx) {
            this.init(msg, ctx);
            if (this.data != null) {
                this.data.loadNBTData(msg.data);
            }
            return null;
        }
    }

    public static abstract class Handler
    implements IMessageHandler<MsgSyncEntityData, IMessage> {
        protected EntityLivingBase target;
        protected EntityPlayer player;
        protected RPGEntityData data;

        protected void init(MsgSyncEntityData msg, MessageContext ctx) {
            this.target = (EntityLivingBase)DangerRPG.proxy.getEntityByID(ctx, msg.entityId);
            this.player = DangerRPG.proxy.getPlayer(ctx);
            this.data = null;
            if (this.target == null) {
                if (!msg.isPlayer) {
                    return;
                }
                this.target = this.player;
            }
            this.data = RPGEntityData.get(this.target);
        }
    }
}

