/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.util;

import java.util.Collections;
import java.util.Random;

public abstract class Utils {
    public static Random rand = new Random();

    public static <T> Iterable<T> safe(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    public static float alignment(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double invert(double value) {
        return -value;
    }

    public static double invert(double value, boolean isInvert) {
        return isInvert ? Utils.invert(value) : value;
    }

    public static String toString(Object ... objs) {
        StringBuilder buf = new StringBuilder();
        for (Object obj : objs) {
            buf.append(obj != null ? obj.toString() : "null");
        }
        return buf.toString();
    }

    public static double getDiagonal(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double getDiagonal(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static int randInt(Random rand, int bound, boolean isAroundZero) {
        if (isAroundZero) {
            return rand.nextInt(bound * 2) - bound;
        }
        return rand.nextInt(bound);
    }

    public static int randInt(int bound, boolean isAroundZero) {
        return Utils.randInt(rand, bound, isAroundZero);
    }

    public static double randDouble(Random rand, double bound, int accuracy, boolean isAroundZero) {
        accuracy = (int)Math.pow(10.0, accuracy);
        return Utils.randInt(rand, (int)((double)accuracy * bound), isAroundZero) / accuracy;
    }

    public static double randDouble(double bound, int accuracy, boolean isAroundZero) {
        return Utils.randDouble(rand, bound, accuracy, isAroundZero);
    }
}

