/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.minecraft;

import cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import gloomyfolken.hooklib.asm.AsmHook;
import gloomyfolken.hooklib.asm.HookClassTransformer;
import gloomyfolken.hooklib.asm.ReadClassHelper;
import gloomyfolken.hooklib.minecraft.HookLibPlugin;
import gloomyfolken.hooklib.minecraft.MinecraftClassTransformer;
import gloomyfolken.hooklib.minecraft.PrimaryClassTransformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class HookLoader
implements IFMLLoadingPlugin {
    private static DeobfuscationTransformer deobfuscationTransformer;

    public static HookClassTransformer getTransformer() {
        return PrimaryClassTransformer.instance.registeredSecondTransformer ? MinecraftClassTransformer.instance : PrimaryClassTransformer.instance;
    }

    public static void registerHook(AsmHook hook) {
        HookLoader.getTransformer().registerHook(hook);
    }

    public static void registerHookContainer(String className) {
        try {
            InputStream classData = ReadClassHelper.getClassData(className);
            byte[] bytes = IOUtils.toByteArray((InputStream)classData);
            classData.close();
            if (deobfuscationTransformer != null) {
                bytes = deobfuscationTransformer.transform(className, className, bytes);
            }
            ByteArrayInputStream newData = new ByteArrayInputStream(bytes);
            HookLoader.getTransformer().registerHookContainer(newData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        this.registerHooks();
    }

    protected abstract void registerHooks();

    static {
        if (HookLibPlugin.getObfuscated()) {
            deobfuscationTransformer = new DeobfuscationTransformer();
        }
    }
}

