/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.api.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.api.entity.LvlEAProvider;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.init.RPGNetwork;
import mixac1.dangerrpg.network.MsgSyncEA;
import mixac1.dangerrpg.util.ITypeProvider;
import mixac1.dangerrpg.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EntityAttribute<Type> {
    public final String name;
    public final int hash;
    public final ITypeProvider<? super Type> typeProvider;

    public EntityAttribute(ITypeProvider<? super Type> typeProvider, String name) {
        this.name = name;
        this.hash = name.hashCode();
        this.typeProvider = typeProvider;
    }

    public void init(EntityLivingBase entity) {
        this.getEntityData((EntityLivingBase)entity).attributeMap.put(this.hash, new RPGEntityData.TypeStub<Type>(this.typeProvider.getEmpty()));
        LvlEAProvider lvlProvider = this.getLvlProvider(entity);
        if (lvlProvider != null) {
            lvlProvider.init(entity);
        }
    }

    public void serverInit(EntityLivingBase entity) {
        this.setValueRaw(RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)entity).attributes.get((Object)this).startValue, entity);
    }

    public LvlEAProvider getLvlProvider(EntityLivingBase entity) {
        return RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)entity).attributes.get((Object)this).lvlProvider;
    }

    public boolean hasIt(EntityLivingBase entity) {
        return RPGCapability.rpgEntityRegistr.isRegistered(entity) && RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)entity).attributes.containsKey(this);
    }

    public boolean isValid(Type value) {
        return this.typeProvider.isValid(value);
    }

    public boolean isValid(Type value, EntityLivingBase entity) {
        return this.isValid(value);
    }

    public RPGEntityData getEntityData(EntityLivingBase entity) {
        return RPGEntityData.get(entity);
    }

    @Deprecated
    public Type getValueRaw(EntityLivingBase entity) {
        return this.getEntityData((EntityLivingBase)entity).attributeMap.get((Object)Integer.valueOf((int)this.hash)).value;
    }

    @Deprecated
    public boolean setValueRaw(Type value, EntityLivingBase entity) {
        if (!value.equals(this.getValueRaw(entity))) {
            this.getEntityData((EntityLivingBase)entity).attributeMap.get((Object)Integer.valueOf((int)this.hash)).value = value;
            return true;
        }
        return false;
    }

    public Type getValue(EntityLivingBase entity) {
        Type value = this.getValueRaw(entity);
        if (!this.isValid(value, entity)) {
            this.serverInit(entity);
            value = this.getValueRaw(entity);
        }
        return value;
    }

    public void setValue(Type value, EntityLivingBase entity) {
        if (this.isValid(value, entity) && this.setValueRaw(value, entity)) {
            this.sync(entity);
        }
    }

    public void addValue(Type value, EntityLivingBase entity) {
        this.setValue(this.typeProvider.concat(this.getValue(entity), value), entity);
    }

    public void sync(EntityLivingBase entity) {
        if (RPGEntityData.isServerSide(entity)) {
            RPGNetwork.net.sendToAll((IMessage)new MsgSyncEA(this, entity));
        }
    }

    public void toNBT(NBTTagCompound nbt, EntityLivingBase entity) {
        NBTTagCompound tmp = new NBTTagCompound();
        this.typeProvider.toNBT(this.getValue(entity), "value", tmp);
        LvlEAProvider lvlProvider = this.getLvlProvider(entity);
        if (lvlProvider != null) {
            tmp.func_74768_a("lvl", lvlProvider.getLvl(entity));
        }
        nbt.func_74782_a(this.name, (NBTBase)tmp);
    }

    public void fromNBT(NBTTagCompound nbt, EntityLivingBase entity) {
        NBTTagCompound tmp = (NBTTagCompound)nbt.func_74781_a(this.name);
        if (tmp != null) {
            this.setValueRaw(this.typeProvider.fromNBT("value", tmp), entity);
            LvlEAProvider lvlProvider = this.getLvlProvider(entity);
            if (lvlProvider != null) {
                lvlProvider.setLvl(tmp.func_74762_e("lvl"), entity);
            }
        } else {
            this.serverInit(entity);
        }
    }

    public String getDisplayValue(EntityLivingBase entity) {
        return this.typeProvider.toString(this.getValue(entity));
    }

    public String getDisplayName() {
        return DangerRPG.trans("ea.".concat(this.name));
    }

    public String getInfo() {
        return DangerRPG.trans(Utils.toString("ea.", this.name, ".info"));
    }

    public final int hashCode() {
        return this.hash;
    }

    public static class EAItemStack
    extends EntityAttribute<ItemStack> {
        public EAItemStack(String name) {
            super(ITypeProvider.ITEM_STACK, name);
        }
    }

    public static class EANBT
    extends EntityAttribute<NBTTagCompound> {
        public EANBT(String name) {
            super(ITypeProvider.NBT_TAG, name);
        }
    }

    public static class EAString
    extends EntityAttribute<String> {
        public EAString(String name) {
            super(ITypeProvider.STRING, name);
        }
    }

    public static class EAFloat
    extends EntityAttribute<Float> {
        public EAFloat(String name) {
            super(ITypeProvider.FLOAT, name);
        }
    }

    public static class EAInteger
    extends EntityAttribute<Integer> {
        public EAInteger(String name) {
            super(ITypeProvider.INTEGER, name);
        }
    }

    public static class EABoolean
    extends EntityAttribute<Boolean> {
        public EABoolean(String name) {
            super(ITypeProvider.BOOLEAN, name);
        }
    }
}

