/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.api.item;

import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.entity.projectile.EntityArrowRPG;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.item.RPGArmorMaterial;
import mixac1.dangerrpg.item.RPGItemComponent;
import mixac1.dangerrpg.item.RPGToolMaterial;
import mixac1.dangerrpg.util.RPGCommonHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public interface ILvlableItem {
    public static final ILvlableItem DEFAULT_ITEM = new ILvlableItem(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
        }

        @Override
        public RPGItemComponent getItemComponent(Item item) {
            return null;
        }
    };
    public static final ILvlableItem DEFAULT_ITEM_MOD = new ILvlableItemMod(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
            LvlableItem.registerParamsItemMod(item, map);
        }

        @Override
        public RPGItemComponent.RPGICWithoutTM getItemComponent(Item item) {
            return null;
        }
    };
    public static final ILvlableItemTool DEFAULT_SWORD = new ILvlableItemTool(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
            LvlableItem.registerParamsItemSword(item, map);
        }

        @Override
        public RPGItemComponent.RPGToolComponent getItemComponent(Item item) {
            return RPGItemComponent.SWORD;
        }

        @Override
        public RPGToolMaterial getToolMaterial(Item item) {
            return RPGToolMaterial.toolMaterialHook(((ItemSword)item).field_150933_b);
        }
    };
    public static final ILvlableItemTool DEFAULT_TOOL = new ILvlableItemTool(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
            LvlableItem.registerParamsItemTool(item, map);
        }

        @Override
        public RPGItemComponent.RPGToolComponent getItemComponent(Item item) {
            if (item instanceof ItemAxe) {
                return RPGItemComponent.AXE;
            }
            if (item instanceof ItemHoe) {
                return RPGItemComponent.HOE;
            }
            if (item instanceof ItemSpade) {
                return RPGItemComponent.SHOVEL;
            }
            if (item instanceof ItemPickaxe) {
                return RPGItemComponent.PICKAXE;
            }
            return RPGItemComponent.AXE;
        }

        @Override
        public RPGToolMaterial getToolMaterial(Item item) {
            if (item instanceof ItemTool) {
                return RPGToolMaterial.toolMaterialHook(((ItemTool)item).func_150913_i());
            }
            if (item instanceof ItemHoe) {
                return RPGToolMaterial.toolMaterialHook(((ItemHoe)item).field_77843_a);
            }
            return null;
        }
    };
    public static final ILvlableItemArmor DEFAULT_ARMOR = new ILvlableItemArmor(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
            LvlableItem.registerParamsItemArmor(item, map);
        }

        @Override
        public RPGItemComponent.RPGArmorComponent getItemComponent(Item item) {
            return RPGItemComponent.RPGArmorComponent.ARMOR;
        }

        @Override
        public RPGArmorMaterial getArmorMaterial(Item item) {
            return RPGArmorMaterial.armorMaterialHook(((ItemArmor)item).func_82812_d());
        }
    };
    public static final ILvlableItemBow DEFAULT_BOW = new ILvlableItemBow(){

        @Override
        public void registerAttributes(Item item, LvlableItem.ItemAttributesMap map) {
            LvlableItem.registerParamsItemBow(item, map);
        }

        @Override
        public RPGItemComponent.RPGBowComponent getItemComponent(Item item) {
            return RPGItemComponent.BOW;
        }

        @Override
        public RPGToolMaterial getToolMaterial(Item item) {
            return null;
        }

        @Override
        public void onStoppedUsing(ItemStack stack, World world, EntityPlayer player, int useDuration) {
            boolean flag;
            boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
            if (flag || player.field_71071_by.func_146028_b(Items.field_151032_g)) {
                float power = RPGCommonHelper.getUsePower(player, stack, useDuration, 20.0f, 0.3f);
                if (power < 0.0f) {
                    return;
                }
                float powerMul = ItemAttributes.SHOT_POWER.hasIt(stack) ? ItemAttributes.SHOT_POWER.get(stack, player) : 1.0f;
                EntityArrowRPG entity = new EntityArrowRPG(world, (EntityLivingBase)player, power * powerMul, 1.0f);
                entity.phisicDamage = ItemAttributes.SHOT_DAMAGE.hasIt(stack) ? ItemAttributes.SHOT_DAMAGE.get(stack, player) : 2.0f;
                int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
                if (k > 0) {
                    entity.phisicDamage += (float)k * 0.5f + 0.5f;
                }
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                    entity.func_70015_d(100);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
                world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (RPGOther.rand.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                if (flag) {
                    entity.pickupMode = 2;
                } else {
                    player.field_71071_by.func_146026_a(Items.field_151032_g);
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)entity);
                }
            }
        }
    };

    public void registerAttributes(Item var1, LvlableItem.ItemAttributesMap var2);

    public RPGItemComponent getItemComponent(Item var1);

    public static interface ILvlableItemBow
    extends ILvlableItemGun {
        public void onStoppedUsing(ItemStack var1, World var2, EntityPlayer var3, int var4);

        @Override
        public RPGItemComponent.RPGBowComponent getItemComponent(Item var1);
    }

    public static interface ILvlableItemStaff
    extends ILvlableItemGun {
        @Override
        public RPGItemComponent.RPGStaffComponent getItemComponent(Item var1);
    }

    public static interface ILvlableItemGun
    extends ILvlableItemTool {
        @Override
        public RPGItemComponent.RPGGunComponent getItemComponent(Item var1);
    }

    public static interface ILvlableItemArmor
    extends ILvlableItem {
        @Override
        public RPGItemComponent.RPGArmorComponent getItemComponent(Item var1);

        public RPGArmorMaterial getArmorMaterial(Item var1);
    }

    public static interface ILvlableItemTool
    extends ILvlableItemMod {
        @Override
        public RPGItemComponent.RPGToolComponent getItemComponent(Item var1);

        public RPGToolMaterial getToolMaterial(Item var1);
    }

    public static interface ILvlableItemMod
    extends ILvlableItem {
    }
}

