/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.capability;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mixac1.dangerrpg.api.item.IGemableItem;
import mixac1.dangerrpg.capability.GemType;
import mixac1.dangerrpg.item.gem.Gem;
import mixac1.dangerrpg.item.gem.GemWeaponSpecialAttack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public abstract class GemableItem {
    public static final String IS_GEMABLE = "rpg_gemable";

    public static boolean isGemable(ItemStack stack) {
        return stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b(IS_GEMABLE);
    }

    public static boolean createGemableItem(ItemStack stack) {
        GemType[] gems;
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a(IS_GEMABLE, true);
        for (GemType iterator : gems = GemableItem.getGemTypes(stack)) {
            iterator.attach(null, stack);
        }
        return true;
    }

    public static GemType[] getGemTypes(ItemStack stack) {
        IGemableItem type = stack.func_77973_b() instanceof IGemableItem ? (IGemableItem)stack.func_77973_b() : IGemableItem.DEFAULT;
        return type.getGemTypes(stack);
    }

    public static void onItemUseSpecial(ItemStack stack, World world, EntityPlayer player) {
        ItemStack gem;
        if (!world.field_72995_K && GemType.GEM_SPECIAL_ATTACK.hasIt(stack) && (gem = GemType.GEM_SPECIAL_ATTACK.get(stack)) != null && gem.func_77973_b() instanceof GemWeaponSpecialAttack) {
            ((GemWeaponSpecialAttack)gem.func_77973_b()).upgrade(stack, world, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (GemableItem.isGemable(stack)) {
            GemType[] gems;
            for (GemType iterator : gems = GemableItem.getGemTypes(stack)) {
                ItemStack gemStack = iterator.get(stack);
                if (gemStack == null || !(gemStack.func_77973_b() instanceof Gem)) continue;
                list.add("");
                list.add(EnumChatFormatting.GRAY + ((Gem)gemStack.func_77973_b()).getGemType().getDispayName() + ": " + EnumChatFormatting.RED + gemStack.func_82833_r());
            }
        }
    }
}

