/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.capability;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mixac1.dangerrpg.api.event.RegIAEvent;
import mixac1.dangerrpg.api.event.UpEquipmentEvent;
import mixac1.dangerrpg.api.item.IADynamic;
import mixac1.dangerrpg.api.item.IAStatic;
import mixac1.dangerrpg.api.item.ILvlableItem;
import mixac1.dangerrpg.api.item.ItemAttribute;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.hook.HookArmorSystem;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.init.RPGConfig;
import mixac1.dangerrpg.item.RPGArmorMaterial;
import mixac1.dangerrpg.item.RPGItemComponent;
import mixac1.dangerrpg.item.RPGToolMaterial;
import mixac1.dangerrpg.util.IMultiplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public abstract class LvlableItem {
    public static final String IS_LVLABLE = "rpg_lvlable";
    public static final IMultiplier<Float> EXP_MUL = new IMultiplier<Float>(){

        @Override
        public Float up(Float value, Object ... meta) {
            return Float.valueOf(value.floatValue() * RPGConfig.itemExpMul);
        }
    };
    public static final IMultiplier<Float> DUR_MUL = new IMultiplier<Float>(){

        @Override
        public Float up(Float value, Object ... meta) {
            ItemStack stack = (ItemStack)meta[0];
            int lvl = (int)ItemAttributes.LEVEL.get(stack);
            if (lvl >= 15) {
                stack.func_77978_p().func_74757_a("Unbreakable", true);
                return value;
            }
            return Float.valueOf(value.floatValue() + (float)(25 * (lvl - 1)));
        }
    };

    public static boolean registerLvlableItem(Item item) {
        if (item != null && !(item instanceof ItemBlock)) {
            ILvlableItem.ILvlableItemTool iLvl;
            if (RPGCapability.lvlItemRegistr.data.containsKey(item)) {
                return true;
            }
            ILvlableItem iLvlableItem = item instanceof ItemSword ? ILvlableItem.DEFAULT_SWORD : (item instanceof ItemTool ? ILvlableItem.DEFAULT_TOOL : (item instanceof ItemHoe ? ILvlableItem.DEFAULT_TOOL : (item instanceof ItemArmor ? ILvlableItem.DEFAULT_ARMOR : (iLvl = item instanceof ItemBow ? ILvlableItem.DEFAULT_BOW : null))));
            if (iLvl != null) {
                RPGCapability.lvlItemRegistr.data.put(item, new ItemAttributesMap(iLvl, false));
                return true;
            }
        }
        return false;
    }

    public static void registerParamsDefault(Item item, ItemAttributesMap map) {
        map.addDynamicItemAttribute(ItemAttributes.MAX_EXP, RPGConfig.itemStartMaxExp, EXP_MUL);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.DefaultIAEvent(item, map));
    }

    public static void registerParamsItemMod(Item item, ItemAttributesMap map) {
        float durab;
        float ench;
        RPGItemComponent comp;
        if (item instanceof ILvlableItem.ILvlableItemMod && (comp = ((ILvlableItem.ILvlableItemMod)item).getItemComponent(item)) instanceof RPGItemComponent.IWithoutToolMaterial) {
            ench = ((RPGItemComponent.IWithoutToolMaterial)((Object)comp)).getEnchantability();
            durab = ((RPGItemComponent.IWithoutToolMaterial)((Object)comp)).getMaxDurability();
        } else {
            ench = item.func_77619_b();
            durab = item.func_77645_m() ? (float)item.func_77612_l() : -1.0f;
        }
        map.addDynamicItemAttribute(ItemAttributes.ENCHANTABILITY, ench, IMultiplier.ADD_1);
        if (durab != -1.0f) {
            map.addDynamicItemAttribute(ItemAttributes.MAX_DURABILITY, durab, DUR_MUL);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemModIAEvent(item, map));
    }

    public static void registerParamsItemSword(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemMod(item, map);
        ILvlableItem.ILvlableItemTool iLvl = (ILvlableItem.ILvlableItemTool)(item instanceof ILvlableItem.ILvlableItemTool ? item : ILvlableItem.DEFAULT_SWORD);
        RPGItemComponent.RPGToolComponent comp = iLvl.getItemComponent(item);
        RPGToolMaterial mat = iLvl.getToolMaterial(item);
        map.addStaticItemAttribute(ItemAttributes.MELEE_DAMAGE, comp.meleeDamage + mat.material.func_78000_c() * comp.strMul * 2.0f);
        map.addStaticItemAttribute(ItemAttributes.MELEE_SPEED, comp.meleeSpeed);
        map.addStaticItemAttribute(ItemAttributes.STR_MUL, comp.strMul);
        map.addStaticItemAttribute(ItemAttributes.AGI_MUL, comp.agiMul);
        map.addStaticItemAttribute(ItemAttributes.INT_MUL, comp.intMul);
        map.addStaticItemAttribute(ItemAttributes.KNOCKBACK, comp.knBack);
        map.addStaticItemAttribute(ItemAttributes.KNBACK_MUL, comp.knbMul);
        map.addStaticItemAttribute(ItemAttributes.REACH, comp.reach);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemSwordIAEvent(item, map));
    }

    public static void registerParamsItemTool(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemMod(item, map);
        ILvlableItem.ILvlableItemTool iLvl = (ILvlableItem.ILvlableItemTool)(item instanceof ILvlableItem.ILvlableItemTool ? item : ILvlableItem.DEFAULT_TOOL);
        RPGItemComponent.RPGToolComponent comp = iLvl.getItemComponent(item);
        RPGToolMaterial mat = iLvl.getToolMaterial(item);
        map.addStaticItemAttribute(ItemAttributes.MELEE_DAMAGE, comp.meleeDamage + mat.material.func_78000_c() * comp.strMul * 2.0f);
        map.addStaticItemAttribute(ItemAttributes.MELEE_SPEED, comp.meleeSpeed);
        map.addStaticItemAttribute(ItemAttributes.STR_MUL, comp.strMul);
        map.addStaticItemAttribute(ItemAttributes.AGI_MUL, comp.agiMul);
        map.addStaticItemAttribute(ItemAttributes.INT_MUL, comp.intMul);
        map.addStaticItemAttribute(ItemAttributes.KNOCKBACK, comp.knBack);
        map.addStaticItemAttribute(ItemAttributes.KNBACK_MUL, comp.knbMul);
        map.addStaticItemAttribute(ItemAttributes.REACH, comp.reach);
        map.addDynamicItemAttribute(ItemAttributes.EFFICIENCY, mat.material.func_77998_b(), IMultiplier.ADD_1);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemToolIAEvent(item, map));
    }

    public static void registerParamsItemArmor(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemMod(item, map);
        ILvlableItem.ILvlableItemArmor iLvl = (ILvlableItem.ILvlableItemArmor)(item instanceof ILvlableItem.ILvlableItemArmor ? item : ILvlableItem.DEFAULT_ARMOR);
        RPGArmorMaterial mat = iLvl.getArmorMaterial(item);
        RPGItemComponent.RPGArmorComponent com = iLvl.getItemComponent(item);
        float armor = (float)mat.material.func_78044_b(((ItemArmor)item).field_77881_a) * com.phisicalResMul;
        map.addStaticItemAttribute(ItemAttributes.PHISIC_ARMOR, HookArmorSystem.convertPhisicArmor(armor));
        map.addStaticItemAttribute(ItemAttributes.MAGIC_ARMOR, mat.magicRes * com.magicResMul);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemArmorIAEvent(item, map));
    }

    public static void registerParamsItemBow(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemMod(item, map);
        ILvlableItem.ILvlableItemBow iLvl = (ILvlableItem.ILvlableItemBow)(item instanceof ILvlableItem.ILvlableItemBow ? item : ILvlableItem.DEFAULT_BOW);
        RPGItemComponent.RPGBowComponent comp = iLvl.getItemComponent(item);
        map.addStaticItemAttribute(ItemAttributes.MELEE_DAMAGE, comp.meleeDamage);
        map.addStaticItemAttribute(ItemAttributes.MELEE_SPEED, comp.meleeSpeed);
        map.addStaticItemAttribute(ItemAttributes.STR_MUL, comp.strMul);
        map.addStaticItemAttribute(ItemAttributes.AGI_MUL, comp.agiMul);
        map.addStaticItemAttribute(ItemAttributes.INT_MUL, comp.intMul);
        map.addStaticItemAttribute(ItemAttributes.KNOCKBACK, comp.knBack);
        map.addStaticItemAttribute(ItemAttributes.KNBACK_MUL, comp.knbMul);
        map.addStaticItemAttribute(ItemAttributes.SHOT_DAMAGE, comp.shotDamage);
        map.addStaticItemAttribute(ItemAttributes.SHOT_POWER, comp.shotPower);
        map.addStaticItemAttribute(ItemAttributes.MIN_CUST_TIME, comp.shotMinCastTime);
        map.addStaticItemAttribute(ItemAttributes.SHOT_SPEED, comp.shotSpeed);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemBowIAEvent(item, map));
    }

    public static void registerParamsItemGun(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemMod(item, map);
        ILvlableItem.ILvlableItemGun iLvl = (ILvlableItem.ILvlableItemGun)item;
        RPGItemComponent.RPGGunComponent comp = iLvl.getItemComponent(item);
        RPGToolMaterial mat = iLvl.getToolMaterial(item);
        map.addStaticItemAttribute(ItemAttributes.MELEE_DAMAGE, comp.meleeDamage + mat.material.func_78000_c() * comp.strMul * 2.0f);
        map.addStaticItemAttribute(ItemAttributes.MELEE_SPEED, comp.meleeSpeed);
        map.addStaticItemAttribute(ItemAttributes.STR_MUL, comp.strMul);
        map.addStaticItemAttribute(ItemAttributes.AGI_MUL, comp.agiMul);
        map.addStaticItemAttribute(ItemAttributes.INT_MUL, comp.intMul);
        map.addStaticItemAttribute(ItemAttributes.KNOCKBACK, comp.knBack);
        map.addStaticItemAttribute(ItemAttributes.KNBACK_MUL, comp.knbMul);
        map.addStaticItemAttribute(ItemAttributes.REACH, comp.reach);
        map.addStaticItemAttribute(ItemAttributes.SHOT_DAMAGE, comp.shotDamage + mat.material.func_78000_c() * comp.intMul * 2.0f);
        map.addStaticItemAttribute(ItemAttributes.MIN_CUST_TIME, comp.shotMinCastTime);
        map.addStaticItemAttribute(ItemAttributes.SHOT_SPEED, comp.shotSpeed);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemGunIAEvent(item, map));
    }

    public static void registerParamsItemStaff(Item item, ItemAttributesMap map) {
        LvlableItem.registerParamsItemGun(item, map);
        ILvlableItem.ILvlableItemStaff iLvl = (ILvlableItem.ILvlableItemStaff)item;
        RPGItemComponent.RPGStaffComponent comp = iLvl.getItemComponent(item);
        RPGToolMaterial mat = iLvl.getToolMaterial(item);
        map.addStaticItemAttribute(ItemAttributes.MANA_COST, comp.needMana);
        MinecraftForge.EVENT_BUS.post((Event)new RegIAEvent.ItemStaffIAEvent(item, map));
    }

    public static boolean isLvlable(ItemStack stack) {
        return RPGCapability.lvlItemRegistr.registr.contains(stack.func_77973_b());
    }

    public static Set<ItemAttribute> getAttributeValues(ItemStack stack) {
        return RPGCapability.lvlItemRegistr.data.get((Object)stack.func_77973_b()).map.keySet();
    }

    public static void createLvlableItem(ItemStack stack) {
        if (LvlableItem.isLvlable(stack)) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            LvlableItem.setStartParams(stack);
        }
    }

    public static void setStartParams(ItemStack stack) {
        if (LvlableItem.isLvlable(stack)) {
            ItemAttributes.LEVEL.set(stack, 1.0f);
            ItemAttributes.CURR_EXP.set(stack, 0.0f);
            ItemAttributes.MAX_EXP.init(stack);
            Set<ItemAttribute> itemAttributes = LvlableItem.getAttributeValues(stack);
            for (ItemAttribute iterator : itemAttributes) {
                iterator.init(stack);
            }
        }
    }

    public static void instantLvlUp(ItemStack stack) {
        if (LvlableItem.isLvlable(stack)) {
            ItemAttributes.LEVEL.add(stack, 1.0f);
            ItemAttributes.MAX_EXP.lvlUp(stack);
            ItemAttributes.CURR_EXP.set(stack, 0.0f);
            Set<ItemAttribute> itemAttributes = LvlableItem.getAttributeValues(stack);
            for (ItemAttribute iterator : itemAttributes) {
                iterator.lvlUp(stack);
            }
        }
    }

    public static void addExp(ItemStack stack, int value) {
        if (LvlableItem.isLvlable(stack)) {
            if (value <= 0) {
                return;
            }
            int level = (int)ItemAttributes.LEVEL.get(stack);
            if (level < RPGConfig.itemMaxLevel) {
                long currEXP = (long)ItemAttributes.CURR_EXP.get(stack);
                int maxEXP = (int)ItemAttributes.MAX_EXP.get(stack);
                currEXP += (long)value;
                while (currEXP >= (long)maxEXP) {
                    LvlableItem.instantLvlUp(stack);
                    if (++level < RPGConfig.itemMaxLevel) {
                        currEXP -= (long)maxEXP;
                        continue;
                    }
                    currEXP = maxEXP;
                    break;
                }
                ItemAttributes.CURR_EXP.set(stack, currEXP);
            }
        }
    }

    public static void upEquipment(EntityPlayer player, EntityLivingBase target, ItemStack stack, float points) {
        UpEquipmentEvent e = new UpEquipmentEvent(player, target, stack, points);
        MinecraftForge.EVENT_BUS.post((Event)e);
        if (e.points > 0.0f) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stack = player.func_71045_bC();
            if (e.needUp[0] && stack != null && LvlableItem.isLvlable(stack)) {
                stacks.add(stack);
            }
            ItemStack[] armors = player.field_71071_by.field_70460_b;
            for (int i = 0; i < armors.length; ++i) {
                if (!e.needUp[i + 1] || armors[i] == null || !LvlableItem.isLvlable(armors[i])) continue;
                stacks.add(armors[i]);
            }
            e.points /= (float)stacks.size();
            for (ItemStack tmp : stacks) {
                LvlableItem.addExp(tmp, (int)e.points);
            }
        }
    }

    public static class ItemAttributesMap {
        public Map<ItemAttribute, ItemAttrParams> map = new LinkedHashMap<ItemAttribute, ItemAttrParams>();
        public ILvlableItem lvlComponent;
        public boolean isSupported;

        public ItemAttributesMap(ILvlableItem lvlComponent, boolean isSupported) {
            this.lvlComponent = lvlComponent;
            this.isSupported = isSupported;
        }

        public void addStaticItemAttribute(IAStatic attr, float value) {
            this.map.put(attr, new ItemAttrParams(value, null));
        }

        public void addDynamicItemAttribute(IADynamic attr, float value, IMultiplier mul) {
            this.map.put(attr, new ItemAttrParams(value, mul));
        }

        public static class ItemAttrParams {
            public float value;
            public IMultiplier<Float> mul;

            public ItemAttrParams(float value, IMultiplier<Float> mul) {
                this.value = value;
                this.mul = mul;
            }

            public float up(float value, ItemStack stack) {
                return this.mul.up(Float.valueOf(value), stack).floatValue();
            }
        }
    }
}

