/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.capability;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mixac1.dangerrpg.DangerRPG;
import mixac1.dangerrpg.api.entity.EntityAttribute;
import mixac1.dangerrpg.api.entity.IRPGEntity;
import mixac1.dangerrpg.api.entity.LvlEAProvider;
import mixac1.dangerrpg.api.event.InitRPGEntityEvent;
import mixac1.dangerrpg.api.event.RegEAEvent;
import mixac1.dangerrpg.capability.ea.EntityAttributes;
import mixac1.dangerrpg.capability.ea.PlayerAttributes;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.init.RPGConfig;
import mixac1.dangerrpg.init.RPGNetwork;
import mixac1.dangerrpg.init.RPGOther;
import mixac1.dangerrpg.network.MsgSyncEntityData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;

public class RPGEntityData
implements IExtendedEntityProperties {
    protected static final String ID = "RPGCommonEntityData";
    public final EntityLivingBase entity;
    public HashMap<Integer, TypeStub> attributeMap = new HashMap();
    public HashMap<Integer, Integer> lvlMap = new HashMap();

    public RPGEntityData(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void init(Entity entity, World world) {
        for (EntityAttribute iter : this.getEntityAttributes()) {
            iter.init((EntityLivingBase)entity);
        }
    }

    public void serverInit() {
        if (RPGEntityData.isServerSide(this.entity) && !EntityAttributes.LVL.isInitedEntity(this.entity)) {
            for (EntityAttribute iter : this.getEntityAttributes()) {
                iter.serverInit(this.entity);
            }
            if (!(this.entity instanceof EntityPlayer)) {
                MinecraftForge.EVENT_BUS.post((Event)new InitRPGEntityEvent(this.entity));
            }
        }
    }

    public static void register(EntityLivingBase entity) {
        entity.registerExtendedProperties(ID, (IExtendedEntityProperties)new RPGEntityData(entity));
    }

    public static RPGEntityData get(EntityLivingBase entity) {
        return (RPGEntityData)entity.getExtendedProperties(ID);
    }

    public static boolean isServerSide(EntityLivingBase entity) {
        return !entity.field_70170_p.field_72995_K;
    }

    public boolean checkValid() {
        boolean result = EntityAttributes.LVL.isInitedEntity(this.entity);
        if (!result) {
            if (RPGEntityData.isServerSide(this.entity)) {
                this.init((Entity)this.entity, this.entity.field_70170_p);
                RPGNetwork.net.sendToAll((IMessage)new MsgSyncEntityData(this.entity, this));
            } else if (DangerRPG.proxy.getTick(Side.CLIENT) % 100 == 0) {
                RPGNetwork.net.sendToServer((IMessage)new MsgSyncEntityData(this.entity));
            }
        }
        return result;
    }

    public void rebuildOnDeath() {
        int count = 0;
        ArrayList<LvlEAProvider> pas = new ArrayList<LvlEAProvider>();
        for (LvlEAProvider it : this.getLvlProviders()) {
            int lvl = it.getLvl(this.entity);
            if (lvl <= 1) continue;
            pas.add(it);
            count += lvl - 1;
        }
        if (count > RPGConfig.playerLoseLvlCount) {
            count = RPGConfig.playerLoseLvlCount;
        }
        for (int i = 0; i < count; ++i) {
            int rand = RPGOther.rand.nextInt(pas.size());
            ((LvlEAProvider)pas.get(rand)).up(this.entity, null, false);
            if (((LvlEAProvider)pas.get(rand)).getLvl(this.entity) > 1) continue;
            pas.remove(rand);
        }
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound tmp = new NBTTagCompound();
        for (EntityAttribute iter : this.getEntityAttributes()) {
            iter.toNBT(tmp, this.entity);
        }
        nbt.func_74782_a(ID, (NBTBase)tmp);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound tmp = (NBTTagCompound)nbt.func_74781_a(ID);
        if (tmp != null) {
            for (EntityAttribute iter : this.getEntityAttributes()) {
                iter.fromNBT(tmp, this.entity);
            }
        }
    }

    private Object getObject(int hash, Collection list) {
        for (Object it : list) {
            if (it.hashCode() != hash) continue;
            return it;
        }
        return null;
    }

    public EntityAttribute getEntityAttribute(int hash) {
        return (EntityAttribute)this.getObject(hash, this.getEntityAttributes());
    }

    public LvlEAProvider getLvlProvider(int hash) {
        return (LvlEAProvider)this.getObject(hash, this.getLvlProviders());
    }

    public Set<EntityAttribute> getEntityAttributes() {
        return RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)this.entity).attributes.keySet();
    }

    public List<LvlEAProvider> getLvlProviders() {
        return RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)this.entity).lvlProviders;
    }

    public static boolean isRPGEntity(EntityLivingBase entity) {
        return RPGCapability.rpgEntityRegistr.isRegistered(entity);
    }

    public static boolean registerEntity(Class entityClass) {
        if (EntityLivingBase.class.isAssignableFrom(entityClass)) {
            if (RPGCapability.rpgEntityRegistr.data.containsKey(entityClass)) {
                return true;
            }
            IRPGEntity iRPG = EntityPlayer.class.isAssignableFrom(entityClass) ? IRPGEntity.DEFAULT_PLAYER : (EntityMob.class.isAssignableFrom(entityClass) ? IRPGEntity.DEFAULT_MOB : IRPGEntity.DEFAULT_LIVING);
            RPGCapability.rpgEntityRegistr.data.put(entityClass, new EntityAttributesSet(iRPG, false));
            return true;
        }
        return false;
    }

    public static void registerEntityDefault(Class<? extends EntityLivingBase> entityClass, EntityAttributesSet set) {
        set.addEntityAttribute(EntityAttributes.LVL, 1);
        MinecraftForge.EVENT_BUS.post((Event)new RegEAEvent.DefaultEAEvent(entityClass, set));
    }

    public static void registerEntityLiving(Class<? extends EntityLiving> entityClass, EntityAttributesSet set) {
        set.addEntityAttribute(EntityAttributes.HEALTH, Float.valueOf(0.0f));
        MinecraftForge.EVENT_BUS.post((Event)new RegEAEvent.EntytyLivingEAEvent(entityClass, set));
    }

    public static void registerEntityMob(Class<? extends EntityMob> entityClass, EntityAttributesSet set) {
        set.addEntityAttribute(EntityAttributes.MELEE_DAMAGE, Float.valueOf(0.0f));
        MinecraftForge.EVENT_BUS.post((Event)new RegEAEvent.EntytyMobEAEvent(entityClass, set));
    }

    public static void registerEntityPlayer(Class<? extends EntityPlayer> entityClass, EntityAttributesSet set) {
        set.addLvlableEntityAttribute(PlayerAttributes.HEALTH, Float.valueOf(0.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_2, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.MANA, Float.valueOf(10.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_2, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.STRENGTH, Float.valueOf(0.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_1, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.AGILITY, Float.valueOf(0.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_1, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.INTELLIGENCE, Float.valueOf(0.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_1, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.EFFICIENCY, Float.valueOf(0.0f), new LvlEAProvider(2, 1000, PlayerAttributes.ADD_2, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.MANA_REGEN, Float.valueOf(1.0f), new LvlEAProvider<Float>(2, 1000, PlayerAttributes.ADD_0d2, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.HEALTH_REGEN, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 1000, PlayerAttributes.ADD_0d2, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.MOVE_SPEED, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d001, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.SNEAK_SPEED, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d001, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.FLY_SPEED, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d001, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.SWIM_SPEED, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d001, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.JUMP_HEIGHT, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d014, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.JUMP_RANGE, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d001, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.STEEL_MUSC, Float.valueOf(0.0f), new LvlEAProvider<Float>(2, 20, PlayerAttributes.ADD_0d5, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.STONESKIN, Float.valueOf(0.0f), new LvlEAProvider(2, 20, PlayerAttributes.ADD_1, PlayerAttributes.MUL_1));
        set.addLvlableEntityAttribute(PlayerAttributes.MAG_IMUN, Float.valueOf(0.0f), new LvlEAProvider(2, 20, PlayerAttributes.ADD_1, PlayerAttributes.MUL_1));
        set.addEntityAttribute(PlayerAttributes.CURR_MANA, Float.valueOf(0.0f));
        set.addEntityAttribute(PlayerAttributes.SPEED_COUNTER, Float.valueOf(0.0f));
        MinecraftForge.EVENT_BUS.post((Event)new RegEAEvent.PlayerEAEvent(entityClass, set));
    }

    public static class EntityAttributesSet {
        public Map<EntityAttribute, EntityAttrParams> attributes = new LinkedHashMap<EntityAttribute, EntityAttrParams>();
        public List<LvlEAProvider> lvlProviders = new LinkedList<LvlEAProvider>();
        public IRPGEntity rpgComponent;
        public boolean isSupported;

        public EntityAttributesSet(IRPGEntity rpgComponent, boolean isSupported) {
            this.rpgComponent = rpgComponent;
            this.isSupported = isSupported;
        }

        public <T> void addLvlableEntityAttribute(EntityAttribute<T> attr, T startvalue, LvlEAProvider<T> lvlProvider) {
            lvlProvider.attr = attr;
            this.attributes.put(attr, new EntityAttrParams<T>(startvalue, lvlProvider));
            this.lvlProviders.add(lvlProvider);
        }

        public <T> void addEntityAttribute(EntityAttribute<T> attr, T startvalue) {
            this.attributes.put(attr, new EntityAttrParams<T>(startvalue, null));
        }

        public static class EntityAttrParams<Type> {
            public Type startValue;
            public LvlEAProvider<Type> lvlProvider;

            public EntityAttrParams(Type startValue, LvlEAProvider<Type> lvlProvider) {
                this.startValue = startValue;
                this.lvlProvider = lvlProvider;
            }
        }
    }

    public static class TypeStub<Type> {
        public Type value;

        public TypeStub(Type value) {
            this.value = value;
        }
    }
}

