/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.entity.projectile;

import mixac1.dangerrpg.entity.projectile.EntityWithStack;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0DPacketCollectItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityMaterial
extends EntityWithStack {
    public static final int PICKUP_NO = 0;
    public static final int PICKUP_ALL = 1;
    public static final int PICKUP_CREATIVE = 2;
    public static final int PICKUP_OWNER = 3;
    public int pickupMode;
    public float phisicDamage;

    public EntityMaterial(World world) {
        super(world);
    }

    public EntityMaterial(World world, ItemStack stack) {
        super(world, stack);
    }

    public EntityMaterial(World world, ItemStack stack, double x, double y, double z) {
        super(world, stack, x, y, z);
    }

    public EntityMaterial(World world, EntityLivingBase thrower, ItemStack stack, float speed, float deviation) {
        super(world, thrower, stack, speed, deviation);
    }

    public EntityMaterial(World world, EntityLivingBase thrower, EntityLivingBase target, ItemStack stack, float speed, float deviation) {
        super(world, thrower, target, stack, speed, deviation);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.pickupMode = 1;
    }

    @Override
    public void applyEntityHitEffects(EntityLivingBase entity, float dmgMul) {
        int knockback;
        DamageSource dmgSource = this.thrower == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : (this.thrower instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.thrower)) : DamageSource.func_76358_a((EntityLivingBase)this.thrower));
        entity.func_70097_a(dmgSource, (this.phisicDamage + this.getMeleeHitDamage((Entity)entity)) * dmgMul);
        if (this.thrower != null && (knockback = EnchantmentHelper.func_77507_b((EntityLivingBase)this.thrower, (EntityLivingBase)entity)) != 0) {
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
            this.func_70031_b(false);
        }
        super.applyEntityHitEffects(entity, dmgMul);
    }

    @Override
    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (this.field_70254_i && this.field_70249_b <= 0 && !this.field_70170_p.field_72995_K && this.canPickup(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70441_a(this.getStack());
            }
            this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.onItemPickup(player);
            this.func_70106_y();
        }
    }

    protected boolean canPickup(EntityPlayer entityplayer) {
        if (this.pickupMode == 1) {
            return true;
        }
        if (this.pickupMode == 2) {
            return entityplayer.field_71075_bZ.field_75098_d;
        }
        if (this.pickupMode == 3) {
            return entityplayer == this.thrower;
        }
        return false;
    }

    protected void onItemPickup(EntityPlayer player) {
        ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new S0DPacketCollectItem(this.func_145782_y(), player.func_145782_y()));
    }

    public float getMeleeHitDamage(Entity entity) {
        if (entity instanceof EntityLivingBase && this.thrower != null) {
            return EnchantmentHelper.func_77512_a((EntityLivingBase)this.thrower, (EntityLivingBase)((EntityLivingBase)entity));
        }
        return 0.0f;
    }

    @Override
    public float getAirResistance() {
        return 0.95f;
    }

    @Override
    public float getWaterResistance() {
        return 0.8f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public boolean dieAfterEntityHit() {
        return false;
    }

    @Override
    public boolean dieAfterGroundHit() {
        return false;
    }

    @Override
    public void playHitSound() {
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("pickupMode", (byte)this.pickupMode);
        nbt.func_74776_a("phisicDamage", this.phisicDamage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.pickupMode = nbt.func_74771_c("pickupMode") & 0xFF;
        this.phisicDamage = nbt.func_74760_g("phisicDamage");
    }
}

