/*
 * Decompiled with CFR 0.152.
 */
package mixac1.dangerrpg.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mixac1.dangerrpg.api.item.ILvlableItem;
import mixac1.dangerrpg.capability.LvlableItem;
import mixac1.dangerrpg.capability.RPGEntityData;
import mixac1.dangerrpg.capability.ea.PlayerAttributes;
import mixac1.dangerrpg.capability.ia.ItemAttributes;
import mixac1.dangerrpg.init.RPGCapability;
import mixac1.dangerrpg.item.IMaterialSpecial;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public abstract class RPGCommonHelper {
    public static void knockBack(EntityLivingBase entityliving, EntityLivingBase attacker, float knockback) {
        double i = Math.sqrt(knockback);
        double x = (double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z / 180.0f * (float)Math.PI))) * 0.4;
        double z = (double)MathHelper.func_76134_b((float)(attacker.field_70177_z / 180.0f * (float)Math.PI)) * 0.4;
        double y = (double)(-MathHelper.func_76126_a((float)(attacker.field_70125_A / 180.0f * (float)Math.PI))) * 0.1;
        entityliving.func_70024_g(x * i, y * i, z * i);
    }

    public static void rebuildPlayerExp(EntityPlayer player) {
        int lvl = player.field_71068_ca;
        int exp = (int)((float)player.func_71050_bK() * player.field_71106_cc);
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        player.field_71068_ca = 0;
        for (int i = 0; i < lvl; ++i) {
            player.func_71023_q(player.func_71050_bK());
        }
        player.func_71023_q(exp);
    }

    public static void rebuildPlayerLvl(EntityPlayer player) {
        int exp = player.field_71067_cb;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        player.field_71068_ca = 0;
        player.func_71023_q(exp);
    }

    public static MovingObjectPosition getMouseOver(float frame, float dist) {
        Minecraft mc = Minecraft.func_71410_x();
        MovingObjectPosition mop = null;
        if (mc.field_71451_h != null && mc.field_71441_e != null) {
            mop = mc.field_71451_h.func_70614_a((double)dist, frame);
            Vec3 pos = mc.field_71451_h.func_70666_h(frame);
            double calcDist = dist;
            if (mop != null) {
                calcDist = mop.field_72307_f.func_72438_d(pos);
            }
            Vec3 look = mc.field_71451_h.func_70676_i(frame);
            look = Vec3.func_72443_a((double)(look.field_72450_a * (double)dist), (double)(look.field_72448_b * (double)dist), (double)(look.field_72449_c * (double)dist));
            Vec3 vec = pos.func_72441_c(look.field_72450_a, look.field_72448_b, look.field_72449_c);
            Entity pointedEntity = null;
            List list = mc.field_71441_e.func_72839_b((Entity)mc.field_71451_h, mc.field_71451_h.field_70121_D.func_72321_a(look.field_72450_a, look.field_72448_b, look.field_72449_c).func_72314_b(1.0, 1.0, 1.0));
            double d = calcDist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float borderSize = entity.func_70111_Y();
                AxisAlignedBB aabb = entity.field_70121_D.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
                MovingObjectPosition mop0 = aabb.func_72327_a(pos, vec);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 <= d)) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcDist || mop == null)) {
                mop = new MovingObjectPosition(pointedEntity);
            }
        }
        return mop;
    }

    public static float getUsePower(EntityPlayer player, ItemStack stack, int useDuration, float defMaxPow, float defMinPow) {
        float minPower;
        float power = RPGCommonHelper.getUsePower(player, stack, useDuration, defMaxPow);
        float f = minPower = ItemAttributes.MIN_CUST_TIME.hasIt(stack) ? ItemAttributes.MIN_CUST_TIME.get(stack, player) : defMinPow;
        if (power < minPower) {
            return -1.0f;
        }
        return power;
    }

    public static float getUsePower(EntityPlayer player, ItemStack stack, int useDuration, float defMaxPow) {
        float power = (float)useDuration / (ItemAttributes.SHOT_SPEED.hasIt(stack) ? ItemAttributes.SHOT_SPEED.get(stack, player) : defMaxPow);
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            return 1.0f;
        }
        return power;
    }

    public static IMaterialSpecial getMaterialSpecial(ItemStack stack) {
        if (stack != null && LvlableItem.isLvlable(stack)) {
            ILvlableItem ilvl = RPGCapability.lvlItemRegistr.data.get((Object)stack.func_77973_b()).lvlComponent;
            if (ilvl instanceof ILvlableItem.ILvlableItemArmor) {
                return ((ILvlableItem.ILvlableItemArmor)ilvl).getArmorMaterial(stack.func_77973_b());
            }
            if (ilvl instanceof ILvlableItem.ILvlableItemTool) {
                return ((ILvlableItem.ILvlableItemTool)ilvl).getToolMaterial(stack.func_77973_b());
            }
        }
        return null;
    }

    public static int getSpecialColor(ItemStack stack, int defaultColor) {
        IMaterialSpecial mat = RPGCommonHelper.getMaterialSpecial(stack);
        if (mat != null && mat.hasSpecialColor()) {
            return mat.getSpecialColor();
        }
        return defaultColor;
    }

    public static Vec3 getFirePoint(EntityLivingBase thrower) {
        Vec3 tmp = thrower.func_70040_Z();
        tmp.field_72450_a /= 2.0;
        tmp.field_72448_b /= 2.0;
        tmp.field_72449_c /= 2.0;
        tmp.field_72450_a += thrower.field_70165_t;
        tmp.field_72448_b += thrower.field_70163_u + (double)thrower.func_70047_e();
        tmp.field_72449_c += thrower.field_70161_v;
        tmp.field_72450_a -= (double)(MathHelper.func_76134_b((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * 0.22f);
        tmp.field_72448_b -= 0.3;
        tmp.field_72449_c -= (double)(MathHelper.func_76126_a((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * 0.22f);
        return tmp;
    }

    public static boolean spendMana(EntityPlayer player, float mana) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (((Float)PlayerAttributes.CURR_MANA.getValue((EntityLivingBase)player)).floatValue() >= mana) {
                PlayerAttributes.CURR_MANA.addValue(Float.valueOf(-mana), (EntityLivingBase)player);
                return true;
            }
            return false;
        }
        return true;
    }

    public static ArrayList<String> getItemNames(Set<Item> items, boolean needSort) {
        ArrayList<String> names = new ArrayList<String>();
        for (Item item : items) {
            names.add(item.field_77774_bZ);
        }
        if (needSort) {
            Collections.sort(names);
        }
        return names;
    }

    public static ArrayList<String> getEntityNames(Set<Class<? extends EntityLivingBase>> set, boolean needSort) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<? extends EntityLivingBase> item : set) {
            if (!EntityList.field_75626_c.containsKey(item)) continue;
            names.add((String)EntityList.field_75626_c.get(item));
        }
        if (needSort) {
            Collections.sort(names);
        }
        return names;
    }

    public static float getMeleeDamageHook(EntityLivingBase entity, float defaultDamage) {
        if (RPGEntityData.isRPGEntity(entity)) {
            return ((Float)RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)entity).rpgComponent.getEAMeleeDamage(entity).getValue(entity)).floatValue();
        }
        return defaultDamage;
    }

    public static float getRangeDamageHook(EntityLivingBase entity, float defaultDamage) {
        if (RPGEntityData.isRPGEntity(entity)) {
            return ((Float)RPGCapability.rpgEntityRegistr.getAttributesSet((EntityLivingBase)entity).rpgComponent.getEARangeDamage(entity).getValue(entity)).floatValue();
        }
        return defaultDamage;
    }
}

