/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;

public class LwjglCursor
implements Cursor {
    org.lwjgl.input.Cursor lwjglCursor = null;

    public LwjglCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        if (((LwjglGraphics)Gdx.graphics).canvas != null && SharedLibraryLoader.isMac) {
            return;
        }
        try {
            if (pixmap == null) {
                this.lwjglCursor = null;
                return;
            }
            if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
                throw new GdxRuntimeException("Cursor image pixmap is not in RGBA8888 format.");
            }
            if ((pixmap.getWidth() & pixmap.getWidth() - 1) != 0) {
                throw new GdxRuntimeException("Cursor image pixmap width of " + pixmap.getWidth() + " is not a power-of-two greater than zero.");
            }
            if ((pixmap.getHeight() & pixmap.getHeight() - 1) != 0) {
                throw new GdxRuntimeException("Cursor image pixmap height of " + pixmap.getHeight() + " is not a power-of-two greater than zero.");
            }
            if (xHotspot < 0 || xHotspot >= pixmap.getWidth()) {
                throw new GdxRuntimeException("xHotspot coordinate of " + xHotspot + " is not within image width bounds: [0, " + pixmap.getWidth() + ").");
            }
            if (yHotspot < 0 || yHotspot >= pixmap.getHeight()) {
                throw new GdxRuntimeException("yHotspot coordinate of " + yHotspot + " is not within image height bounds: [0, " + pixmap.getHeight() + ").");
            }
            IntBuffer pixelBuffer = pixmap.getPixels().asIntBuffer();
            int[] pixelsRGBA = new int[pixelBuffer.capacity()];
            pixelBuffer.get(pixelsRGBA);
            int[] pixelsARGBflipped = new int[pixelBuffer.capacity()];
            if (pixelBuffer.order() == ByteOrder.BIG_ENDIAN) {
                for (int y2 = 0; y2 < pixmap.getHeight(); ++y2) {
                    for (int x2 = 0; x2 < pixmap.getWidth(); ++x2) {
                        int pixel = pixelsRGBA[x2 + y2 * pixmap.getWidth()];
                        pixelsARGBflipped[x2 + (pixmap.getHeight() - 1 - y2) * pixmap.getWidth()] = pixel >> 8 & 0xFFFFFF | pixel << 24 & 0xFF000000;
                    }
                }
            } else {
                for (int y3 = 0; y3 < pixmap.getHeight(); ++y3) {
                    for (int x3 = 0; x3 < pixmap.getWidth(); ++x3) {
                        int pixel = pixelsRGBA[x3 + y3 * pixmap.getWidth()];
                        pixelsARGBflipped[x3 + (pixmap.getHeight() - 1 - y3) * pixmap.getWidth()] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                    }
                }
            }
            this.lwjglCursor = new org.lwjgl.input.Cursor(pixmap.getWidth(), pixmap.getHeight(), xHotspot, pixmap.getHeight() - yHotspot - 1, 1, IntBuffer.wrap(pixelsARGBflipped), null);
        }
        catch (LWJGLException e2) {
            throw new GdxRuntimeException("Could not create cursor image.", e2);
        }
    }

    @Override
    public void dispose() {
    }
}

