/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ShortArray;

public class RepeatablePolygonSprite {
    private TextureRegion region;
    private float density;
    private boolean dirty = true;
    private Array<float[]> parts = new Array();
    private Array<float[]> vertices = new Array();
    private Array<short[]> indices = new Array();
    private int cols;
    private int rows;
    private float gridWidth;
    private float gridHeight;
    public float x = 0.0f;
    public float y = 0.0f;
    private Color color = Color.WHITE;
    private Vector2 offset = new Vector2();

    public void setPolygon(TextureRegion region, float[] vertices) {
        this.setPolygon(region, vertices, -1.0f);
    }

    public void setPolygon(TextureRegion region, float[] vertices, float density) {
        this.region = region;
        vertices = this.offset(vertices);
        Polygon polygon = new Polygon(vertices);
        Polygon tmpPoly = new Polygon();
        Polygon intersectionPoly = new Polygon();
        EarClippingTriangulator triangulator = new EarClippingTriangulator();
        Rectangle boundRect = polygon.getBoundingRectangle();
        if (density == -1.0f) {
            density = boundRect.getWidth() / (float)region.getRegionWidth();
        }
        float regionAspectRatio = (float)region.getRegionHeight() / (float)region.getRegionWidth();
        this.cols = (int)Math.ceil(density);
        this.gridWidth = boundRect.getWidth() / density;
        this.gridHeight = regionAspectRatio * this.gridWidth;
        this.rows = (int)Math.ceil(boundRect.getHeight() / this.gridHeight);
        for (int col = 0; col < this.cols; ++col) {
            for (int row = 0; row < this.rows; ++row) {
                float[] verts = new float[8];
                int idx = 0;
                verts[idx++] = (float)col * this.gridWidth;
                verts[idx++] = (float)row * this.gridHeight;
                verts[idx++] = (float)col * this.gridWidth;
                verts[idx++] = (float)(row + 1) * this.gridHeight;
                verts[idx++] = (float)(col + 1) * this.gridWidth;
                verts[idx++] = (float)(row + 1) * this.gridHeight;
                verts[idx++] = (float)(col + 1) * this.gridWidth;
                verts[idx] = (float)row * this.gridHeight;
                tmpPoly.setVertices(verts);
                Intersector.intersectPolygons(polygon, tmpPoly, intersectionPoly);
                verts = intersectionPoly.getVertices();
                if (verts.length > 0) {
                    this.parts.add(this.snapToGrid(verts));
                    ShortArray arr = triangulator.computeTriangles(verts);
                    this.indices.add(arr.toArray());
                    continue;
                }
                this.parts.add(null);
            }
        }
        this.buildVertices();
    }

    private float[] snapToGrid(float[] vertices) {
        for (int i2 = 0; i2 < vertices.length; i2 += 2) {
            float numX = vertices[i2] / this.gridWidth % 1.0f;
            float numY = vertices[i2 + 1] / this.gridHeight % 1.0f;
            if (numX > 0.99f || numX < 0.01f) {
                vertices[i2] = this.gridWidth * (float)Math.round(vertices[i2] / this.gridWidth);
            }
            if (!(numY > 0.99f) && !(numY < 0.01f)) continue;
            vertices[i2 + 1] = this.gridHeight * (float)Math.round(vertices[i2 + 1] / this.gridHeight);
        }
        return vertices;
    }

    private float[] offset(float[] vertices) {
        int i2;
        this.offset.set(vertices[0], vertices[1]);
        for (i2 = 0; i2 < vertices.length - 1; i2 += 2) {
            if (this.offset.x > vertices[i2]) {
                this.offset.x = vertices[i2];
            }
            if (!(this.offset.y > vertices[i2 + 1])) continue;
            this.offset.y = vertices[i2 + 1];
        }
        for (i2 = 0; i2 < vertices.length; i2 += 2) {
            int n2 = i2;
            vertices[n2] = vertices[n2] - this.offset.x;
            int n3 = i2 + 1;
            vertices[n3] = vertices[n3] - this.offset.y;
        }
        return vertices;
    }

    private void buildVertices() {
        this.vertices.clear();
        for (int i2 = 0; i2 < this.parts.size; ++i2) {
            float[] verts = this.parts.get(i2);
            if (verts == null) continue;
            float[] fullVerts = new float[5 * verts.length / 2];
            int idx = 0;
            int col = i2 / this.rows;
            int row = i2 % this.rows;
            for (int j2 = 0; j2 < verts.length; j2 += 2) {
                fullVerts[idx++] = verts[j2] + this.offset.x + this.x;
                fullVerts[idx++] = verts[j2 + 1] + this.offset.y + this.y;
                fullVerts[idx++] = this.color.toFloatBits();
                float u2 = verts[j2] % this.gridWidth / this.gridWidth;
                float v2 = verts[j2 + 1] % this.gridHeight / this.gridHeight;
                if (verts[j2] == (float)col * this.gridWidth) {
                    u2 = 0.0f;
                }
                if (verts[j2] == (float)(col + 1) * this.gridWidth) {
                    u2 = 1.0f;
                }
                if (verts[j2 + 1] == (float)row * this.gridHeight) {
                    v2 = 0.0f;
                }
                if (verts[j2 + 1] == (float)(row + 1) * this.gridHeight) {
                    v2 = 1.0f;
                }
                u2 = this.region.getU() + (this.region.getU2() - this.region.getU()) * u2;
                v2 = this.region.getV() + (this.region.getV2() - this.region.getV()) * v2;
                fullVerts[idx++] = u2;
                fullVerts[idx++] = v2;
            }
            this.vertices.add(fullVerts);
        }
        this.dirty = false;
    }

    public void draw(PolygonSpriteBatch batch) {
        if (this.dirty) {
            this.buildVertices();
        }
        for (int i2 = 0; i2 < this.vertices.size; ++i2) {
            batch.draw(this.region.getTexture(), this.vertices.get(i2), 0, this.vertices.get(i2).length, this.indices.get(i2), 0, this.indices.get(i2).length);
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.dirty = true;
    }

    public void setPosition(float x2, float y2) {
        this.x = x2;
        this.y = y2;
        this.dirty = true;
    }
}

