/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.environment;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class AmbientCubemap {
    public final float[] data;

    private static final float clamp(float v2) {
        return v2 < 0.0f ? 0.0f : (v2 > 1.0f ? 1.0f : v2);
    }

    public AmbientCubemap() {
        this.data = new float[18];
    }

    public AmbientCubemap(float[] copyFrom) {
        if (copyFrom.length != 18) {
            throw new GdxRuntimeException("Incorrect array size");
        }
        this.data = new float[copyFrom.length];
        System.arraycopy(copyFrom, 0, this.data, 0, this.data.length);
    }

    public AmbientCubemap(AmbientCubemap copyFrom) {
        this(copyFrom.data);
    }

    public AmbientCubemap set(float[] values) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = values[i2];
        }
        return this;
    }

    public AmbientCubemap set(AmbientCubemap other) {
        return this.set(other.data);
    }

    public AmbientCubemap set(Color color) {
        return this.set(color.r, color.g, color.b);
    }

    public AmbientCubemap set(float r2, float g2, float b2) {
        int idx = 0;
        while (idx < this.data.length) {
            this.data[idx++] = r2;
            this.data[idx++] = g2;
            this.data[idx++] = b2;
        }
        return this;
    }

    public Color getColor(Color out, int side) {
        return out.set(this.data[side *= 3], this.data[side + 1], this.data[side + 2], 1.0f);
    }

    public AmbientCubemap clear() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = 0.0f;
        }
        return this;
    }

    public AmbientCubemap clamp() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            this.data[i2] = AmbientCubemap.clamp(this.data[i2]);
        }
        return this;
    }

    public AmbientCubemap add(float r2, float g2, float b2) {
        int idx = 0;
        while (idx < this.data.length) {
            int n2 = idx++;
            this.data[n2] = this.data[n2] + r2;
            int n3 = idx++;
            this.data[n3] = this.data[n3] + g2;
            int n4 = idx++;
            this.data[n4] = this.data[n4] + b2;
        }
        return this;
    }

    public AmbientCubemap add(Color color) {
        return this.add(color.r, color.g, color.b);
    }

    public AmbientCubemap add(float r2, float g2, float b2, float x2, float y2, float z2) {
        int idx;
        float x22 = x2 * x2;
        float y22 = y2 * y2;
        float z22 = z2 * z2;
        float d2 = x22 + y22 + z22;
        if (d2 == 0.0f) {
            return this;
        }
        d2 = 1.0f / d2 * (d2 + 1.0f);
        float rd = r2 * d2;
        float gd = g2 * d2;
        float bd2 = b2 * d2;
        int n2 = idx = x2 > 0.0f ? 0 : 3;
        this.data[n2] = this.data[n2] + x22 * rd;
        int n3 = idx + 1;
        this.data[n3] = this.data[n3] + x22 * gd;
        int n4 = idx + 2;
        this.data[n4] = this.data[n4] + x22 * bd2;
        int n5 = idx = y2 > 0.0f ? 6 : 9;
        this.data[n5] = this.data[n5] + y22 * rd;
        int n6 = idx + 1;
        this.data[n6] = this.data[n6] + y22 * gd;
        int n7 = idx + 2;
        this.data[n7] = this.data[n7] + y22 * bd2;
        int n8 = idx = z2 > 0.0f ? 12 : 15;
        this.data[n8] = this.data[n8] + z22 * rd;
        int n9 = idx + 1;
        this.data[n9] = this.data[n9] + z22 * gd;
        int n10 = idx + 2;
        this.data[n10] = this.data[n10] + z22 * bd2;
        return this;
    }

    public AmbientCubemap add(Color color, Vector3 direction) {
        return this.add(color.r, color.g, color.b, direction.x, direction.y, direction.z);
    }

    public AmbientCubemap add(float r2, float g2, float b2, Vector3 direction) {
        return this.add(r2, g2, b2, direction.x, direction.y, direction.z);
    }

    public AmbientCubemap add(Color color, float x2, float y2, float z2) {
        return this.add(color.r, color.g, color.b, x2, y2, z2);
    }

    public AmbientCubemap add(Color color, Vector3 point, Vector3 target) {
        return this.add(color.r, color.g, color.b, target.x - point.x, target.y - point.y, target.z - point.z);
    }

    public AmbientCubemap add(Color color, Vector3 point, Vector3 target, float intensity) {
        float t2 = intensity / (1.0f + target.dst(point));
        return this.add(color.r * t2, color.g * t2, color.b * t2, target.x - point.x, target.y - point.y, target.z - point.z);
    }

    public String toString() {
        String result = "";
        for (int i2 = 0; i2 < this.data.length; i2 += 3) {
            result = result + Float.toString(this.data[i2]) + ", " + Float.toString(this.data[i2 + 1]) + ", " + Float.toString(this.data[i2 + 2]) + "\n";
        }
        return result;
    }
}

