/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.environment;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.math.Vector3;

public class PointLight
extends BaseLight<PointLight> {
    public final Vector3 position = new Vector3();
    public float intensity;

    public PointLight setPosition(float positionX, float positionY, float positionZ) {
        this.position.set(positionX, positionY, positionZ);
        return this;
    }

    public PointLight setPosition(Vector3 position) {
        this.position.set(position);
        return this;
    }

    public PointLight setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }

    public PointLight set(PointLight copyFrom) {
        return this.set(copyFrom.color, copyFrom.position, copyFrom.intensity);
    }

    public PointLight set(Color color, Vector3 position, float intensity) {
        if (color != null) {
            this.color.set(color);
        }
        if (position != null) {
            this.position.set(position);
        }
        this.intensity = intensity;
        return this;
    }

    public PointLight set(float r2, float g2, float b2, Vector3 position, float intensity) {
        this.color.set(r2, g2, b2, 1.0f);
        if (position != null) {
            this.position.set(position);
        }
        this.intensity = intensity;
        return this;
    }

    public PointLight set(Color color, float x2, float y2, float z2, float intensity) {
        if (color != null) {
            this.color.set(color);
        }
        this.position.set(x2, y2, z2);
        this.intensity = intensity;
        return this;
    }

    public PointLight set(float r2, float g2, float b2, float x2, float y2, float z2, float intensity) {
        this.color.set(r2, g2, b2, 1.0f);
        this.position.set(x2, y2, z2);
        this.intensity = intensity;
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof PointLight ? this.equals((PointLight)obj) : false;
    }

    public boolean equals(PointLight other) {
        return other != null && (other == this || this.color.equals(other.color) && this.position.equals(other.position) && this.intensity == other.intensity);
    }
}

