/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.GdxRuntimeException;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            String place = null;
            try {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i2 = 0; i2 < stack.length; ++i2) {
                    if (!"check".equals(stack[i2].getMethodName())) continue;
                    if (i2 + 1 < stack.length) {
                        StackTraceElement glMethod = stack[i2 + 1];
                        place = glMethod.getMethodName();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (place != null) {
                Gdx.app.error("GLProfiler", "Error " + GLProfiler.resolveErrorNumber(error) + " from " + place);
            } else {
                Gdx.app.error("GLProfiler", "Error " + GLProfiler.resolveErrorNumber(error) + " at: ", new Exception());
            }
        }
    };
    public static final GLErrorListener THROWING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            throw new GdxRuntimeException("GLProfiler: Got GL error " + GLProfiler.resolveErrorNumber(error));
        }
    };

    public void onError(int var1);
}

