/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class ConvexHull {
    private final IntArray quicksortStack = new IntArray();
    private float[] sortedPoints;
    private final FloatArray hull = new FloatArray();
    private final IntArray indices = new IntArray();
    private final ShortArray originalIndices = new ShortArray(false, 0);

    public FloatArray computePolygon(FloatArray points, boolean sorted) {
        return this.computePolygon(points.items, 0, points.size, sorted);
    }

    public FloatArray computePolygon(float[] polygon, boolean sorted) {
        return this.computePolygon(polygon, 0, polygon.length, sorted);
    }

    public FloatArray computePolygon(float[] points, int offset, int count, boolean sorted) {
        int i2;
        int end = offset + count;
        if (!sorted) {
            if (this.sortedPoints == null || this.sortedPoints.length < count) {
                this.sortedPoints = new float[count];
            }
            System.arraycopy(points, offset, this.sortedPoints, 0, count);
            points = this.sortedPoints;
            offset = 0;
            this.sort(points, count);
        }
        FloatArray hull = this.hull;
        hull.clear();
        for (i2 = offset; i2 < end; i2 += 2) {
            float x2 = points[i2];
            float y2 = points[i2 + 1];
            while (hull.size >= 4 && this.ccw(x2, y2) <= 0.0f) {
                hull.size -= 2;
            }
            hull.add(x2);
            hull.add(y2);
        }
        int t2 = hull.size + 2;
        for (i2 = end - 4; i2 >= offset; i2 -= 2) {
            float x3 = points[i2];
            float y3 = points[i2 + 1];
            while (hull.size >= t2 && this.ccw(x3, y3) <= 0.0f) {
                hull.size -= 2;
            }
            hull.add(x3);
            hull.add(y3);
        }
        return hull;
    }

    public IntArray computeIndices(FloatArray points, boolean sorted, boolean yDown) {
        return this.computeIndices(points.items, 0, points.size, sorted, yDown);
    }

    public IntArray computeIndices(float[] polygon, boolean sorted, boolean yDown) {
        return this.computeIndices(polygon, 0, polygon.length, sorted, yDown);
    }

    public IntArray computeIndices(float[] points, int offset, int count, boolean sorted, boolean yDown) {
        int end = offset + count;
        if (!sorted) {
            if (this.sortedPoints == null || this.sortedPoints.length < count) {
                this.sortedPoints = new float[count];
            }
            System.arraycopy(points, offset, this.sortedPoints, 0, count);
            points = this.sortedPoints;
            offset = 0;
            this.sortWithIndices(points, count, yDown);
        }
        IntArray indices = this.indices;
        indices.clear();
        FloatArray hull = this.hull;
        hull.clear();
        int i2 = offset;
        int index = i2 / 2;
        while (i2 < end) {
            float x2 = points[i2];
            float y2 = points[i2 + 1];
            while (hull.size >= 4 && this.ccw(x2, y2) <= 0.0f) {
                hull.size -= 2;
                --indices.size;
            }
            hull.add(x2);
            hull.add(y2);
            indices.add(index);
            i2 += 2;
            ++index;
        }
        i2 = end - 4;
        index = i2 / 2;
        int t2 = hull.size + 2;
        while (i2 >= offset) {
            float x3 = points[i2];
            float y3 = points[i2 + 1];
            while (hull.size >= t2 && this.ccw(x3, y3) <= 0.0f) {
                hull.size -= 2;
                --indices.size;
            }
            hull.add(x3);
            hull.add(y3);
            indices.add(index);
            i2 -= 2;
            --index;
        }
        if (!sorted) {
            short[] originalIndicesArray = this.originalIndices.items;
            int[] indicesArray = indices.items;
            int n2 = indices.size;
            for (int i3 = 0; i3 < n2; ++i3) {
                indicesArray[i3] = originalIndicesArray[indicesArray[i3]];
            }
        }
        return indices;
    }

    private float ccw(float p3x, float p3y) {
        FloatArray hull = this.hull;
        int size = hull.size;
        float p1x = hull.get(size - 4);
        float p1y = hull.get(size - 3);
        float p2x = hull.get(size - 2);
        float p2y = hull.peek();
        return (p2x - p1x) * (p3y - p1y) - (p2y - p1y) * (p3x - p1x);
    }

    private void sort(float[] values, int count) {
        int lower = 0;
        int upper = count - 1;
        IntArray stack = this.quicksortStack;
        stack.add(lower);
        stack.add(upper - 1);
        while (stack.size > 0) {
            upper = stack.pop();
            if (upper <= (lower = stack.pop())) continue;
            int i2 = this.quicksortPartition(values, lower, upper);
            if (i2 - lower > upper - i2) {
                stack.add(lower);
                stack.add(i2 - 2);
            }
            stack.add(i2 + 2);
            stack.add(upper);
            if (upper - i2 < i2 - lower) continue;
            stack.add(lower);
            stack.add(i2 - 2);
        }
    }

    private int quicksortPartition(float[] values, int lower, int upper) {
        float x2 = values[lower];
        float y2 = values[lower + 1];
        int up = upper;
        int down = lower;
        while (down < up) {
            while (down < up && values[down] <= x2) {
                down += 2;
            }
            while (values[up] > x2 || values[up] == x2 && values[up + 1] < y2) {
                up -= 2;
            }
            if (down >= up) continue;
            float temp = values[down];
            values[down] = values[up];
            values[up] = temp;
            temp = values[down + 1];
            values[down + 1] = values[up + 1];
            values[up + 1] = temp;
        }
        values[lower] = values[up];
        values[up] = x2;
        values[lower + 1] = values[up + 1];
        values[up + 1] = y2;
        return up;
    }

    private void sortWithIndices(float[] values, int count, boolean yDown) {
        int pointCount = count / 2;
        this.originalIndices.clear();
        this.originalIndices.ensureCapacity(pointCount);
        short[] originalIndicesArray = this.originalIndices.items;
        for (int i2 = 0; i2 < pointCount; i2 = (int)((short)(i2 + 1))) {
            originalIndicesArray[i2] = i2;
        }
        int lower = 0;
        int upper = count - 1;
        IntArray stack = this.quicksortStack;
        stack.add(lower);
        stack.add(upper - 1);
        while (stack.size > 0) {
            upper = stack.pop();
            if (upper <= (lower = stack.pop())) continue;
            int i3 = this.quicksortPartitionWithIndices(values, lower, upper, yDown, originalIndicesArray);
            if (i3 - lower > upper - i3) {
                stack.add(lower);
                stack.add(i3 - 2);
            }
            stack.add(i3 + 2);
            stack.add(upper);
            if (upper - i3 < i3 - lower) continue;
            stack.add(lower);
            stack.add(i3 - 2);
        }
    }

    private int quicksortPartitionWithIndices(float[] values, int lower, int upper, boolean yDown, short[] originalIndices) {
        short tempIndex;
        float x2 = values[lower];
        float y2 = values[lower + 1];
        int up = upper;
        int down = lower;
        while (down < up) {
            while (down < up && values[down] <= x2) {
                down += 2;
            }
            if (yDown) {
                while (values[up] > x2 || values[up] == x2 && values[up + 1] < y2) {
                    up -= 2;
                }
            } else {
                while (values[up] > x2 || values[up] == x2 && values[up + 1] > y2) {
                    up -= 2;
                }
            }
            if (down >= up) continue;
            float temp = values[down];
            values[down] = values[up];
            values[up] = temp;
            temp = values[down + 1];
            values[down + 1] = values[up + 1];
            values[up + 1] = temp;
            tempIndex = originalIndices[down / 2];
            originalIndices[down / 2] = originalIndices[up / 2];
            originalIndices[up / 2] = tempIndex;
        }
        values[lower] = values[up];
        values[up] = x2;
        values[lower + 1] = values[up + 1];
        values[up + 1] = y2;
        tempIndex = originalIndices[lower / 2];
        originalIndices[lower / 2] = originalIndices[up / 2];
        originalIndices[up / 2] = tempIndex;
        return up;
    }
}

