/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import java.io.Serializable;

public class GridPoint2
implements Serializable {
    private static final long serialVersionUID = -4019969926331717380L;
    public int x;
    public int y;

    public GridPoint2() {
    }

    public GridPoint2(int x2, int y2) {
        this.x = x2;
        this.y = y2;
    }

    public GridPoint2(GridPoint2 point) {
        this.x = point.x;
        this.y = point.y;
    }

    public GridPoint2 set(GridPoint2 point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public GridPoint2 set(int x2, int y2) {
        this.x = x2;
        this.y = y2;
        return this;
    }

    public float dst2(GridPoint2 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        return xd * xd + yd * yd;
    }

    public float dst2(int x2, int y2) {
        int xd = x2 - this.x;
        int yd = y2 - this.y;
        return xd * xd + yd * yd;
    }

    public float dst(GridPoint2 other) {
        int xd = other.x - this.x;
        int yd = other.y - this.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public float dst(int x2, int y2) {
        int xd = x2 - this.x;
        int yd = y2 - this.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public GridPoint2 add(GridPoint2 other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public GridPoint2 add(int x2, int y2) {
        this.x += x2;
        this.y += y2;
        return this;
    }

    public GridPoint2 sub(GridPoint2 other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public GridPoint2 sub(int x2, int y2) {
        this.x -= x2;
        this.y -= y2;
        return this;
    }

    public GridPoint2 cpy() {
        return new GridPoint2(this);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        GridPoint2 g2 = (GridPoint2)o2;
        return this.x == g2.x && this.y == g2.y;
    }

    public int hashCode() {
        int prime = 53;
        int result = 1;
        result = 53 * result + this.x;
        result = 53 * result + this.y;
        return result;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

